/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ.providers;

import com.amazonaws.athena.connector.integ.data.ConnectorPackagingAttributes;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorPackagingAttributesProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorPackagingAttributesProvider.class);
    private static final String CF_TEMPLATE_NAME = "packaged.yaml";
    private static final String LAMBDA_CODE_URI_TAG = "CodeUri:";
    private static final String LAMBDA_SPILL_BUCKET_PREFIX = "s3://";
    private static final String LAMBDA_HANDLER_TAG = "Handler:";
    private static final String LAMBDA_HANDLER_PREFIX = "Handler: ";

    private ConnectorPackagingAttributesProvider() {
    }

    public static ConnectorPackagingAttributes getAttributes() throws RuntimeException {
        String s3Bucket = "";
        String s3Key = "";
        String lambdaFunctionHandler = "";
        try {
            for (String line : Files.readAllLines(Paths.get(CF_TEMPLATE_NAME, new String[0]), StandardCharsets.UTF_8)) {
                if (line.contains(LAMBDA_CODE_URI_TAG)) {
                    s3Bucket = line.substring(line.indexOf(LAMBDA_SPILL_BUCKET_PREFIX) + LAMBDA_SPILL_BUCKET_PREFIX.length(), line.lastIndexOf(47));
                    s3Key = line.substring(line.lastIndexOf(47) + 1);
                    continue;
                }
                if (!line.contains(LAMBDA_HANDLER_TAG)) continue;
                lambdaFunctionHandler = line.substring(line.indexOf(LAMBDA_HANDLER_PREFIX) + LAMBDA_HANDLER_PREFIX.length());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Lambda connector has not been packaged via `sam package` (see README).", e);
        }
        logger.info("S3 Bucket: [{}], S3 Key: [{}], Handler: [{}]", new Object[]{s3Bucket, s3Key, lambdaFunctionHandler});
        return new ConnectorPackagingAttributes(s3Bucket, s3Key, lambdaFunctionHandler);
    }
}

