/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ.providers;

import com.amazonaws.athena.connector.integ.data.ConnectorVpcAttributes;
import com.amazonaws.athena.connector.integ.data.ConnectorVpcSubnetAttributes;
import com.amazonaws.athena.connector.integ.data.TestConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorVpcAttributesProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorVpcAttributesProvider.class);
    private static final String TEST_CONFIG_VPC_CONFIGURATION = "vpc_configuration";
    private static final String TEST_CONFIG_VPC_ID = "vpc_id";
    private static final String TEST_CONFIG_SECURITY_GROUP_ID = "security_group_id";
    private static final String TEST_CONFIG_SUBNET_IDS = "subnet_ids";
    private static final String TEST_CONFIG_AVAILABILITY_ZONES = "availability_zones";

    private ConnectorVpcAttributesProvider() {
    }

    public static Optional<ConnectorVpcAttributes> getAttributes(TestConfig testConfig) throws RuntimeException {
        Map<String, Object> vpcConfig = testConfig.getMap(TEST_CONFIG_VPC_CONFIGURATION).orElseThrow(() -> new RuntimeException("vpc_configuration map must be specified in test-config.json"));
        Object vpcId = vpcConfig.get(TEST_CONFIG_VPC_ID);
        if (!(vpcId instanceof String) || ((String)vpcId).isEmpty()) {
            logger.info("VPC Id is not set in test-config.json");
            return Optional.empty();
        }
        Object securityGroupId = vpcConfig.get(TEST_CONFIG_SECURITY_GROUP_ID);
        if (!(securityGroupId instanceof String) || ((String)securityGroupId).isEmpty()) {
            logger.info("Security Group Id is not set in test-config.json");
            return Optional.empty();
        }
        Object subnetIds = vpcConfig.get(TEST_CONFIG_SUBNET_IDS);
        if (!(subnetIds instanceof List) || ((List)subnetIds).isEmpty()) {
            logger.info("Subnet Ids are not set in test-config.json");
            return Optional.empty();
        }
        Object availabilityZones = vpcConfig.get(TEST_CONFIG_AVAILABILITY_ZONES);
        if (!(availabilityZones instanceof List) || ((List)availabilityZones).isEmpty()) {
            logger.info("Availability Zones are not set in test-config.json");
            return Optional.empty();
        }
        ConnectorVpcSubnetAttributes subnetAttributes = new ConnectorVpcSubnetAttributes((List)subnetIds, (List)availabilityZones);
        logger.info("VPC Id: [{}], SG: [{}], {}", new Object[]{vpcId, securityGroupId, subnetAttributes});
        return Optional.of(new ConnectorVpcAttributes((String)vpcId, (String)securityGroupId, subnetAttributes));
    }
}

