/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ.providers;

import com.amazonaws.athena.connector.integ.data.SecretsManagerCredentials;
import com.amazonaws.athena.connector.integ.data.TestConfig;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SecretsManagerCredentialsProvider {
    private static final String TEST_CONFIG_SECRETS_MANAGER_SECRET = "secrets_manager_secret";

    private SecretsManagerCredentialsProvider() {
    }

    public static Optional<SecretsManagerCredentials> getCredentials(TestConfig testConfig) throws RuntimeException {
        Optional<String> secretsManagerSecret = testConfig.getStringItem(TEST_CONFIG_SECRETS_MANAGER_SECRET);
        if (secretsManagerSecret.isPresent()) {
            String secret = secretsManagerSecret.get();
            AWSSecretsManager secretsManager = AWSSecretsManagerClientBuilder.defaultClient();
            try {
                GetSecretValueResult secretValueResult = secretsManager.getSecretValue(new GetSecretValueRequest().withSecretId(secret));
                ObjectMapper objectMapper = new ObjectMapper();
                Map credentials = (Map)objectMapper.readValue(secretValueResult.getSecretString(), HashMap.class);
                Optional<SecretsManagerCredentials> optional = Optional.of(new SecretsManagerCredentials(secret, (String)credentials.get("username"), (String)credentials.get("password"), secretValueResult.getARN()));
                return optional;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to parse SecretsManager secret (%s): %s", secret, e.getMessage()), e);
            }
            finally {
                secretsManager.shutdown();
            }
        }
        return Optional.empty();
    }
}

