/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ.stacks;

import com.amazonaws.athena.connector.integ.data.ConnectorPackagingAttributes;
import com.amazonaws.athena.connector.integ.data.ConnectorStackAttributes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awscdk.core.CfnParameter;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.services.athena.CfnDataCatalog;
import software.amazon.awscdk.services.iam.Effect;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.iam.ServicePrincipal;
import software.amazon.awscdk.services.lambda.CfnParametersCodeProps;
import software.amazon.awscdk.services.lambda.Code;
import software.amazon.awscdk.services.lambda.Function;
import software.amazon.awscdk.services.lambda.Runtime;

public class ConnectorStack
extends Stack {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorStack.class);
    private static final String LAMBDA_SPILL_BUCKET_TAG = "spill_bucket";
    private final String s3Bucket;
    private final String s3Key;
    private final String functionHandler;
    private final String functionName;
    private final Optional<PolicyDocument> connectorAccessPolicy;
    private final Map<String, String> environmentVariables;
    private final String spillBucket;

    public ConnectorStack(Builder builder) {
        super((software.constructs.Construct)builder.scope, builder.id);
        this.s3Bucket = builder.connectorPackagingAttributes.getS3Bucket();
        this.s3Key = builder.connectorPackagingAttributes.getS3Key();
        this.functionHandler = builder.connectorPackagingAttributes.getLambdaFunctionHandler();
        this.functionName = builder.functionName;
        this.connectorAccessPolicy = builder.connectorAccessPolicy;
        this.environmentVariables = builder.environmentVariables;
        this.spillBucket = this.environmentVariables.get(LAMBDA_SPILL_BUCKET_TAG);
    }

    protected void initialize() {
        logger.info("Initializing stack: {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        Function function = this.createLambdaFunction();
        this.createAthenaDataCatalog(function);
    }

    private Function createLambdaFunction() {
        return this.lambdaFunctionBuilder().build();
    }

    protected Function.Builder lambdaFunctionBuilder() {
        return Function.Builder.create((software.constructs.Construct)this, (String)"LambdaConnector").functionName(this.functionName).role((IRole)this.createIamRole()).code((Code)Code.fromCfnParameters((CfnParametersCodeProps)CfnParametersCodeProps.builder().bucketNameParam(CfnParameter.Builder.create((software.constructs.Construct)this, (String)"BucketName").defaultValue((Object)this.s3Bucket).build()).objectKeyParam(CfnParameter.Builder.create((software.constructs.Construct)this, (String)"BucketKey").defaultValue((Object)this.s3Key).build()).build())).handler(this.functionHandler).runtime(new Runtime("java11")).memorySize((Number)3008).timeout(Duration.seconds((Number)900)).environment(this.environmentVariables);
    }

    private void createAthenaDataCatalog(Function function) {
        this.athenaDataCatalogBuilder(function.getFunctionArn()).build();
    }

    protected CfnDataCatalog.Builder athenaDataCatalogBuilder(String functionArn) {
        return CfnDataCatalog.Builder.create((Construct)this, (String)"AthenaDataCatalog").name(this.functionName).type("LAMBDA").parameters((Map)ImmutableMap.of((Object)"function", (Object)functionArn));
    }

    private Role createIamRole() {
        return this.iamRoleBuilder().build();
    }

    protected Role.Builder iamRoleBuilder() {
        HashMap<String, PolicyDocument> policies = new HashMap<String, PolicyDocument>();
        this.setAccessPolicies(policies);
        return Role.Builder.create((software.constructs.Construct)this, (String)"ConnectorConfigRole").assumedBy((IPrincipal)ServicePrincipal.Builder.create((String)"lambda.amazonaws.com").build()).inlinePolicies(policies);
    }

    protected void setAccessPolicies(Map<String, PolicyDocument> policies) {
        policies.put("GlueAthenaS3AccessPolicy", this.getGlueAthenaS3AccessPolicy());
        policies.put("S3SpillBucketAccessPolicy", this.getS3SpillBucketAccessPolicy());
        this.connectorAccessPolicy.ifPresent(policyDocument -> policies.put("ConnectorAccessPolicy", (PolicyDocument)policyDocument));
    }

    private PolicyDocument getGlueAthenaS3AccessPolicy() {
        ArrayList<String> statementActionsPolicy = new ArrayList<String>();
        statementActionsPolicy.add("glue:GetTableVersions");
        statementActionsPolicy.add("glue:GetPartitions");
        statementActionsPolicy.add("glue:GetTables");
        statementActionsPolicy.add("glue:GetTableVersion");
        statementActionsPolicy.add("glue:GetDatabases");
        statementActionsPolicy.add("glue:GetTable");
        statementActionsPolicy.add("glue:GetPartition");
        statementActionsPolicy.add("glue:GetDatabase");
        statementActionsPolicy.add("athena:GetQueryExecution");
        statementActionsPolicy.add("s3:ListAllMyBuckets");
        return PolicyDocument.Builder.create().statements((List)ImmutableList.of((Object)PolicyStatement.Builder.create().actions(statementActionsPolicy).resources((List)ImmutableList.of((Object)"*")).effect(Effect.ALLOW).build())).build();
    }

    private PolicyDocument getS3SpillBucketAccessPolicy() {
        ArrayList<String> statementActionsPolicy = new ArrayList<String>();
        statementActionsPolicy.add("s3:GetObject");
        statementActionsPolicy.add("s3:ListBucket");
        statementActionsPolicy.add("s3:GetBucketLocation");
        statementActionsPolicy.add("s3:GetObjectVersion");
        statementActionsPolicy.add("s3:PutObject");
        statementActionsPolicy.add("s3:PutObjectAcl");
        statementActionsPolicy.add("s3:GetLifecycleConfiguration");
        statementActionsPolicy.add("s3:PutLifecycleConfiguration");
        statementActionsPolicy.add("s3:DeleteObject");
        return PolicyDocument.Builder.create().statements((List)ImmutableList.of((Object)PolicyStatement.Builder.create().actions(statementActionsPolicy).resources((List)ImmutableList.of((Object)String.format("arn:aws:s3:::%s", this.spillBucket), (Object)String.format("arn:aws:s3:::%s/*", this.spillBucket))).effect(Effect.ALLOW).build())).build();
    }

    public static Stack buildWithAttributes(ConnectorStackAttributes attributes) {
        return ConnectorStack.builder().withAttributes(attributes).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Construct scope;
        private String id;
        private String functionName;
        private Optional<PolicyDocument> connectorAccessPolicy;
        private Map<String, String> environmentVariables;
        private ConnectorPackagingAttributes connectorPackagingAttributes;

        public Builder withAttributes(ConnectorStackAttributes attributes) {
            this.scope = attributes.getScope();
            this.id = attributes.getId();
            this.functionName = attributes.getLambdaFunctionName();
            this.connectorAccessPolicy = attributes.getConnectorAccessPolicy();
            this.environmentVariables = attributes.getEnvironmentVariables();
            this.connectorPackagingAttributes = attributes.getConnectorPackagingAttributes();
            return this;
        }

        public Stack build() {
            ConnectorStack stack = new ConnectorStack(this);
            stack.initialize();
            return stack;
        }
    }
}

