/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ.stacks;

import com.amazonaws.athena.connector.integ.data.ConnectorStackAttributes;
import com.amazonaws.athena.connector.integ.data.ConnectorVpcAttributes;
import com.amazonaws.athena.connector.integ.stacks.ConnectorStack;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.services.ec2.SecurityGroup;
import software.amazon.awscdk.services.ec2.Vpc;
import software.amazon.awscdk.services.ec2.VpcAttributes;
import software.amazon.awscdk.services.iam.Effect;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.lambda.Function;
import software.constructs.Construct;

public class ConnectorWithVpcStack
extends ConnectorStack {
    private final String vpcId;
    private final String securityGroupId;
    private final List<String> subnetIds;
    private final List<String> availabilityZones;

    public ConnectorWithVpcStack(Builder builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.securityGroupId = builder.securityGroupId;
        this.subnetIds = builder.subnetIds;
        this.availabilityZones = builder.availabilityZones;
    }

    @Override
    protected Function.Builder lambdaFunctionBuilder() {
        return super.lambdaFunctionBuilder().vpc(Vpc.fromVpcAttributes((Construct)this, (String)"VpcConfig", (VpcAttributes)this.createVpcAttributes())).securityGroups(Collections.singletonList(SecurityGroup.fromSecurityGroupId((Construct)this, (String)"VpcSecurityGroup", (String)this.securityGroupId)));
    }

    private VpcAttributes createVpcAttributes() {
        return this.vpcAttributesBuilder().build();
    }

    protected VpcAttributes.Builder vpcAttributesBuilder() {
        return VpcAttributes.builder().vpcId(this.vpcId).privateSubnetIds(this.subnetIds).availabilityZones(this.availabilityZones);
    }

    @Override
    protected void setAccessPolicies(Map<String, PolicyDocument> policies) {
        super.setAccessPolicies(policies);
        policies.put("VpcEc2AccessPolicy", this.getVpcEc2AccessPolicy());
    }

    private PolicyDocument getVpcEc2AccessPolicy() {
        ImmutableList statementActionsPolicy = ImmutableList.of((Object)"ec2:CreateNetworkInterface", (Object)"ec2:DescribeNetworkInterfaces", (Object)"ec2:DeleteNetworkInterface");
        return PolicyDocument.Builder.create().statements(Collections.singletonList(PolicyStatement.Builder.create().actions((List)statementActionsPolicy).resources(Collections.singletonList("*")).effect(Effect.ALLOW).build())).build();
    }

    public static Stack buildWithAttributes(ConnectorStackAttributes attributes) {
        return ConnectorWithVpcStack.builder().withAttributes(attributes).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ConnectorStack.Builder {
        private String vpcId;
        private String securityGroupId;
        private List<String> subnetIds;
        private List<String> availabilityZones;

        @Override
        public Builder withAttributes(ConnectorStackAttributes attributes) {
            super.withAttributes(attributes);
            ConnectorVpcAttributes vpcAttributes = attributes.getConnectorVpcAttributes().orElseThrow(() -> new RuntimeException("vpc_configuration must be provided in test-config.json"));
            this.vpcId = vpcAttributes.getVpcId();
            this.securityGroupId = vpcAttributes.getSecurityGroupId();
            this.subnetIds = vpcAttributes.getPrivateSubnetIds();
            this.availabilityZones = vpcAttributes.getAvailabilityZones();
            return this;
        }

        @Override
        public Stack build() {
            ConnectorWithVpcStack stack = new ConnectorWithVpcStack(this);
            stack.initialize();
            return stack;
        }
    }
}

