/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda;

import com.amazonaws.athena.connector.lambda.ThrottlingInvoker;
import com.amazonaws.athena.connector.lambda.data.BlockSpiller;
import com.amazonaws.athena.connector.lambda.exceptions.FederationThrottleException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ThrottlingInvokerTest {
    @Test
    public void invokeNoThrottle() throws TimeoutException {
        ThrottlingInvoker invoker = ThrottlingInvoker.newBuilder().withDecrease(0.5).withIncrease(10L).withInitialDelayMs(10L).withMaxDelayMs(2000L).withFilter(ex -> ex instanceof FederationThrottleException).build();
        for (int i = 0; i < 100; ++i) {
            int result = (Integer)invoker.invoke(() -> 2, 10000L);
            Assert.assertEquals((long)2L, (long)result);
            Assert.assertEquals((Object)ThrottlingInvoker.State.FAST_START, (Object)invoker.getState());
            Assert.assertEquals((long)0L, (long)invoker.getDelay());
        }
    }

    @Test
    public void invokeWithThrottle() throws TimeoutException {
        ThrottlingInvoker invoker = ThrottlingInvoker.newBuilder().withDecrease(0.8).withIncrease(1L).withInitialDelayMs(10L).withMaxDelayMs(200L).withFilter(ex -> ex instanceof FederationThrottleException).build();
        for (int i = 0; i < 5; ++i) {
            AtomicLong count = new AtomicLong(0L);
            int val = i;
            long result = ((Integer)invoker.invoke(() -> {
                if (count.incrementAndGet() < 4L) {
                    throw new FederationThrottleException();
                }
                return val;
            }, 10000L)).intValue();
            Assert.assertEquals((long)val, (long)result);
            Assert.assertEquals((long)4L, (long)count.get());
            Assert.assertEquals((Object)ThrottlingInvoker.State.AVOIDANCE, (Object)invoker.getState());
            Assert.assertTrue((invoker.getDelay() > 0L ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)199L, (long)invoker.getDelay());
    }

    @Test(expected=TimeoutException.class)
    public void invokeWithThrottleTimeout() throws TimeoutException {
        ThrottlingInvoker invoker = ThrottlingInvoker.newBuilder().withDecrease(0.5).withIncrease(10L).withInitialDelayMs(10L).withMaxDelayMs(500L).withFilter(ex -> ex instanceof FederationThrottleException).build();
        invoker.invoke(() -> {
            throw new FederationThrottleException();
        }, 2000L);
    }

    @Test(expected=FederationThrottleException.class)
    public void invokeWithThrottleNoSpill() throws TimeoutException {
        BlockSpiller spiller = (BlockSpiller)Mockito.mock(BlockSpiller.class);
        ThrottlingInvoker invoker = ThrottlingInvoker.newBuilder().withDecrease(0.5).withIncrease(10L).withInitialDelayMs(10L).withMaxDelayMs(500L).withFilter(ex -> ex instanceof RuntimeException).withSpiller(spiller).build();
        Mockito.when((Object)spiller.spilled()).thenReturn((Object)false);
        invoker.invoke(() -> {
            throw new RuntimeException();
        }, 2000L);
    }
}

