/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.ArrowSchemaUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.Assert;
import org.junit.Test;

public class ArrowSchemaUtilsTest {
    @Test
    public void testRemapTypeInStruct() {
        DictionaryEncoding bsdfDictionaryEncoding = new DictionaryEncoding(1111L, false, new ArrowType.Int(32, false));
        ImmutableMap bsdfMeta = ImmutableMap.of((Object)"11111111", (Object)"2222222222");
        FieldType bsdfType = new FieldType(true, (ArrowType)new ArrowType.Utf8(), bsdfDictionaryEncoding, (Map)bsdfMeta);
        Field bsdf = new Field("bsdf", bsdfType, null);
        DictionaryEncoding csdfDictionaryEncoding = new DictionaryEncoding(2222L, true, new ArrowType.Int(32, true));
        ImmutableMap csdfMeta = ImmutableMap.of((Object)"3333333333", (Object)"4444444444");
        FieldType csdfType = new FieldType(true, (ArrowType)new ArrowType.Decimal(12, 3, 32), csdfDictionaryEncoding, (Map)csdfMeta);
        Field csdf = new Field("csdf", csdfType, null);
        DictionaryEncoding asdfDictionaryEncoding = new DictionaryEncoding(33333L, false, new ArrowType.Int(64, false));
        ImmutableMap asdfMeta = ImmutableMap.of((Object)"55555555", (Object)"66666666");
        FieldType asdfFieldType = new FieldType(true, (ArrowType)new ArrowType.Struct(), asdfDictionaryEncoding, (Map)asdfMeta);
        Field asdf = new Field("asdf", asdfFieldType, (List)ImmutableList.of((Object)bsdf, (Object)csdf));
        DictionaryEncoding aasdfDictionaryEncoding = new DictionaryEncoding(44444L, true, new ArrowType.Int(64, true));
        ImmutableMap aasdfMeta = ImmutableMap.of((Object)"7777", (Object)"88888");
        FieldType aasdfFieldType = new FieldType(true, (ArrowType)new ArrowType.Struct(), aasdfDictionaryEncoding, (Map)aasdfMeta);
        Field aasdf = new Field("aasdf", aasdfFieldType, (List)ImmutableList.of((Object)asdf, (Object)bsdf, (Object)csdf));
        Function<ArrowType, ArrowType> arrowTypeMapper = arrowType -> {
            if (arrowType instanceof ArrowType.Utf8) {
                return new ArrowType.Decimal(24, 6, 32);
            }
            return arrowType;
        };
        Field outputField = ArrowSchemaUtils.remapArrowTypesWithinField((Field)aasdf, arrowTypeMapper);
        Assert.assertEquals((Object)"aasdf: Struct[dictionary: 44444]<asdf: Struct[dictionary: 33333]<bsdf: Decimal(24, 6, 32)[dictionary: 1111], csdf: Decimal(12, 3, 32)[dictionary: 2222]>, bsdf: Decimal(24, 6, 32)[dictionary: 1111], csdf: Decimal(12, 3, 32)[dictionary: 2222]>", (Object)outputField.toString());
        Assert.assertTrue((boolean)outputField.getFieldType().isNullable());
        Assert.assertEquals((Object)aasdfMeta, (Object)outputField.getFieldType().getMetadata());
        Field outputAsdf = (Field)outputField.getChildren().get(0);
        Assert.assertTrue((boolean)outputAsdf.getFieldType().isNullable());
        Assert.assertEquals((Object)asdfMeta, (Object)outputAsdf.getFieldType().getMetadata());
        Field innerOutputBsdf = (Field)((Field)outputField.getChildren().get(0)).getChildren().get(0);
        Assert.assertTrue((boolean)innerOutputBsdf.getFieldType().isNullable());
        Assert.assertEquals((Object)bsdfMeta, (Object)innerOutputBsdf.getFieldType().getMetadata());
        Field innerOutputCsdf = (Field)((Field)outputField.getChildren().get(0)).getChildren().get(1);
        Assert.assertTrue((boolean)innerOutputCsdf.getFieldType().isNullable());
        Assert.assertEquals((Object)csdfMeta, (Object)innerOutputCsdf.getFieldType().getMetadata());
        Field outputBsdf = (Field)outputField.getChildren().get(1);
        Assert.assertTrue((boolean)outputBsdf.getFieldType().isNullable());
        Assert.assertEquals((Object)bsdfMeta, (Object)outputBsdf.getFieldType().getMetadata());
        Field outputCsdf = (Field)outputField.getChildren().get(2);
        Assert.assertTrue((boolean)outputCsdf.getFieldType().isNullable());
        Assert.assertEquals((Object)csdfMeta, (Object)outputCsdf.getFieldType().getMetadata());
    }
}

