/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.FieldResolver;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.JsonStringHashMap;

class ArrowToArrowResolver
implements FieldResolver {
    ArrowToArrowResolver() {
    }

    public Object getFieldValue(Field field, Object originalValue) {
        if (originalValue.getClass().equals(KeyWithEquality.class)) {
            originalValue = ((KeyWithEquality)originalValue).key;
        }
        if (field.getType().getTypeID() == ArrowType.Map.TYPE_TYPE) {
            JsonStringArrayList input = originalValue.getClass().equals(JsonStringHashMap.class) ? (JsonStringArrayList)((Map)originalValue).get(field.getName()) : (JsonStringArrayList)originalValue;
            if (input == null) {
                return null;
            }
            LinkedHashMap<KeyWithEquality, Object> outputMap = new LinkedHashMap<KeyWithEquality, Object>();
            for (int i = 0; i < input.size(); ++i) {
                JsonStringHashMap inputMap = (JsonStringHashMap)input.get(i);
                outputMap.put(new KeyWithEquality(inputMap.get((Object)"key")), inputMap.get((Object)"value"));
            }
            return outputMap;
        }
        if (originalValue.getClass().equals(JsonStringHashMap.class) || originalValue.getClass().equals(Map.class)) {
            Object fieldValue = ((Map)originalValue).get(field.getName());
            return fieldValue;
        }
        return originalValue;
    }

    public Object getMapKey(Field field, Object originalValue) {
        return this.getFieldValue(field, originalValue);
    }

    public Object getMapValue(Field field, Object originalValue) {
        return this.getFieldValue(field, originalValue);
    }

    class KeyWithEquality {
        public Object key;

        KeyWithEquality(Object key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            return this.key == o;
        }
    }
}

