/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.DateTimeFormatterUtil;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockUtilsTest {
    private static final Logger logger = LoggerFactory.getLogger(BlockUtilsTest.class);
    private BlockAllocatorImpl allocator;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setup() {
        logger.info("{}: enter", (Object)this.testName.getMethodName());
        DateTimeFormatterUtil.enableTimezonePacking();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void after() {
        this.allocator.close();
        logger.info("{}: exit ", (Object)this.testName.getMethodName());
    }

    @Test
    public void copyRows() {
        for (TimeUnit timeUnit : ImmutableList.of((Object)TimeUnit.MILLISECOND, (Object)TimeUnit.MICROSECOND)) {
            if (timeUnit.equals((Object)TimeUnit.MICROSECOND)) {
                DateTimeFormatterUtil.disableTimezonePacking();
            }
            Schema schema = SchemaBuilder.newBuilder().addField("col1", (ArrowType)new ArrowType.Int(32, true)).addField("col2", (ArrowType)new ArrowType.Decimal(38, 9)).addField("col3", (ArrowType)new ArrowType.Timestamp(timeUnit, "UTC")).build();
            LocalDateTime ldt = LocalDateTime.of(2020, 3, 18, 12, 54, 29);
            Date date = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
            Block src = this.allocator.createBlock(schema);
            BlockUtils.setValue((FieldVector)src.getFieldVector("col1"), (int)0, (Object)10);
            BlockUtils.setValue((FieldVector)src.getFieldVector("col2"), (int)0, (Object)new BigDecimal(20));
            BlockUtils.setValue((FieldVector)src.getFieldVector("col3"), (int)0, (Object)ldt);
            BlockUtils.setValue((FieldVector)src.getFieldVector("col1"), (int)1, (Object)11);
            BlockUtils.setValue((FieldVector)src.getFieldVector("col2"), (int)1, (Object)new BigDecimal(21));
            BlockUtils.setValue((FieldVector)src.getFieldVector("col3"), (int)1, (Object)ZonedDateTime.of(ldt, ZoneId.of("-05:00")));
            BlockUtils.setValue((FieldVector)src.getFieldVector("col1"), (int)2, (Object)12);
            BlockUtils.setValue((FieldVector)src.getFieldVector("col2"), (int)2, (Object)new BigDecimal(22));
            BlockUtils.setValue((FieldVector)src.getFieldVector("col3"), (int)2, (Object)date);
            src.setRowCount(3);
            Block dst = this.allocator.createBlock(schema);
            Assert.assertEquals((long)3L, (long)BlockUtils.copyRows((Block)src, (Block)dst, (int)0, (int)2));
            Assert.assertEquals((Object)src, (Object)dst);
        }
    }

    @Test
    public void isNullRow() {
        for (TimeUnit timeUnit : ImmutableList.of((Object)TimeUnit.MILLISECOND, (Object)TimeUnit.MICROSECOND)) {
            if (timeUnit.equals((Object)TimeUnit.MICROSECOND)) {
                DateTimeFormatterUtil.disableTimezonePacking();
            }
            Schema schema = SchemaBuilder.newBuilder().addField("col1", (ArrowType)new ArrowType.Int(32, true)).addField("col2", (ArrowType)new ArrowType.Int(32, true)).addField("col3", (ArrowType)new ArrowType.Timestamp(timeUnit, "UTC")).build();
            LocalDateTime ldt = LocalDateTime.now();
            Block block = this.allocator.createBlock(schema);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col1"), (int)0, (Object)10);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col2"), (int)0, (Object)20);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col3"), (int)0, (Object)ldt);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col1"), (int)1, (Object)11);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col2"), (int)1, (Object)21);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col3"), (int)1, (Object)ZonedDateTime.of(ldt, ZoneId.of("-05:00")));
            block.setRowCount(2);
            Assert.assertFalse((boolean)BlockUtils.isNullRow((Block)block, (int)1));
            BlockUtils.unsetRow((int)1, (Block)block);
            Assert.assertTrue((boolean)BlockUtils.isNullRow((Block)block, (int)1));
        }
    }

    @Test
    public void fieldToString() throws ParseException {
        for (TimeUnit timeUnit : ImmutableList.of((Object)TimeUnit.MILLISECOND, (Object)TimeUnit.MICROSECOND)) {
            String expectedString = "Block{rows=2, col1=[10, 11], col2=[2020-03-18T12:54:29Z[UTC], 2020-03-18T12:54:29-05:00], col3=[2020-03-18, 2019-12-29]}";
            if (timeUnit.equals((Object)TimeUnit.MICROSECOND)) {
                DateTimeFormatterUtil.disableTimezonePacking();
                expectedString = "Block{rows=2, col1=[10, 11], col2=[2020-03-18T12:54:29Z[UTC], 2020-03-18T17:54:29Z[UTC]], col3=[2020-03-18, 2019-12-29]}";
            }
            Schema schema = SchemaBuilder.newBuilder().addField("col1", (ArrowType)new ArrowType.Int(32, true)).addField("col2", (ArrowType)new ArrowType.Timestamp(timeUnit, "UTC")).addField("col3", (ArrowType)new ArrowType.Date(DateUnit.DAY)).build();
            LocalDateTime ldt = LocalDateTime.of(2020, 3, 18, 12, 54, 29);
            Block block = this.allocator.createBlock(schema);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col1"), (int)0, (Object)10);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col2"), (int)0, (Object)ldt);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col3"), (int)0, (Object)Timestamp.valueOf(ldt));
            BlockUtils.setValue((FieldVector)block.getFieldVector("col1"), (int)1, (Object)11);
            BlockUtils.setValue((FieldVector)block.getFieldVector("col2"), (int)1, (Object)ZonedDateTime.of(ldt, ZoneId.of("-05:00")));
            BlockUtils.setValue((FieldVector)block.getFieldVector("col3"), (int)1, (Object)new SimpleDateFormat("yyyy-MM-dd").parse("2019-12-29"));
            block.setRowCount(2);
            String actual = block.toString();
            Assert.assertEquals((Object)expectedString, (Object)actual);
        }
    }

    @Test
    public void canSetDate() {
        Schema schema = SchemaBuilder.newBuilder().addField("col1", (ArrowType)new ArrowType.Date(DateUnit.DAY)).build();
        LocalDate date = LocalDate.parse("1998-01-01");
        Block block = this.allocator.createBlock(schema);
        BlockUtils.setValue((FieldVector)block.getFieldVector("col1"), (int)0, (Object)date);
    }
}

