/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.DateTimeFormatterUtil;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.vector.holders.TimeStampMicroTZHolder;
import org.apache.arrow.vector.holders.TimeStampMilliTZHolder;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeFormatterUtilTest {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeFormatterUtilTest.class);
    private static final ZoneId DEFAULT_TIME_ZONE = ZoneId.of("UTC");
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() {
        logger.info("{}: enter", (Object)this.testName.getMethodName());
        DateTimeFormatterUtil.enableTimezonePacking();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @After
    public void tearDown() {
        logger.info("{}: exit ", (Object)this.testName.getMethodName());
    }

    @Test
    public void stringToLocalDateTest() {
        LocalDate expected = LocalDate.of(2020, 2, 27);
        LocalDate actual = DateTimeFormatterUtil.stringToLocalDate((String)"27022020", (String)"ddMMyyyy", (ZoneId)DEFAULT_TIME_ZONE);
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToLocalDate((String)"2020-02-27", null, (ZoneId)DEFAULT_TIME_ZONE));
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToLocalDate((String)"27--02-2020", (String)"ddMMyyyy", (ZoneId)DEFAULT_TIME_ZONE));
    }

    @Test
    public void stringToLocalDateTestCustomerConfiguredFormatFail() {
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToLocalDate((String)"27--02-2020", (String)"ddMMyyyy", (ZoneId)DEFAULT_TIME_ZONE));
    }

    @Test
    public void stringToZonedDateTimeTest() {
        LocalDateTime localDateTimeExpected = LocalDateTime.of(2015, 12, 21, 17, 42, 34, 0);
        ZonedDateTime expected = ZonedDateTime.of(localDateTimeExpected, ZoneId.of("-05:00"));
        Assert.assertEquals((Object)expected, (Object)DateTimeFormatterUtil.stringToZonedDateTime((String)"2015-12-21T17:42:34-05:00", null, null));
        Assert.assertEquals((Object)localDateTimeExpected, (Object)DateTimeFormatterUtil.stringToZonedDateTime((String)"2015-12-21T17:42:34", (String)"yyyy-MM-dd'T'HH:mm:ss", (ZoneId)ZoneId.of("UTC")));
    }

    @Test
    public void stringTolDateTimeTest() {
        LocalDateTime expected = LocalDateTime.of(2020, 2, 27, 0, 2, 27);
        Assert.assertEquals((Object)expected, (Object)DateTimeFormatterUtil.stringToDateTime((String)"00:02:27S2020-02-27", (String)"HH:mm:ss'S'yyyy-MM-dd", (ZoneId)DEFAULT_TIME_ZONE));
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToDateTime((String)"00:02:27S2020-02-27", null, (ZoneId)DEFAULT_TIME_ZONE));
    }

    @Test
    public void stringToDateTimeTestCustomerConfiguredFormatFail() {
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToDateTime((String)"00:02:27S2020---02-27", (String)"HH:mm:ss'S'yyyy-MM-dd", (ZoneId)DEFAULT_TIME_ZONE));
    }

    @Test
    public void bigDecimalToLocalDateTest() {
        LocalDate expected = LocalDate.of(2020, 2, 27);
        Instant instant = expected.atTime(LocalTime.MIDNIGHT).atZone(DEFAULT_TIME_ZONE).toInstant();
        Assert.assertEquals((Object)expected, (Object)DateTimeFormatterUtil.bigDecimalToLocalDate((BigDecimal)new BigDecimal(instant.toEpochMilli()), (ZoneId)DEFAULT_TIME_ZONE));
        Assert.assertNull((Object)DateTimeFormatterUtil.bigDecimalToLocalDate(null, null));
    }

    @Test
    public void bigDecimalToLocalDateTimeTest() {
        LocalDateTime expected = LocalDateTime.of(2020, 2, 27, 0, 2, 27);
        Instant instant = expected.atZone(DEFAULT_TIME_ZONE).toInstant();
        Assert.assertEquals((Object)expected, (Object)DateTimeFormatterUtil.bigDecimalToLocalDateTime((BigDecimal)new BigDecimal(instant.toEpochMilli()), (ZoneId)DEFAULT_TIME_ZONE));
        Assert.assertNull((Object)DateTimeFormatterUtil.bigDecimalToLocalDateTime(null, null));
    }

    @Test
    public void inferDateTimeFormatTest() {
        String inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020-02-27");
        Assert.assertEquals((Object)"yyyy-MM-dd", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020-02-27T00:02:27");
        Assert.assertEquals((Object)"yyyy-MM-dd'T'HH:mm:ss", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020-02-27T00:02:27Z");
        Assert.assertEquals((Object)"yyyy-MM-dd'T'HH:mm:ssZZ", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020-02-27T00:02:27-05:00");
        Assert.assertEquals((Object)"yyyy-MM-dd'T'HH:mm:ssZZ", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"20200227T000227");
        Assert.assertEquals((Object)"yyyyMMdd'T'HHmmss", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"20200227T000227Z");
        Assert.assertEquals((Object)"yyyyMMdd'T'HHmmssZZ", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020202020202020202020");
        Assert.assertNull((Object)inferredDateFormat);
    }

    @Test
    public void timestampMilliTzHolderFromObject() {
        ArrowType.Timestamp arrowType = new ArrowType.Timestamp(org.apache.arrow.vector.types.TimeUnit.MILLISECOND, "-05:00");
        long expectedPackedLong = 5942221840384541L;
        LocalDateTime localDateTimeExpected = LocalDateTime.of(2015, 12, 21, 17, 42, 34, 0);
        ZoneId zoneIdExpected = ZoneId.of("-05:00");
        ZonedDateTime expectedZdt = ZonedDateTime.of(localDateTimeExpected, zoneIdExpected);
        long expectedUnpackedLong = expectedZdt.toInstant().toEpochMilli();
        Assert.assertEquals((long)expectedPackedLong, (long)DateTimeFormatterUtil.timestampMilliTzHolderFromObject((Object)expectedZdt, null).value);
        Assert.assertEquals((Object)expectedZdt, (Object)DateTimeFormatterUtil.constructZonedDateTime((long)expectedPackedLong, (ArrowType.Timestamp)arrowType));
        DateTimeFormatterUtil.disableTimezonePacking();
        TimeStampMilliTZHolder holder = DateTimeFormatterUtil.timestampMilliTzHolderFromObject((Object)expectedZdt, null);
        Assert.assertEquals((long)expectedUnpackedLong, (long)holder.value);
        Assert.assertEquals((Object)"-05:00", (Object)holder.timezone);
        Assert.assertNotEquals((long)expectedPackedLong, (long)holder.value);
        Assert.assertEquals((Object)expectedZdt, (Object)DateTimeFormatterUtil.constructZonedDateTime((long)expectedUnpackedLong, (ArrowType.Timestamp)arrowType));
    }

    @Test
    public void timestampMicroTzHolderFromObject() {
        long expectedMicros = 2134123412348117L + TimeUnit.HOURS.toMicros(5L);
        Instant expectedInstant = Instant.EPOCH.plus(expectedMicros, ChronoUnit.MICROS);
        LocalDateTime localDateTimeExpected = LocalDateTime.of(2037, 8, 17, 12, 3, 32, (int)TimeUnit.MICROSECONDS.toNanos(348117L));
        ZoneId zoneIdExpected = ZoneId.of("-05:00");
        ZonedDateTime expectedZdt = ZonedDateTime.of(localDateTimeExpected, zoneIdExpected);
        Assert.assertEquals((Object)expectedInstant, (Object)expectedZdt.toInstant());
        try {
            DateTimeFormatterUtil.timestampMicroTzHolderFromObject((Object)expectedZdt, null);
            Assert.fail((String)"Exception was expected since packing should not work for microseconds");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        DateTimeFormatterUtil.disableTimezonePacking();
        TimeStampMicroTZHolder holder = DateTimeFormatterUtil.timestampMicroTzHolderFromObject((Object)expectedZdt, null);
        Assert.assertEquals((long)expectedMicros, (long)holder.value);
        Assert.assertEquals((Object)"-05:00", (Object)holder.timezone);
        ArrowType.Timestamp arrowType = new ArrowType.Timestamp(org.apache.arrow.vector.types.TimeUnit.MICROSECOND, "-05:00");
        Assert.assertEquals((Object)expectedZdt, (Object)DateTimeFormatterUtil.constructZonedDateTime((long)expectedMicros, (ArrowType.Timestamp)arrowType));
    }

    @Test
    public void dateTimePackingRoundTrip() {
        ImmutableList.of((Object)ZonedDateTime.ofInstant(Instant.ofEpochMilli(10L), ZoneOffset.UTC), (Object)ZonedDateTime.of(LocalDateTime.of(2015, 12, 21, 17, 42, 34, 0), ZoneOffset.UTC), (Object)ZonedDateTime.ofInstant(Instant.ofEpochMilli(45423958493L), ZoneOffset.of("-11:00"))).forEach(zonedDateTime -> {
            TimeStampMilliTZHolder holder = DateTimeFormatterUtil.timestampMilliTzHolderFromObject((Object)zonedDateTime, null);
            ArrowType.Timestamp arrowType = new ArrowType.Timestamp(org.apache.arrow.vector.types.TimeUnit.MILLISECOND, holder.timezone);
            ZonedDateTime zonedDateTimeBack = DateTimeFormatterUtil.constructZonedDateTime((long)holder.value, (ArrowType.Timestamp)arrowType);
            Assert.assertEquals((Object)zonedDateTime.getOffset(), (Object)zonedDateTimeBack.getOffset());
            Assert.assertEquals((Object)zonedDateTime.toInstant(), (Object)zonedDateTimeBack.toInstant());
        });
    }
}

