/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.S3BlockSpiller;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.data.SpillConfig;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintEvaluator;
import com.amazonaws.athena.connector.lambda.domain.spill.S3SpillLocation;
import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.security.EncryptionKeyFactory;
import com.amazonaws.athena.connector.lambda.security.LocalKeyFactory;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class S3BlockSpillerTest {
    private static final Logger logger = LoggerFactory.getLogger(S3BlockSpillerTest.class);
    private String bucket = "MyBucket";
    private String prefix = "blocks/spill";
    private String requestId = "requestId";
    private String splitId = "splitId";
    @Mock
    private AmazonS3 mockS3;
    private S3BlockSpiller blockWriter;
    private EncryptionKeyFactory keyFactory = new LocalKeyFactory();
    private Block expected;
    private BlockAllocatorImpl allocator;
    private SpillConfig spillConfig;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
        Schema schema = SchemaBuilder.newBuilder().addField("col1", (ArrowType)new ArrowType.Int(32, true)).addField("col2", (ArrowType)new ArrowType.Utf8()).build();
        this.spillConfig = SpillConfig.newBuilder().withEncryptionKey(this.keyFactory.create()).withRequestId(this.requestId).withSpillLocation((SpillLocation)S3SpillLocation.newBuilder().withBucket(this.bucket).withPrefix(this.prefix).withQueryId(this.requestId).withSplitId(this.splitId).withIsDirectory(true).build()).withRequestId(this.requestId).build();
        this.blockWriter = new S3BlockSpiller(this.mockS3, this.spillConfig, (BlockAllocator)this.allocator, schema, ConstraintEvaluator.emptyEvaluator(), (Map)ImmutableMap.of());
        this.expected = this.allocator.createBlock(schema);
        BlockUtils.setValue((FieldVector)this.expected.getFieldVector("col1"), (int)1, (Object)100);
        BlockUtils.setValue((FieldVector)this.expected.getFieldVector("col2"), (int)1, (Object)"VarChar");
        BlockUtils.setValue((FieldVector)this.expected.getFieldVector("col1"), (int)1, (Object)101);
        BlockUtils.setValue((FieldVector)this.expected.getFieldVector("col2"), (int)1, (Object)"VarChar1");
        this.expected.setRowCount(2);
    }

    @After
    public void tearDown() throws Exception {
        this.expected.close();
        this.allocator.close();
        this.blockWriter.close();
    }

    @Test
    public void spillTest() throws IOException {
        logger.info("spillTest: enter");
        logger.info("spillTest: starting write test");
        final ByteHolder byteHolder = new ByteHolder();
        ArgumentCaptor argument = ArgumentCaptor.forClass(PutObjectRequest.class);
        Mockito.when((Object)this.mockS3.putObject((PutObjectRequest)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                InputStream inputStream = ((PutObjectRequest)invocationOnMock.getArguments()[0]).getInputStream();
                byteHolder.setBytes(ByteStreams.toByteArray((InputStream)inputStream));
                return Mockito.mock(PutObjectResult.class);
            }
        });
        SpillLocation blockLocation = this.blockWriter.write(this.expected);
        if (blockLocation instanceof S3SpillLocation) {
            Assert.assertEquals((Object)this.bucket, (Object)((S3SpillLocation)blockLocation).getBucket());
            Assert.assertEquals((Object)(this.prefix + "/" + this.requestId + "/" + this.splitId + ".0"), (Object)((S3SpillLocation)blockLocation).getKey());
        }
        ((AmazonS3)Mockito.verify((Object)this.mockS3, (VerificationMode)Mockito.times((int)1))).putObject((PutObjectRequest)argument.capture());
        Assert.assertEquals((Object)((PutObjectRequest)argument.getValue()).getBucketName(), (Object)this.bucket);
        Assert.assertEquals((Object)((PutObjectRequest)argument.getValue()).getKey(), (Object)(this.prefix + "/" + this.requestId + "/" + this.splitId + ".0"));
        SpillLocation blockLocation2 = this.blockWriter.write(this.expected);
        if (blockLocation2 instanceof S3SpillLocation) {
            Assert.assertEquals((Object)this.bucket, (Object)((S3SpillLocation)blockLocation2).getBucket());
            Assert.assertEquals((Object)(this.prefix + "/" + this.requestId + "/" + this.splitId + ".1"), (Object)((S3SpillLocation)blockLocation2).getKey());
        }
        ((AmazonS3)Mockito.verify((Object)this.mockS3, (VerificationMode)Mockito.times((int)2))).putObject((PutObjectRequest)argument.capture());
        Assert.assertEquals((Object)((PutObjectRequest)argument.getValue()).getBucketName(), (Object)this.bucket);
        Assert.assertEquals((Object)((PutObjectRequest)argument.getValue()).getKey(), (Object)(this.prefix + "/" + this.requestId + "/" + this.splitId + ".1"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockS3});
        Mockito.reset((Object[])new AmazonS3[]{this.mockS3});
        logger.info("spillTest: Starting read test.");
        Mockito.when((Object)this.mockS3.getObject((String)ArgumentMatchers.eq((Object)this.bucket), (String)ArgumentMatchers.eq((Object)(this.prefix + "/" + this.requestId + "/" + this.splitId + ".1")))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                S3Object mockObject = (S3Object)Mockito.mock(S3Object.class);
                Mockito.when((Object)mockObject.getObjectContent()).thenReturn((Object)new S3ObjectInputStream((InputStream)new ByteArrayInputStream(byteHolder.getBytes()), null));
                return mockObject;
            }
        });
        Block block = this.blockWriter.read((S3SpillLocation)blockLocation2, this.spillConfig.getEncryptionKey(), this.expected.getSchema());
        Assert.assertEquals((Object)this.expected, (Object)block);
        ((AmazonS3)Mockito.verify((Object)this.mockS3, (VerificationMode)Mockito.times((int)1))).getObject((String)ArgumentMatchers.eq((Object)this.bucket), (String)ArgumentMatchers.eq((Object)(this.prefix + "/" + this.requestId + "/" + this.splitId + ".1")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockS3});
        logger.info("spillTest: exit");
    }

    private class ByteHolder {
        private byte[] bytes;

        private ByteHolder() {
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

