/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.util.Text;

public class UnitTestBlockUtils {
    public static Object getValue(FieldReader fieldReader, int pos) {
        fieldReader.setPosition(pos);
        Types.MinorType minorType = fieldReader.getMinorType();
        switch (minorType) {
            case DATEMILLI: {
                if (Objects.isNull(fieldReader.readLocalDateTime())) {
                    return null;
                }
                long millis = fieldReader.readLocalDateTime().atZone(BlockUtils.UTC_ZONE_ID).toInstant().toEpochMilli();
                return Instant.ofEpochMilli(millis).atZone(BlockUtils.UTC_ZONE_ID).toLocalDateTime();
            }
            case TINYINT: 
            case UINT1: {
                return fieldReader.readByte();
            }
            case UINT2: {
                return fieldReader.readCharacter();
            }
            case SMALLINT: {
                return fieldReader.readShort();
            }
            case DATEDAY: {
                Integer intVal = fieldReader.readInteger();
                if (Objects.isNull(intVal)) {
                    return null;
                }
                return LocalDate.ofEpochDay(intVal.intValue());
            }
            case INT: 
            case UINT4: {
                return fieldReader.readInteger();
            }
            case UINT8: 
            case BIGINT: {
                return fieldReader.readLong();
            }
            case DECIMAL: {
                return fieldReader.readBigDecimal();
            }
            case FLOAT4: {
                return fieldReader.readFloat();
            }
            case FLOAT8: {
                return fieldReader.readDouble();
            }
            case VARCHAR: {
                Text text = fieldReader.readText();
                if (Objects.isNull(text)) {
                    return null;
                }
                return text.toString();
            }
            case VARBINARY: {
                return fieldReader.readByteArray();
            }
            case BIT: {
                return fieldReader.readBoolean();
            }
            case LIST: {
                return UnitTestBlockUtils.readList(fieldReader);
            }
            case STRUCT: {
                return UnitTestBlockUtils.readStruct(fieldReader);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + minorType);
    }

    private static List<Object> readList(FieldReader listReader) {
        if (!listReader.isSet()) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (listReader.next()) {
            FieldReader subReader = listReader.reader();
            if (!subReader.isSet()) {
                list.add(null);
                continue;
            }
            list.add(UnitTestBlockUtils.getValue(subReader, subReader.getPosition()));
        }
        return list;
    }

    private static Map<String, Object> readStruct(FieldReader structReader) {
        if (!structReader.isSet()) {
            return null;
        }
        List fields = structReader.getField().getChildren();
        HashMap<String, Object> nameToValues = new HashMap<String, Object>();
        for (Field child : fields) {
            FieldReader subReader = structReader.reader(child.getName());
            nameToValues.put(child.getName(), UnitTestBlockUtils.getValue(subReader, subReader.getPosition()));
        }
        return nameToValues;
    }
}

