/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.helpers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.TimeZone;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.Provide;
import net.jqwik.api.arbitraries.ListArbitrary;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class FieldsGenerator {
    private int counter = 0;
    private boolean DEFAULT_NULLABLE = true;
    private boolean allowComplexKeys = true;
    private int maxRecursionDepth;

    public FieldsGenerator(int maxRecursionDepth) {
        this.maxRecursionDepth = maxRecursionDepth;
    }

    public FieldsGenerator(int maxRecursionDepth, boolean allowComplexKeys) {
        this.maxRecursionDepth = maxRecursionDepth;
        this.allowComplexKeys = allowComplexKeys;
    }

    @Provide
    public Arbitrary<Field> field() {
        return this.field(0, null, this.DEFAULT_NULLABLE);
    }

    private Arbitrary<Field> field(int depth, String name, boolean nullable) {
        return this.fieldType(depth + 1, nullable).flatMap(fieldType -> this.fieldChildren((FieldType)fieldType, depth + 1).flatMap(children -> {
            String fieldName = name;
            if (name == null) {
                ++this.counter;
                fieldName = (String)Arbitraries.strings().ofMinLength(1).sample() + this.counter;
            }
            return Arbitraries.just((Object)new Field(fieldName, fieldType, children));
        }));
    }

    private Arbitrary<FieldType> intField(boolean nullable) {
        return Arbitraries.of((Object[])new Boolean[]{true, false}).flatMap(signed -> Arbitraries.of((Object[])new Integer[]{8, 16, 32, 64}).map(bits -> new FieldType(nullable, (ArrowType)new ArrowType.Int(bits.intValue(), signed.booleanValue()), null)));
    }

    private Arbitrary<FieldType> dateField(boolean nullable) {
        return Arbitraries.of((Object[])new DateUnit[]{DateUnit.DAY, DateUnit.MILLISECOND}).map(unit -> new FieldType(nullable, (ArrowType)new ArrowType.Date(unit), null));
    }

    private Arbitrary<FieldType> floatingPointField(boolean nullable) {
        return Arbitraries.of((Object[])new FloatingPointPrecision[]{FloatingPointPrecision.SINGLE, FloatingPointPrecision.DOUBLE}).map(precision -> new FieldType(nullable, (ArrowType)new ArrowType.FloatingPoint(precision), null));
    }

    private Arbitrary<FieldType> timestampField(boolean nullable) {
        return Arbitraries.of((Object[])TimeZone.getAvailableIDs()).fixGenSize(5).flatMap(timezone -> Arbitraries.of((Object[])new TimeUnit[]{TimeUnit.SECOND, TimeUnit.MILLISECOND, TimeUnit.MICROSECOND, TimeUnit.NANOSECOND}).map(unit -> new FieldType(nullable, (ArrowType)new ArrowType.Timestamp(unit, timezone), null)));
    }

    private Arbitrary<FieldType> decimalField(boolean nullable) {
        return Arbitraries.integers().between(1, 20).flatMap(precision -> Arbitraries.integers().greaterOrEqual(0).lessOrEqual(precision - 1).flatMap(scale -> Arbitraries.of((Object[])new Integer[]{32, 64, 128}).map(bitWidth -> new FieldType(nullable, (ArrowType)new ArrowType.Decimal(precision.intValue(), scale.intValue(), bitWidth.intValue()), null))));
    }

    private Arbitrary<FieldType> primitiveFieldType(boolean nullable) {
        return Arbitraries.oneOf((Arbitrary)Arbitraries.just((Object)new FieldType(nullable, (ArrowType)new ArrowType.Binary(), null)), (Arbitrary[])new Arbitrary[]{Arbitraries.just((Object)new FieldType(nullable, (ArrowType)new ArrowType.Bool(), null)), this.dateField(nullable), this.decimalField(nullable), this.intField(nullable), this.floatingPointField(nullable), Arbitraries.just((Object)new FieldType(nullable, (ArrowType)new ArrowType.Utf8(), null))});
    }

    private Arbitrary<FieldType> complexFieldType(boolean nullable) {
        return Arbitraries.of((Object[])new FieldType[]{new FieldType(nullable, (ArrowType)new ArrowType.List(), null), new FieldType(nullable, (ArrowType)new ArrowType.Struct(), null), new FieldType(nullable, (ArrowType)new ArrowType.Map(true), null)});
    }

    private Arbitrary<FieldType> fieldType(int depth, boolean nullable) {
        if (depth >= this.maxRecursionDepth) {
            return this.primitiveFieldType(nullable);
        }
        return Arbitraries.oneOf(this.primitiveFieldType(nullable), (Arbitrary[])new Arbitrary[]{this.complexFieldType(nullable)});
    }

    private Arbitrary<List<Field>> fieldChildren(FieldType parentType, int depth) {
        if (parentType.getType().equals(ArrowType.List.INSTANCE)) {
            return this.field(depth, null, this.DEFAULT_NULLABLE).list().ofSize(1);
        }
        if (parentType.getType().equals(ArrowType.Struct.INSTANCE)) {
            return this.field(depth, null, this.DEFAULT_NULLABLE).list().uniqueElements().ofMinSize(1).ofMaxSize(3);
        }
        if (parentType.getType().getTypeID().equals((Object)ArrowType.Map.TYPE_TYPE)) {
            Arbitrary<Field> keyField = null;
            keyField = this.allowComplexKeys ? this.field(depth, "key", false) : this.field(this.maxRecursionDepth, "key", false);
            Arbitrary<Field> valueField = this.field(depth, "value", this.DEFAULT_NULLABLE);
            FieldType structType = new FieldType(false, (ArrowType)ArrowType.Struct.INSTANCE, null);
            ListArbitrary structField = Combinators.combine(keyField, valueField).as((key, value) -> new Field("entries", structType, (List)ImmutableList.of((Object)key, (Object)value))).list().ofSize(1);
            return structField;
        }
        return Arbitraries.just((Object)null);
    }
}

