/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.domain.predicate.EquatableValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import java.util.Collections;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EquatableValueSetTest {
    private BlockAllocatorImpl allocator;
    private ArrowType INT = Types.MinorType.INT.getType();

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void testEmptySet() throws Exception {
        EquatableValueSet equatables = EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT);
        Assert.assertEquals((Object)equatables.getType(), (Object)this.INT);
        Assert.assertTrue((boolean)equatables.isNone());
        Assert.assertFalse((boolean)equatables.isAll());
        Assert.assertFalse((boolean)equatables.isSingleValue());
        Assert.assertTrue((boolean)equatables.isWhiteList());
        Assert.assertEquals((long)equatables.getValues().getRowCount(), (long)0L);
        Assert.assertEquals((Object)equatables.complement((BlockAllocator)this.allocator), (Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertFalse((boolean)equatables.containsValue((Object)0));
        Assert.assertFalse((boolean)equatables.containsValue((Object)1));
    }

    @Test
    public void testEntireSet() throws Exception {
        EquatableValueSet equatables = EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT);
        Assert.assertEquals((Object)equatables.getType(), (Object)this.INT);
        Assert.assertFalse((boolean)equatables.isNone());
        Assert.assertTrue((boolean)equatables.isAll());
        Assert.assertFalse((boolean)equatables.isSingleValue());
        Assert.assertFalse((boolean)equatables.isWhiteList());
        Assert.assertEquals((long)equatables.getValues().getRowCount(), (long)0L);
        Assert.assertEquals((Object)equatables.complement((BlockAllocator)this.allocator), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertTrue((boolean)equatables.containsValue((Object)0));
        Assert.assertTrue((boolean)equatables.containsValue((Object)1));
    }

    @Test
    public void testSingleValue() throws Exception {
        EquatableValueSet equatables = EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{10});
        EquatableValueSet complement = (EquatableValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)equatables);
        Assert.assertEquals((Object)equatables.getType(), (Object)this.INT);
        Assert.assertFalse((boolean)equatables.isNone());
        Assert.assertFalse((boolean)equatables.isAll());
        Assert.assertTrue((boolean)equatables.isSingleValue());
        Assert.assertTrue((boolean)equatables.isWhiteList());
        Assert.assertEquals((Object)equatables.getSingleValue(), (Object)10);
        Assert.assertEquals((Object)equatables.complement((BlockAllocator)this.allocator), (Object)complement);
        Assert.assertFalse((boolean)equatables.containsValue((Object)0));
        Assert.assertFalse((boolean)equatables.containsValue((Object)1));
        Assert.assertTrue((boolean)equatables.containsValue((Object)10));
        Assert.assertEquals((Object)complement.getType(), (Object)this.INT);
        Assert.assertFalse((boolean)complement.isNone());
        Assert.assertFalse((boolean)complement.isAll());
        Assert.assertFalse((boolean)complement.isSingleValue());
        Assert.assertFalse((boolean)complement.isWhiteList());
        Assert.assertEquals((String)complement.toString(), (Object)complement.getValue(0), (Object)10);
        Assert.assertEquals((Object)complement.complement((BlockAllocator)this.allocator), (Object)equatables);
        Assert.assertTrue((boolean)complement.containsValue((Object)0));
        Assert.assertTrue((boolean)complement.containsValue((Object)1));
        Assert.assertFalse((boolean)complement.containsValue((Object)10));
    }

    @Test
    public void testMultipleValues() throws Exception {
        EquatableValueSet equatables = EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1, 2, 3, 1});
        EquatableValueSet complement = (EquatableValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)equatables);
        Assert.assertEquals((Object)equatables.getType(), (Object)this.INT);
        Assert.assertFalse((boolean)equatables.isNone());
        Assert.assertFalse((boolean)equatables.isAll());
        Assert.assertFalse((boolean)equatables.isSingleValue());
        Assert.assertTrue((boolean)equatables.isWhiteList());
        Assert.assertEquals((Object)equatables.complement((BlockAllocator)this.allocator), (Object)complement);
        Assert.assertFalse((boolean)equatables.containsValue((Object)0));
        Assert.assertTrue((boolean)equatables.containsValue((Object)1));
        Assert.assertTrue((boolean)equatables.containsValue((Object)2));
        Assert.assertTrue((boolean)equatables.containsValue((Object)3));
        Assert.assertFalse((boolean)equatables.containsValue((Object)4));
        Assert.assertEquals((Object)complement.getType(), (Object)this.INT);
        Assert.assertFalse((boolean)complement.isNone());
        Assert.assertFalse((boolean)complement.isAll());
        Assert.assertFalse((boolean)complement.isSingleValue());
        Assert.assertFalse((boolean)complement.isWhiteList());
        Assert.assertEquals((Object)complement.complement((BlockAllocator)this.allocator), (Object)equatables);
        Assert.assertTrue((boolean)complement.containsValue((Object)0));
        Assert.assertFalse((boolean)complement.containsValue((Object)1));
        Assert.assertFalse((boolean)complement.containsValue((Object)2));
        Assert.assertFalse((boolean)complement.containsValue((Object)3));
        Assert.assertTrue((boolean)complement.containsValue((Object)4));
    }

    @Test
    public void testGetSingleValue() throws Exception {
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).getSingleValue(), (Object)0);
        try {
            EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNullability() throws Exception {
        EquatableValueSet actual = EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (boolean)true, Collections.singletonList(100));
        Assert.assertTrue((boolean)actual.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object)100)));
        Assert.assertTrue((boolean)actual.containsValue(Marker.nullMarker((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)actual.containsValue(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object)101)));
    }

    @Test
    public void testOverlaps() throws Exception {
        Assert.assertTrue((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertTrue((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertTrue((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertFalse((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertFalse((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1})));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}).complement((BlockAllocator)this.allocator)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{-1})));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{-1}).complement((BlockAllocator)this.allocator)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{-1})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).overlaps((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{-1}).complement((BlockAllocator)this.allocator)));
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertTrue((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertTrue((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertTrue((boolean)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertFalse((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertFalse((boolean)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 2})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}).complement((BlockAllocator)this.allocator)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})));
        Assert.assertTrue((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{-1})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})));
        Assert.assertFalse((boolean)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).contains((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{-1}).complement((BlockAllocator)this.allocator)));
    }

    @Test
    public void testIntersect() throws Exception {
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 2})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 2})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{2}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).intersect((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 2}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1, 2}).complement((BlockAllocator)this.allocator));
    }

    @Test
    public void testUnion() throws Exception {
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 2})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1, 2}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 2})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator).union((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 2}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator));
    }

    @Test
    public void testSubtract() throws Exception {
        Assert.assertEquals((Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}));
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.all((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.none((BlockAllocator)this.allocator, (ArrowType)this.INT));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1})), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator));
        Assert.assertEquals((Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0}).complement((BlockAllocator)this.allocator).subtract((BlockAllocator)this.allocator, (ValueSet)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{0, 1}).complement((BlockAllocator)this.allocator)), (Object)EquatableValueSet.of((BlockAllocator)this.allocator, (ArrowType)this.INT, (Object[])new Object[]{1}));
    }
}

