/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueMarker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.Map;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MarkerTest {
    private BlockAllocatorImpl allocator;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void testTypes() throws Exception {
        Assert.assertEquals((Object)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).getType(), (Object)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).getType(), (Object)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).getType(), (Object)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).getType(), (Object)Types.MinorType.INT.getType());
        Assert.assertEquals((Object)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).getType(), (Object)Types.MinorType.INT.getType());
    }

    @Test
    public void testUnbounded() throws Exception {
        Assert.assertTrue((boolean)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).isUpperUnbounded());
        Assert.assertTrue((boolean)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).isUpperUnbounded());
    }

    @Test
    public void testComparisons() throws Exception {
        ImmutableList markers = ImmutableList.of((Object)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()), (Object)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)0), (Object)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1), (Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1), (Object)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1), (Object)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)2), (Object)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()));
        Assert.assertTrue((boolean)Ordering.natural().isStrictlyOrdered((Iterable)markers));
        for (int i = 0; i < markers.size(); ++i) {
            for (int j = 0; j < markers.size(); ++j) {
                Assert.assertTrue((((Marker)markers.get(i)).compareTo((ValueMarker)markers.get(j)) == Integer.compare(i, j) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testAdjacency() throws Exception {
        ImmutableMap markers = ImmutableMap.builder().put((Object)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()), (Object)-1000).put((Object)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)0), (Object)-100).put((Object)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1), (Object)-1).put((Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1), (Object)0).put((Object)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1), (Object)1).put((Object)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)2), (Object)100).put((Object)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()), (Object)1000).build();
        for (Map.Entry entry1 : markers.entrySet()) {
            for (Map.Entry entry2 : markers.entrySet()) {
                boolean adjacent = ((Marker)entry1.getKey()).isAdjacent((Marker)entry2.getKey());
                boolean distanceIsOne = Math.abs((Integer)entry1.getValue() - (Integer)entry2.getValue()) == 1;
                Assert.assertEquals((Object)adjacent, (Object)distanceIsOne);
            }
        }
        Assert.assertEquals((Object)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).greaterAdjacent(), (Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1));
        Assert.assertEquals((Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).greaterAdjacent(), (Object)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1));
        Assert.assertEquals((Object)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).lesserAdjacent(), (Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1));
        Assert.assertEquals((Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).lesserAdjacent(), (Object)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1));
        try {
            Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType()).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

