/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.domain.predicate.LiteralValueMarker;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.Range;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueMarker;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeTest {
    private BlockAllocatorImpl allocator;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMismatchedTypes() throws Exception {
        new Range(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L), Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.VARCHAR.getType(), (Object)"a"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvertedBounds() throws Exception {
        new Range(Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L), Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLowerUnboundedOnly() throws Exception {
        new Range(Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()), Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUpperUnboundedOnly() throws Exception {
        new Range(Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()), Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
    }

    @Test
    public void testSingleValue() throws Exception {
        Assert.assertTrue((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)1L, (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)2L, (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.FLOAT8.getType(), (Object)1.1, (boolean)true, (Object)1.1, (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.VARCHAR.getType(), (Object)"a", (boolean)true, (Object)"a", (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIT.getType(), (Object)true, (boolean)true, (Object)true, (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIT.getType(), (Object)false, (boolean)true, (Object)true, (boolean)true).isSingleValue());
    }

    @Test
    public void testAllRange() throws Exception {
        Range range = Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType());
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertTrue((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testGreaterThanRange() throws Exception {
        Range range = Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)new LiteralValueMarker((Object)2L, Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testGreaterThanOrEqualRange() throws Exception {
        Range range = Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)new LiteralValueMarker((Object)2L, Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testLessThanRange() throws Exception {
        Range range = Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.below((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)new LiteralValueMarker((Object)0L, Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testLessThanOrEqualRange() throws Exception {
        Range range = Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertFalse((boolean)range.includes((ValueMarker)new LiteralValueMarker((Object)2L, Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testEqualRange() throws Exception {
        Range range = Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L));
        Assert.assertTrue((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)));
        Assert.assertFalse((boolean)range.includes((ValueMarker)new LiteralValueMarker((Object)2L, Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testRange() throws Exception {
        Range range = Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (boolean)false, (Object)2L, (boolean)true);
        Assert.assertEquals((Object)range.getLow(), (Object)Marker.above((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L));
        Assert.assertEquals((Object)range.getHigh(), (Object)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L));
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)Types.MinorType.BIGINT.getType());
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.lowerUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertTrue((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L)));
        Assert.assertFalse((boolean)range.includes((ValueMarker)new LiteralValueMarker((Object)0L, Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)range.includes((ValueMarker)new LiteralValueMarker((Object)1L, Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)range.includes((ValueMarker)new LiteralValueMarker((Object)2L, Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)new LiteralValueMarker((Object)3L, Types.MinorType.BIGINT.getType())));
        Assert.assertFalse((boolean)range.includes((ValueMarker)Marker.upperUnbounded((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
    }

    @Test
    public void testGetSingleValue() throws Exception {
        Assert.assertEquals((Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L).getSingleValue(), (Object)0L);
        try {
            Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertTrue((boolean)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).contains(Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).contains(Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).contains(Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L).contains(Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L).contains(Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L).contains(Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L).contains(Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType())));
        Assert.assertTrue((boolean)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L).contains(Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L).contains(Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)));
        Assert.assertFalse((boolean)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L).contains(Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)));
        Assert.assertTrue((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)2L, (boolean)true)));
        Assert.assertFalse((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false)));
    }

    @Test
    public void testSpan() throws Exception {
        Assert.assertEquals((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L).span(Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)), (Object)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L).span(Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)), (Object)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
        Assert.assertEquals((Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)), (Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false));
        Assert.assertEquals((Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L, (boolean)false, (Object)10L, (boolean)false)), (Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)10L, (boolean)false));
        Assert.assertEquals((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L).span(Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L)), (Object)Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)0L));
        Assert.assertEquals((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L).span(Range.greaterThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)10L)), (Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L));
        Assert.assertEquals((Object)Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L).span(Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)), (Object)Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L));
        Assert.assertEquals((Object)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).span(Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L)), (Object)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()));
    }

    @Test
    public void testOverlaps() throws Exception {
        Assert.assertTrue((boolean)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L).overlaps(Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)));
        Assert.assertFalse((boolean)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L).overlaps(Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)));
        Assert.assertTrue((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)));
        Assert.assertTrue((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L, (boolean)false, (Object)10L, (boolean)false)));
        Assert.assertFalse((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L, (boolean)true, (Object)10L, (boolean)false)));
        Assert.assertTrue((boolean)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)true).overlaps(Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L, (boolean)true, (Object)10L, (boolean)false)));
        Assert.assertTrue((boolean)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).overlaps(Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)Long.MAX_VALUE)));
    }

    @Test
    public void testIntersect() throws Exception {
        Assert.assertEquals((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L).intersect(Range.lessThanOrEqual((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)), (Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)false, (Object)2L, (boolean)true));
        Assert.assertEquals((Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L)), (Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L));
        Assert.assertEquals((Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L, (boolean)false, (Object)10L, (boolean)false)), (Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L, (boolean)false, (Object)3L, (boolean)false));
        Assert.assertEquals((Object)Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)true).intersect(Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L, (boolean)true, (Object)10L, (boolean)false)), (Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L));
        Assert.assertEquals((Object)Range.all((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType()).intersect(Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)Long.MAX_VALUE)), (Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)Long.MAX_VALUE));
    }

    @Test
    public void testExceptionalIntersect() throws Exception {
        try {
            Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L).intersect(Range.lessThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)2L));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.range((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)3L, (boolean)true, (Object)10L, (boolean)false));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

