/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata.glue;

import com.amazonaws.athena.connector.lambda.metadata.glue.GlueFieldLexer;
import java.util.List;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueFieldLexerTest {
    private static final Logger logger = LoggerFactory.getLogger(GlueFieldLexerTest.class);

    @Test
    public void basicLexTest() {
        logger.info("basicLexTest: enter");
        String input = "ARRAY<STRING>";
        Field field = GlueFieldLexer.lex((String)"testField", (String)input);
        Assert.assertEquals((Object)"testField", (Object)field.getName());
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)field.getType()));
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)field.getChildren().get(0)).getType()));
        logger.info("basicLexTest: exit");
    }

    @Test
    public void baseLexTest() {
        logger.info("baseLexTest: enter");
        String input = "INT";
        Field field = GlueFieldLexer.lex((String)"testField", (String)input);
        Assert.assertEquals((Object)"testField", (Object)field.getName());
        Assert.assertEquals((Object)Types.MinorType.INT, (Object)Types.getMinorTypeForArrowType((ArrowType)field.getType()));
        Assert.assertEquals((long)0L, (long)field.getChildren().size());
        logger.info("baseLexTest: exit");
    }

    @Test
    public void lexTest() {
        logger.info("lexTest: enter");
        String input = "STRUCT <  street_address: STRUCT <    street_number: INT,    street_name: STRING,    street_type: STRING  >,  country: STRING,  postal_code: ARRAY<STRING>>";
        Field field = GlueFieldLexer.lex((String)"testField", (String)input);
        logger.info("lexTest: {}", (Object)field);
        Assert.assertEquals((Object)"testField", (Object)field.getName());
        Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)field.getType()));
        Assert.assertEquals((long)3L, (long)field.getChildren().size());
        List level1 = field.getChildren();
        Assert.assertEquals((Object)"street_address", (Object)((Field)level1.get(0)).getName());
        Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level1.get(0)).getType()));
        Assert.assertEquals((long)3L, (long)((Field)level1.get(0)).getChildren().size());
        List level2 = ((Field)level1.get(0)).getChildren();
        Assert.assertEquals((Object)"street_number", (Object)((Field)level2.get(0)).getName());
        Assert.assertEquals((Object)Types.MinorType.INT, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level2.get(0)).getType()));
        Assert.assertEquals((long)0L, (long)((Field)level2.get(0)).getChildren().size());
        Assert.assertEquals((Object)"street_name", (Object)((Field)level2.get(1)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level2.get(1)).getType()));
        Assert.assertEquals((long)0L, (long)((Field)level2.get(1)).getChildren().size());
        Assert.assertEquals((Object)"street_type", (Object)((Field)level2.get(2)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level2.get(2)).getType()));
        Assert.assertEquals((long)0L, (long)((Field)level2.get(2)).getChildren().size());
        Assert.assertEquals((Object)"country", (Object)((Field)level1.get(1)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level1.get(1)).getType()));
        Assert.assertEquals((long)0L, (long)((Field)level1.get(1)).getChildren().size());
        Assert.assertEquals((Object)"postal_code", (Object)((Field)level1.get(2)).getName());
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level1.get(2)).getType()));
        Assert.assertEquals((long)1L, (long)((Field)level1.get(2)).getChildren().size());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)((Field)level1.get(2)).getChildren().get(0)).getType()));
        logger.info("lexTest: exit");
    }

    @Test
    public void arrayOfStructLexComplexTest() {
        logger.info("arrayOfStructLexComplexTest: enter");
        Field field = GlueFieldLexer.lex((String)"namelist", (String)"ARRAY<STRUCT<last:STRING,mi:STRING,first:STRING>>");
        logger.info("lexTest: {}", (Object)field);
        Assert.assertEquals((Object)"namelist", (Object)field.getName());
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)field.getType()));
        Field child = (Field)field.getChildren().get(0);
        Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)child.getType()));
        Assert.assertEquals((long)3L, (long)child.getChildren().size());
        Assert.assertEquals((Object)"last", (Object)((Field)child.getChildren().get(0)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)child.getChildren().get(0)).getType()));
        Assert.assertEquals((Object)"mi", (Object)((Field)child.getChildren().get(1)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)child.getChildren().get(1)).getType()));
        Assert.assertEquals((Object)"first", (Object)((Field)child.getChildren().get(2)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)child.getChildren().get(2)).getType()));
        logger.info("arrayOfStructLexComplexTest: exit");
    }

    @Test
    public void nestedArrayLexComplexTest() {
        logger.info("nestedArrayLexComplexTest: enter");
        Field field = GlueFieldLexer.lex((String)"namelist", (String)"ARRAY<ARRAY<STRUCT<last:STRING,mi:STRING,first:STRING, aliases:ARRAY<STRING>>>>");
        logger.info("lexTest: {}", (Object)field);
        Assert.assertEquals((Object)"namelist", (Object)field.getName());
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)field.getType()));
        Field level1 = (Field)field.getChildren().get(0);
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)level1.getType()));
        Field level2 = (Field)level1.getChildren().get(0);
        Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)level2.getType()));
        Assert.assertEquals((long)4L, (long)level2.getChildren().size());
        Assert.assertEquals((Object)"last", (Object)((Field)level2.getChildren().get(0)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level2.getChildren().get(0)).getType()));
        Assert.assertEquals((Object)"mi", (Object)((Field)level2.getChildren().get(1)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level2.getChildren().get(1)).getType()));
        Assert.assertEquals((Object)"first", (Object)((Field)level2.getChildren().get(2)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level2.getChildren().get(2)).getType()));
        Assert.assertEquals((Object)"aliases", (Object)((Field)level2.getChildren().get(3)).getName());
        Field level3 = (Field)level2.getChildren().get(3);
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)level3.getType()));
        Assert.assertEquals((Object)"aliases", (Object)((Field)level3.getChildren().get(0)).getName());
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level3.getChildren().get(0)).getType()));
        logger.info("nestedArrayLexComplexTest: exit");
    }

    @Test
    public void multiArrayStructLexComplexTest() {
        logger.info("multiArrayStructLexComplexTest: enter");
        Field field = GlueFieldLexer.lex((String)"movie_info", (String)"STRUCT<actors:ARRAY<STRING>,genre:ARRAY<STRING>>");
        logger.info("lexTest: {}", (Object)field);
        Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)field.getType()));
        Assert.assertEquals((Object)"movie_info", (Object)field.getName());
        Assert.assertEquals((long)2L, (long)field.getChildren().size());
        Field array1 = (Field)field.getChildren().get(0);
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)array1.getType()));
        Assert.assertEquals((Object)"actors", (Object)((Field)array1.getChildren().get(0)).getName());
        Field array2 = (Field)field.getChildren().get(1);
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)array2.getType()));
        Assert.assertEquals((Object)"genre", (Object)((Field)array2.getChildren().get(0)).getName());
        logger.info("multiArrayStructLexComplexTest: exit");
    }

    @Test
    public void lexListOfStructTest() {
        logger.info("lexListOfStructTest: enter");
        String input = "ARRAY<STRUCT<time:timestamp, measure_value\\:\\:double:double>>";
        Field field = GlueFieldLexer.lex((String)"testField", (String)input);
        logger.info("lexListOfStructTest: {}", (Object)field);
        Assert.assertEquals((Object)"testField", (Object)field.getName());
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)field.getType()));
        Assert.assertEquals((long)1L, (long)field.getChildren().size());
        List level1 = field.getChildren();
        Assert.assertEquals((Object)"testField", (Object)((Field)level1.get(0)).getName());
        Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level1.get(0)).getType()));
        Assert.assertEquals((long)2L, (long)((Field)level1.get(0)).getChildren().size());
        List level2 = ((Field)level1.get(0)).getChildren();
        Assert.assertEquals((Object)"time", (Object)((Field)level2.get(0)).getName());
        Assert.assertEquals((Object)Types.MinorType.DATEMILLI, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level2.get(0)).getType()));
        Assert.assertEquals((long)0L, (long)((Field)level2.get(0)).getChildren().size());
        Assert.assertEquals((Object)"measure_value::double", (Object)((Field)level2.get(1)).getName());
        Assert.assertEquals((Object)Types.MinorType.FLOAT8, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level2.get(1)).getType()));
        logger.info("lexListOfStructTest: exit");
    }

    @Test
    public void lexStructListChildAndStructChildTest() {
        String input = "struct<somearrfield:array<set<string>>,mapinner:struct<numberset_deep:set<bigint>>>";
        Field field = GlueFieldLexer.lex((String)"testAsdf", (String)input);
        logger.info("lexStructListChildAndStructChildTest: {}", (Object)field);
        Assert.assertEquals((Object)"testAsdf", (Object)field.getName());
        Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)field.getType()));
        Assert.assertEquals((long)2L, (long)field.getChildren().size());
        List level1 = field.getChildren();
        Assert.assertEquals((Object)"somearrfield", (Object)((Field)level1.get(0)).getName());
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level1.get(0)).getType()));
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)((Field)level1.get(0)).getChildren().get(0)).getType()));
        Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)((Field)((Field)level1.get(0)).getChildren().get(0)).getChildren().get(0)).getType()));
        Assert.assertEquals((Object)"mapinner", (Object)((Field)level1.get(1)).getName());
        Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)level1.get(1)).getType()));
        Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)((Field)level1.get(1)).getChildren().get(0)).getType()));
        Assert.assertEquals((Object)Types.MinorType.BIGINT, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)((Field)((Field)level1.get(1)).getChildren().get(0)).getChildren().get(0)).getType()));
    }

    @Test
    public void lexExtraInnerClosingFieldsTest() {
        String input = "struct<somearrfield0:array<set<struct<somefield:string,someset:set<string>>>>,mapinner0:struct<numberset_deep:set<bigint>>,somearrfield1:array<set<struct<somefield:string,someset:set<string>>>>,mapinner1:struct<numberset_deep:set<bigint>>,somearrfield2:array<set<struct<somefield:string,someset:set<string>>>>,mapinner2:struct<numberset_deep:set<bigint>> >";
        Field field = GlueFieldLexer.lex((String)"testAsdf2", (String)input);
        logger.info("lexExtraInnerClosingFieldsTest: {}", (Object)field);
        Assert.assertEquals((Object)"testAsdf2", (Object)field.getName());
        Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)field.getType()));
        Assert.assertEquals((long)6L, (long)field.getChildren().size());
        List level1 = field.getChildren();
        for (int i = 0; i < 3; ++i) {
            int somearrFieldIdx = i * 2;
            Field somearrField = (Field)level1.get(somearrFieldIdx);
            Assert.assertEquals((Object)("somearrfield" + i), (Object)somearrField.getName());
            Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)somearrField.getType()));
            Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)somearrField.getChildren().get(0)).getType()));
            Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)((Field)somearrField.getChildren().get(0)).getChildren().get(0)).getType()));
            Field innerAsdfStruct = (Field)((Field)somearrField.getChildren().get(0)).getChildren().get(0);
            Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)innerAsdfStruct.getChildren().get(0)).getType()));
            Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)innerAsdfStruct.getChildren().get(1)).getType()));
            Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)((Field)innerAsdfStruct.getChildren().get(1)).getChildren().get(0)).getType()));
            int mapinnerIdx = i * 2 + 1;
            Field mapinnerField = (Field)level1.get(mapinnerIdx);
            Assert.assertEquals((Object)("mapinner" + i), (Object)mapinnerField.getName());
            Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)Types.getMinorTypeForArrowType((ArrowType)mapinnerField.getType()));
            Assert.assertEquals((Object)Types.MinorType.LIST, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)mapinnerField.getChildren().get(0)).getType()));
            Assert.assertEquals((Object)Types.MinorType.BIGINT, (Object)Types.getMinorTypeForArrowType((ArrowType)((Field)((Field)mapinnerField.getChildren().get(0)).getChildren().get(0)).getType()));
        }
    }

    @Test
    public void basicLexDecimalTest() {
        logger.info("basicLexDecimalTest: enter");
        String input1 = "DECIMAL(13,7)";
        Field field1 = GlueFieldLexer.lex((String)"testField1", (String)input1);
        Assert.assertEquals((Object)"testField1: Decimal(13, 7, 128)", (Object)field1.toString());
        String input2 = "DECIMAL(13,7,8)";
        Field field2 = GlueFieldLexer.lex((String)"testField2", (String)input2);
        Assert.assertEquals((Object)"testField2: Decimal(13, 7, 8)", (Object)field2.toString());
        String input3 = "DECIMAL";
        Field field3 = GlueFieldLexer.lex((String)"testField3", (String)input3);
        Assert.assertEquals((Object)"testField3: Decimal(38, 18, 128)", (Object)field3.toString());
    }

    @Test
    public void lexExtraInnerClosingFieldsDecimalsTest() {
        String input = "struct<somearrfield0:array<set<struct<somefield:decimal(38,9),someset:set<decimal(11,7)>>>>,mapinner0:struct<numberset_deep:set<decimal(23,3,8)>>,somearrfield1:array<set<struct<somefield:decimal(38,9),someset:set<decimal(11,7)>>>>,mapinner1:struct<numberset_deep:set<decimal(23,3,16)>>,somearrfield2:array<set<struct<somefield:decimal(38,9),someset:set<decimal(11,7)>>>>,mapinner2:struct<numberset_deep:set<decimal(23,3,32)>>>";
        Field field = GlueFieldLexer.lex((String)"testAsdf2", (String)input);
        String expectedFieldToString = "testAsdf2: Struct<somearrfield0: List<somearrfield0: List<somearrfield0: Struct<somefield: Decimal(38, 9, 128), someset: List<someset: Decimal(11, 7, 128)>>>>, mapinner0: Struct<numberset_deep: List<numberset_deep: Decimal(23, 3, 8)>>, somearrfield1: List<somearrfield1: List<somearrfield1: Struct<somefield: Decimal(38, 9, 128), someset: List<someset: Decimal(11, 7, 128)>>>>, mapinner1: Struct<numberset_deep: List<numberset_deep: Decimal(23, 3, 16)>>, somearrfield2: List<somearrfield2: List<somearrfield2: Struct<somefield: Decimal(38, 9, 128), someset: List<someset: Decimal(11, 7, 128)>>>>, mapinner2: Struct<numberset_deep: List<numberset_deep: Decimal(23, 3, 32)>>>";
        Assert.assertEquals((Object)expectedFieldToString, (Object)field.toString());
    }

    @Test
    public void lexMapTest() {
    }
}

