/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.security;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.security.AesGcmBlockCrypto;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.amazonaws.athena.connector.lambda.security.EncryptionKeyFactory;
import com.amazonaws.athena.connector.lambda.security.LocalKeyFactory;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlockCryptoTest {
    private final EncryptionKeyFactory keyFactory = new LocalKeyFactory();
    private BlockAllocatorImpl allocator;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void test() {
        Schema schema = SchemaBuilder.newBuilder().addField("col1", (ArrowType)new ArrowType.Int(32, true)).addField("col2", (ArrowType)new ArrowType.Utf8()).build();
        Block expected = this.allocator.createBlock(schema);
        BlockUtils.setValue((FieldVector)expected.getFieldVector("col1"), (int)1, (Object)100);
        BlockUtils.setValue((FieldVector)expected.getFieldVector("col2"), (int)1, (Object)"VarChar");
        BlockUtils.setValue((FieldVector)expected.getFieldVector("col1"), (int)1, (Object)101);
        BlockUtils.setValue((FieldVector)expected.getFieldVector("col2"), (int)1, (Object)"VarChar1");
        expected.setRowCount(2);
        AesGcmBlockCrypto crypto = new AesGcmBlockCrypto((BlockAllocator)new BlockAllocatorImpl());
        EncryptionKey key = this.keyFactory.create();
        byte[] cypher = crypto.encrypt(key, expected);
        Block actual = crypto.decrypt(key, cypher, schema);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

