/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockSerializationTest {
    private static final Logger logger = LoggerFactory.getLogger(BlockSerializationTest.class);
    private BlockAllocatorImpl allocator;
    private BlockAllocatorImpl otherAllocator;
    private ObjectMapper objectMapper;

    @Before
    public void setup() {
        this.otherAllocator = new BlockAllocatorImpl();
        this.allocator = new BlockAllocatorImpl();
        this.objectMapper = ObjectMapperFactory.create((BlockAllocator)this.allocator);
    }

    @After
    public void tearDown() {
        this.otherAllocator.close();
        this.allocator.close();
    }

    @Test
    public void serializationTest() throws IOException {
        logger.info("serializationTest - enter");
        Block expected = BlockUtils.newBlock((BlockAllocator)this.otherAllocator, (String)"col1", (ArrowType)Types.MinorType.INT.getType(), (Object[])new Object[]{21});
        ObjectMapper serializer = ObjectMapperFactory.create((BlockAllocator)new BlockAllocatorImpl());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        serializer.writeValue((OutputStream)out, (Object)expected);
        Block actual = (Block)serializer.readValue((InputStream)new ByteArrayInputStream(out.toByteArray()), Block.class);
        Assert.assertEquals((Object)expected, (Object)actual);
        logger.info("serializationTest - exit");
    }
}

