/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.VersionedObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;

public class ObjectMapperUtil {
    private ObjectMapperUtil() {
    }

    public static <T> void assertSerialization(Object object) {
        ObjectMapperUtil.assertBaseSerialization(object);
    }

    private static <T> void assertBaseSerialization(Object object) {
        Class<Object> clazz = object.getClass();
        if (object instanceof FederationRequest) {
            clazz = FederationRequest.class;
        } else if (object instanceof FederationResponse) {
            clazz = FederationResponse.class;
        }
        try (BlockAllocatorImpl allocator = new BlockAllocatorImpl();){
            ByteArrayOutputStream serDeOut = new ByteArrayOutputStream();
            ObjectMapper serDe = VersionedObjectMapperFactory.create((BlockAllocator)allocator, (int)2);
            serDe.writeValue((OutputStream)serDeOut, object);
            byte[] serDeOutput = serDeOut.toByteArray();
            Assert.assertEquals((Object)object, (Object)serDe.readValue((InputStream)new ByteArrayInputStream(serDeOutput), clazz));
        }
        catch (IOException | AssertionError ex) {
            throw new RuntimeException((Throwable)ex);
        }
    }
}

