/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.request.PingResponse;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperUtil;
import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.fasterxml.jackson.core.JsonEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingResponseSerDeTest
extends TypedSerDeTest<FederationResponse> {
    private static final Logger logger = LoggerFactory.getLogger(PingResponseSerDeTest.class);

    @Before
    public void beforeTest() throws IOException {
        this.expected = new PingResponse("test-catalog", "test-query-id", "test-source-type", 23, 2);
        String expectedSerDeFile = this.utils.getResourceOrFail("serde", "PingResponse.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    @Test
    public void serialize() throws IOException {
        logger.info("serialize: enter");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)outputStream, this.expected);
        String actual = new String(outputStream.toByteArray(), JsonEncoding.UTF8.getJavaName());
        logger.info("serialize: serialized text[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expectedSerDeText, (Object)actual);
        logger.info("serialize: exit");
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        PingResponse actual = (PingResponse)this.mapper.readValue((InputStream)input, FederationResponse.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        logger.info("deserialize: exit");
    }

    @Test
    public void testBackwardsAndForwardsCompatibility() {
        ObjectMapperUtil.assertSerialization(this.expected);
    }

    @Test
    public void testForwardsCompatibility() throws IOException {
        logger.info("testForwardsCompatibility: enter");
        String expectedSerDeFile = this.utils.getResourceOrFail("serde", "PingResponseForwardsCompatible.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        PingResponse actual = (PingResponse)this.mapper.readValue((InputStream)input, FederationResponse.class);
        logger.info("testForwardsCompatibility: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        logger.info("testForwardsCompatibility: exit");
    }
}

