/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.amazonaws.services.lambda.invoke.LambdaFunctionException;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaFunctionExceptionSerDeTest
extends TypedSerDeTest<LambdaFunctionException> {
    private static final Logger logger = LoggerFactory.getLogger(LambdaFunctionExceptionSerDeTest.class);

    @Before
    public void beforeTest() throws IOException, ReflectiveOperationException {
        String errorType = "com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException";
        String errorMessage = "Requested resource not found (Service: AmazonDynamoDBv2; Status Code: 400; Error Code: ResourceNotFoundException; Request ID: RIB6NOH4BNMAK6KQG88R5VE583VV4KQNSO5AEMVJF66Q9ASUAAJG)";
        ImmutableList stackTrace = ImmutableList.of((Object)"com.amazonaws.http.AmazonHttpClient$RequestExecutor.handleErrorResponse(AmazonHttpClient.java:1701)", (Object)"com.amazonaws.http.AmazonHttpClient$RequestExecutor.executeOneRequest(AmazonHttpClient.java:1356)");
        Constructor constructor = LambdaFunctionException.class.getDeclaredConstructor(String.class, String.class, LambdaFunctionException.class, List.class);
        constructor.setAccessible(true);
        this.expected = constructor.newInstance(errorType, errorMessage, null, stackTrace);
        String expectedSerDeFile = this.utils.getResourceOrFail("serde/v2", "LambdaFunctionException.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    public void serialize() throws Exception {
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        LambdaFunctionException actual = (LambdaFunctionException)this.mapper.readValue((InputStream)input, LambdaFunctionException.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual.toString());
        Assert.assertEquals((Object)((LambdaFunctionException)this.expected).getType(), (Object)actual.getType());
        Assert.assertEquals((Object)((LambdaFunctionException)this.expected).getMessage(), (Object)actual.getMessage());
        Assert.assertEquals((Object)((LambdaFunctionException)this.expected).getCause(), (Object)actual.getCause());
        ((LambdaFunctionException)this.expected).fillInStackTrace();
        actual.fillInStackTrace();
        Assert.assertEquals((long)((LambdaFunctionException)this.expected).getStackTrace().length, (long)actual.getStackTrace().length);
        logger.info("deserialize: exit");
    }
}

