/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.AllOrNoneValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.EquatableValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.Range;
import com.amazonaws.athena.connector.lambda.domain.predicate.SortedRangeSet;
import com.amazonaws.athena.connector.lambda.domain.spill.S3SpillLocation;
import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.fasterxml.jackson.core.JsonEncoding;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadRecordsRequestSerDeTest
extends TypedSerDeTest<FederationRequest> {
    private static final Logger logger = LoggerFactory.getLogger(ReadRecordsRequestSerDeTest.class);

    @Before
    public void beforeTest() throws IOException {
        String yearCol = "year";
        String monthCol = "month";
        String dayCol = "day";
        Schema schema = SchemaBuilder.newBuilder().addField(yearCol, (ArrowType)new ArrowType.Int(32, true)).addField(monthCol, (ArrowType)new ArrowType.Int(32, true)).addField(dayCol, (ArrowType)new ArrowType.Int(32, true)).addField("col2", (ArrowType)new ArrowType.Utf8()).addField("col3", Types.MinorType.FLOAT8.getType()).addField("col4", Types.MinorType.FLOAT8.getType()).addField("col5", Types.MinorType.FLOAT8.getType()).build();
        HashMap<String, Object> constraintsMap = new HashMap<String, Object>();
        constraintsMap.put("col3", SortedRangeSet.copyOf((ArrowType)Types.MinorType.FLOAT8.getType(), (List)ImmutableList.of((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.FLOAT8.getType(), (Object)-10000.0)), (boolean)false));
        constraintsMap.put("col4", EquatableValueSet.newBuilder((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.FLOAT8.getType(), (boolean)false, (boolean)true).add((Object)1.1).build());
        constraintsMap.put("col5", new AllOrNoneValueSet(Types.MinorType.FLOAT8.getType(), false, true));
        Constraints constraints = new Constraints(constraintsMap, Collections.emptyList(), Collections.emptyList(), -1L);
        Block partitions = this.allocator.createBlock(schema);
        int num_partitions = 10;
        for (int i = 0; i < num_partitions; ++i) {
            BlockUtils.setValue((FieldVector)partitions.getFieldVector(yearCol), (int)i, (Object)(2016 + i));
            BlockUtils.setValue((FieldVector)partitions.getFieldVector(monthCol), (int)i, (Object)(i % 12 + 1));
            BlockUtils.setValue((FieldVector)partitions.getFieldVector(dayCol), (int)i, (Object)(i % 28 + 1));
        }
        partitions.setRowCount(num_partitions);
        S3SpillLocation spillLocation = S3SpillLocation.newBuilder().withBucket("athena-virtuoso-test").withPrefix("lambda-spill").withQueryId("test-query-id").withSplitId("test-split-id").withIsDirectory(true).build();
        EncryptionKey encryptionKey = new EncryptionKey("test-key".getBytes(), "test-nonce".getBytes());
        Split split = Split.newBuilder((SpillLocation)spillLocation, (EncryptionKey)encryptionKey).add("year", "2017").add("month", "11").add("day", "1").build();
        this.expected = new ReadRecordsRequest(this.federatedIdentity, "test-query-id", "test-catalog", new TableName("test-schema", "test-table"), schema, split, constraints, 100000000000L, 100000000000L);
        String expectedSerDeFile = this.utils.getResourceOrFail("serde/v2", "ReadRecordsRequest.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    @Test
    public void serialize() throws Exception {
        logger.info("serialize: enter");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)outputStream, this.expected);
        String actual = new String(outputStream.toByteArray(), JsonEncoding.UTF8.getJavaName());
        logger.info("serialize: serialized text[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expectedSerDeText, (Object)actual);
        ((FederationRequest)this.expected).close();
        logger.info("serialize: exit");
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        ReadRecordsRequest actual = (ReadRecordsRequest)this.mapper.readValue((InputStream)input, FederationRequest.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        logger.info("deserialize: exit");
    }
}

