/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsResponse;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.fasterxml.jackson.core.JsonEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadRecordsResponseSerDeTest
extends TypedSerDeTest<FederationResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ReadRecordsResponseSerDeTest.class);

    @Before
    public void beforeTest() throws IOException {
        String yearCol = "year";
        String monthCol = "month";
        String dayCol = "day";
        Schema schema = SchemaBuilder.newBuilder().addField(yearCol, (ArrowType)new ArrowType.Int(32, true)).addField(monthCol, (ArrowType)new ArrowType.Int(32, true)).addField(dayCol, (ArrowType)new ArrowType.Int(32, true)).build();
        Block records = this.allocator.createBlock(schema);
        int num_records = 10;
        for (int i = 0; i < num_records; ++i) {
            BlockUtils.setValue((FieldVector)records.getFieldVector(yearCol), (int)i, (Object)(2016 + i));
            BlockUtils.setValue((FieldVector)records.getFieldVector(monthCol), (int)i, (Object)(i % 12 + 1));
            BlockUtils.setValue((FieldVector)records.getFieldVector(dayCol), (int)i, (Object)(i % 28 + 1));
        }
        records.setRowCount(num_records);
        this.expected = new ReadRecordsResponse("test-catalog", records);
        String expectedSerDeFile = this.utils.getResourceOrFail("serde/v2", "ReadRecordsResponse.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    @Test
    public void serialize() throws IOException {
        logger.info("serialize: enter");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)outputStream, this.expected);
        String actual = new String(outputStream.toByteArray(), JsonEncoding.UTF8.getJavaName());
        logger.info("serialize: serialized text[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expectedSerDeText, (Object)actual);
        logger.info("serialize: exit");
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        ReadRecordsResponse actual = (ReadRecordsResponse)this.mapper.readValue((InputStream)input, FederationResponse.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        logger.info("deserialize: exit");
    }
}

