/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.domain.predicate.functions.StandardFunctions;
import com.amazonaws.athena.connector.lambda.metadata.GetDataSourceCapabilitiesResponse;
import com.amazonaws.athena.connector.lambda.metadata.optimizations.DataSourceOptimizations;
import com.amazonaws.athena.connector.lambda.metadata.optimizations.pushdown.ComplexExpressionPushdownSubType;
import com.amazonaws.athena.connector.lambda.metadata.optimizations.pushdown.PushdownSubTypes;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.fasterxml.jackson.core.JsonEncoding;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDataSourceCapabilitiesResponseSerDeTest
extends TypedSerDeTest<FederationResponse> {
    private static final Logger logger = LoggerFactory.getLogger(GetDataSourceCapabilitiesResponseSerDeTest.class);

    @Before
    public void beforeTest() throws IOException {
        ImmutableMap.Builder capabilities = ImmutableMap.builder();
        capabilities.put(DataSourceOptimizations.SUPPORTS_COMPLEX_EXPRESSION_PUSHDOWN.withSupportedSubTypes(new PushdownSubTypes[]{ComplexExpressionPushdownSubType.SUPPORTED_FUNCTION_EXPRESSION_TYPES.withSubTypeProperties(new String[]{StandardFunctions.ADD_FUNCTION_NAME.getFunctionName().getFunctionName(), StandardFunctions.SUBTRACT_FUNCTION_NAME.getFunctionName().getFunctionName()})}));
        this.expected = new GetDataSourceCapabilitiesResponse("test-catalog", (Map)capabilities.build());
        String expectedSerDeFile = this.utils.getResourceOrFail("serde/v4", "GetDataSourceCapabilitiesResponse.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    @Test
    public void serialize() throws IOException {
        logger.info("serialize: enter");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mapperV4.writeValue((OutputStream)outputStream, this.expected);
        String actual = new String(outputStream.toByteArray(), JsonEncoding.UTF8.getJavaName());
        logger.info("serialize: serialized text[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expectedSerDeText, (Object)actual);
        logger.info("serialize: exit");
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        GetDataSourceCapabilitiesResponse actual = (GetDataSourceCapabilitiesResponse)this.mapperV4.readValue((InputStream)input, FederationResponse.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        logger.info("deserialize: exit");
    }
}

