/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v5;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.GetTableRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.fasterxml.jackson.core.JsonEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTableRequestSerDeV5Test
extends TypedSerDeTest<FederationRequest> {
    private static final Logger logger = LoggerFactory.getLogger(GetTableRequestSerDeV5Test.class);

    @Before
    public void beforeTest() throws IOException {
        HashMap<String, String> queryPassthroughArguments = new HashMap<String, String>(1);
        queryPassthroughArguments.put("query", "SELECT * FROM DUMMY_TABLE;");
        this.expected = new GetTableRequest(this.federatedIdentity, "test-query-id", "test-catalog", new TableName("test-schema", "test-table"), queryPassthroughArguments);
        String expectedSerDeFile = this.utils.getResourceOrFail("serde/v5", "GetTableRequest.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    @Test
    public void serialize() throws IOException {
        logger.info("serialize: enter");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mapperV5.writeValue((OutputStream)outputStream, this.expected);
        String actual = new String(outputStream.toByteArray(), JsonEncoding.UTF8.getJavaName());
        logger.info("serialize: serialized text[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expectedSerDeText, (Object)actual);
        logger.info("serialize: exit");
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        GetTableRequest actual = (GetTableRequest)this.mapperV5.readValue((InputStream)input, FederationRequest.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        logger.info("deserialize: exit");
    }
}

