/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestUtils.class);
    public static final int SERDE_VERSION_ONE = 1;
    public static final int SERDE_VERSION_TWO = 2;
    public static final int SERDE_VERSION_THREE = 3;
    public static final int SERDE_VERSION_FOUR = 4;
    public static final int SERDE_VERSION_FIVE = 5;

    public String getResourceOrFail(String locationHint, String resource) {
        String resourcePath = locationHint != null ? locationHint + "/" : "";
        resourcePath = resourcePath + resource;
        URL resourceUrl = this.getClass().getClassLoader().getResource(resourcePath);
        if (resourceUrl == null) {
            String path = System.getProperty("test-resources-dir");
            String buildPath = locationHint != null ? locationHint + "/" : "";
            buildPath = buildPath + resource;
            File resourceFile = new File(path + "/" + buildPath);
            if (resourceFile.exists()) {
                return resourceFile.getPath();
            }
        }
        Objects.requireNonNull(resourceUrl, "Unable to find resource[" + resource + "]");
        LOGGER.info("getResourceOrFail: found[" + resource + "] at [" + resourceUrl + "]");
        return resourceUrl.getFile();
    }

    public String readFileAsString(String locationHint, String resource) throws IOException {
        String file = this.getResourceOrFail(locationHint, resource);
        return this.readAllAsString(file);
    }

    public String readAllAsString(String file) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(file, new String[0]));
        return new String(encoded);
    }

    public String readAllAsString(String file, Charset charset) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(file, new String[0]));
        return new String(encoded, charset);
    }
}

