/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.util;

import com.amazonaws.athena.connector.util.PaginatedRequestIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class PaginatedRequestIteratorTest {
    Function<String, Map<String, String>> fakePageRequest = pageToken -> {
        if (pageToken == null) {
            return ImmutableMap.of((Object)"data", (Object)"aaa", (Object)"nextPage", (Object)"2");
        }
        if (pageToken.equals("2")) {
            return ImmutableMap.of((Object)"data", (Object)"bbb", (Object)"nextPage", (Object)"3");
        }
        if (pageToken.equals("3")) {
            return ImmutableMap.of((Object)"data", (Object)"ccc");
        }
        return null;
    };
    Function<Map<String, String>, String> getPageToken = in -> (String)in.get("nextPage");

    @Test
    public void testIteratesOverAllPages() {
        List result = PaginatedRequestIterator.stream(this.fakePageRequest, this.getPageToken).map(r -> (String)r.get("data")).collect(Collectors.toList());
        Assert.assertEquals((Object)ImmutableList.of((Object)"aaa", (Object)"bbb", (Object)"ccc"), result);
    }

    @Test
    public void testBehavior() {
        int i;
        PaginatedRequestIterator iterator = new PaginatedRequestIterator(this.fakePageRequest, this.getPageToken);
        Assert.assertTrue((boolean)iterator.hasNext());
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
        }
        Assert.assertEquals((Object)ImmutableMap.of((Object)"data", (Object)"aaa", (Object)"nextPage", (Object)"2"), (Object)iterator.next());
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
        }
        Assert.assertEquals((Object)ImmutableMap.of((Object)"data", (Object)"bbb", (Object)"nextPage", (Object)"3"), (Object)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
        }
        Assert.assertEquals((Object)ImmutableMap.of((Object)"data", (Object)"ccc"), (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Expected NoSuchElementException but did not get one");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

