/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockWriter;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesRequest;
import com.amazonaws.athena.connectors.jdbc.MultiplexingJdbcMetadataHandler;
import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionConfig;
import com.amazonaws.athena.connectors.jdbc.connection.JdbcConnectionFactory;
import com.amazonaws.athena.connectors.jdbc.manager.JdbcMetadataHandler;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MultiplexingJdbcMetadataHandlerTest {
    private Map<String, JdbcMetadataHandler> metadataHandlerMap;
    private JdbcMetadataHandler fakeDatabaseHandler;
    private JdbcMetadataHandler jdbcMetadataHandler;
    private BlockAllocator allocator;
    private AWSSecretsManager secretsManager;
    private AmazonAthena athena;
    private QueryStatusChecker queryStatusChecker;
    private JdbcConnectionFactory jdbcConnectionFactory;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
        this.fakeDatabaseHandler = (JdbcMetadataHandler)Mockito.mock(JdbcMetadataHandler.class);
        this.metadataHandlerMap = Collections.singletonMap("fakedatabase", this.fakeDatabaseHandler);
        this.secretsManager = (AWSSecretsManager)Mockito.mock(AWSSecretsManager.class);
        this.athena = (AmazonAthena)Mockito.mock(AmazonAthena.class);
        this.queryStatusChecker = (QueryStatusChecker)Mockito.mock(QueryStatusChecker.class);
        this.jdbcConnectionFactory = (JdbcConnectionFactory)Mockito.mock(JdbcConnectionFactory.class);
        DatabaseConnectionConfig databaseConnectionConfig = new DatabaseConnectionConfig("testCatalog", "fakedatabase", "fakedatabase://jdbc:fakedatabase://hostname/${testSecret}", "testSecret");
        this.jdbcMetadataHandler = new MultiplexingJdbcMetadataHandler(this.secretsManager, this.athena, this.jdbcConnectionFactory, this.metadataHandlerMap, databaseConnectionConfig, (Map)ImmutableMap.of());
    }

    @Test
    public void doListSchemaNames() throws Exception {
        ListSchemasRequest listSchemasRequest = (ListSchemasRequest)Mockito.mock(ListSchemasRequest.class);
        Mockito.when((Object)listSchemasRequest.getCatalogName()).thenReturn((Object)"fakedatabase");
        this.jdbcMetadataHandler.doListSchemaNames(this.allocator, listSchemasRequest);
        ((JdbcMetadataHandler)Mockito.verify((Object)this.fakeDatabaseHandler, (VerificationMode)Mockito.times((int)1))).doListSchemaNames((BlockAllocator)Mockito.eq((Object)this.allocator), (ListSchemasRequest)Mockito.eq((Object)listSchemasRequest));
    }

    @Test
    public void doListTables() throws Exception {
        ListTablesRequest listTablesRequest = (ListTablesRequest)Mockito.mock(ListTablesRequest.class);
        Mockito.when((Object)listTablesRequest.getCatalogName()).thenReturn((Object)"fakedatabase");
        this.jdbcMetadataHandler.doListTables(this.allocator, listTablesRequest);
        ((JdbcMetadataHandler)Mockito.verify((Object)this.fakeDatabaseHandler, (VerificationMode)Mockito.times((int)1))).doListTables((BlockAllocator)Mockito.eq((Object)this.allocator), (ListTablesRequest)Mockito.eq((Object)listTablesRequest));
    }

    @Test
    public void doGetTable() throws Exception {
        GetTableRequest getTableRequest = (GetTableRequest)Mockito.mock(GetTableRequest.class);
        Mockito.when((Object)getTableRequest.getCatalogName()).thenReturn((Object)"fakedatabase");
        this.jdbcMetadataHandler.doGetTable(this.allocator, getTableRequest);
        ((JdbcMetadataHandler)Mockito.verify((Object)this.fakeDatabaseHandler, (VerificationMode)Mockito.times((int)1))).doGetTable((BlockAllocator)Mockito.eq((Object)this.allocator), (GetTableRequest)Mockito.eq((Object)getTableRequest));
    }

    @Test
    public void doGetTableLayout() throws Exception {
        GetTableLayoutRequest getTableLayoutRequest = (GetTableLayoutRequest)Mockito.mock(GetTableLayoutRequest.class);
        Mockito.when((Object)getTableLayoutRequest.getTableName()).thenReturn((Object)new TableName("testSchema", "testTable"));
        Mockito.when((Object)getTableLayoutRequest.getCatalogName()).thenReturn((Object)"fakedatabase");
        this.jdbcMetadataHandler.doGetTableLayout(this.allocator, getTableLayoutRequest);
        ((JdbcMetadataHandler)Mockito.verify((Object)this.fakeDatabaseHandler, (VerificationMode)Mockito.times((int)1))).doGetTableLayout((BlockAllocator)Mockito.eq((Object)this.allocator), (GetTableLayoutRequest)Mockito.eq((Object)getTableLayoutRequest));
    }

    @Test
    public void getPartitionSchema() {
        this.jdbcMetadataHandler.getPartitionSchema("fakedatabase");
        ((JdbcMetadataHandler)Mockito.verify((Object)this.fakeDatabaseHandler, (VerificationMode)Mockito.times((int)1))).getPartitionSchema((String)Mockito.eq((Object)"fakedatabase"));
    }

    @Test(expected=RuntimeException.class)
    public void getPartitionSchemaForUnsupportedCatalog() {
        this.jdbcMetadataHandler.getPartitionSchema("unsupportedCatalog");
    }

    @Test
    public void getPartitions() throws Exception {
        GetTableLayoutRequest getTableLayoutRequest = (GetTableLayoutRequest)Mockito.mock(GetTableLayoutRequest.class);
        Mockito.when((Object)getTableLayoutRequest.getCatalogName()).thenReturn((Object)"fakedatabase");
        this.jdbcMetadataHandler.getPartitions((BlockWriter)Mockito.mock(BlockWriter.class), getTableLayoutRequest, this.queryStatusChecker);
        ((JdbcMetadataHandler)Mockito.verify((Object)this.fakeDatabaseHandler, (VerificationMode)Mockito.times((int)1))).getPartitions((BlockWriter)ArgumentMatchers.nullable(BlockWriter.class), (GetTableLayoutRequest)Mockito.eq((Object)getTableLayoutRequest), (QueryStatusChecker)Mockito.eq((Object)this.queryStatusChecker));
    }

    @Test
    public void doGetSplits() {
        GetSplitsRequest getSplitsRequest = (GetSplitsRequest)Mockito.mock(GetSplitsRequest.class);
        Mockito.when((Object)getSplitsRequest.getCatalogName()).thenReturn((Object)"fakedatabase");
        this.jdbcMetadataHandler.doGetSplits(this.allocator, getSplitsRequest);
        ((JdbcMetadataHandler)Mockito.verify((Object)this.fakeDatabaseHandler, (VerificationMode)Mockito.times((int)1))).doGetSplits((BlockAllocator)Mockito.eq((Object)this.allocator), (GetSplitsRequest)Mockito.eq((Object)getSplitsRequest));
    }
}

