/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.data.BlockSpiller;
import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsRequest;
import com.amazonaws.athena.connectors.jdbc.MultiplexingJdbcRecordHandler;
import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionConfig;
import com.amazonaws.athena.connectors.jdbc.connection.JdbcConnectionFactory;
import com.amazonaws.athena.connectors.jdbc.manager.JdbcRecordHandler;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MultiplexingJdbcRecordHandlerTest {
    private Map<String, JdbcRecordHandler> recordHandlerMap;
    private JdbcRecordHandler fakeJdbcRecordHandler;
    private JdbcRecordHandler jdbcRecordHandler;
    private AmazonS3 amazonS3;
    private AWSSecretsManager secretsManager;
    private AmazonAthena athena;
    private QueryStatusChecker queryStatusChecker;
    private JdbcConnectionFactory jdbcConnectionFactory;

    @Before
    public void setup() {
        this.fakeJdbcRecordHandler = (JdbcRecordHandler)Mockito.mock(JdbcRecordHandler.class);
        this.recordHandlerMap = Collections.singletonMap("fakedatabase", this.fakeJdbcRecordHandler);
        this.amazonS3 = (AmazonS3)Mockito.mock(AmazonS3.class);
        this.secretsManager = (AWSSecretsManager)Mockito.mock(AWSSecretsManager.class);
        this.athena = (AmazonAthena)Mockito.mock(AmazonAthena.class);
        this.queryStatusChecker = (QueryStatusChecker)Mockito.mock(QueryStatusChecker.class);
        this.jdbcConnectionFactory = (JdbcConnectionFactory)Mockito.mock(JdbcConnectionFactory.class);
        DatabaseConnectionConfig databaseConnectionConfig = new DatabaseConnectionConfig("testCatalog", "fakedatabase", "fakedatabase://jdbc:fakedatabase://hostname/${testSecret}", "testSecret");
        this.jdbcRecordHandler = new MultiplexingJdbcRecordHandler(this.amazonS3, this.secretsManager, this.athena, this.jdbcConnectionFactory, databaseConnectionConfig, this.recordHandlerMap, (Map)ImmutableMap.of());
    }

    @Test
    public void readWithConstraint() throws Exception {
        BlockSpiller blockSpiller = (BlockSpiller)Mockito.mock(BlockSpiller.class);
        ReadRecordsRequest readRecordsRequest = (ReadRecordsRequest)Mockito.mock(ReadRecordsRequest.class);
        Mockito.when((Object)readRecordsRequest.getCatalogName()).thenReturn((Object)"fakedatabase");
        this.jdbcRecordHandler.readWithConstraint(blockSpiller, readRecordsRequest, this.queryStatusChecker);
        ((JdbcRecordHandler)Mockito.verify((Object)this.fakeJdbcRecordHandler, (VerificationMode)Mockito.times((int)1))).readWithConstraint((BlockSpiller)Mockito.eq((Object)blockSpiller), (ReadRecordsRequest)Mockito.eq((Object)readRecordsRequest), (QueryStatusChecker)Mockito.eq((Object)this.queryStatusChecker));
    }

    @Test(expected=RuntimeException.class)
    public void readWithConstraintWithUnsupportedCatalog() throws Exception {
        BlockSpiller blockSpiller = (BlockSpiller)Mockito.mock(BlockSpiller.class);
        ReadRecordsRequest readRecordsRequest = (ReadRecordsRequest)Mockito.mock(ReadRecordsRequest.class);
        Mockito.when((Object)readRecordsRequest.getCatalogName()).thenReturn((Object)"unsupportedCatalog");
        this.jdbcRecordHandler.readWithConstraint(blockSpiller, readRecordsRequest, this.queryStatusChecker);
    }

    @Test
    public void buildSplitSql() throws SQLException {
        ReadRecordsRequest readRecordsRequest = (ReadRecordsRequest)Mockito.mock(ReadRecordsRequest.class);
        Mockito.when((Object)readRecordsRequest.getCatalogName()).thenReturn((Object)"fakedatabase");
        Connection jdbcConnection = (Connection)Mockito.mock(Connection.class);
        TableName tableName = new TableName("testSchema", "tableName");
        Schema schema = (Schema)Mockito.mock(Schema.class);
        Constraints constraints = (Constraints)Mockito.mock(Constraints.class);
        Split split = (Split)Mockito.mock(Split.class);
        this.jdbcRecordHandler.buildSplitSql(jdbcConnection, "fakedatabase", tableName, schema, constraints, split);
        ((JdbcRecordHandler)Mockito.verify((Object)this.fakeJdbcRecordHandler, (VerificationMode)Mockito.times((int)1))).buildSplitSql((Connection)Mockito.eq((Object)jdbcConnection), (String)Mockito.eq((Object)"fakedatabase"), (TableName)Mockito.eq((Object)tableName), (Schema)Mockito.eq((Object)schema), (Constraints)Mockito.eq((Object)constraints), (Split)Mockito.eq((Object)split));
    }
}

