/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestBase {
    protected ResultSet mockResultSet(String[] columnNames, int[] columnTypes, Object[][] rows, AtomicInteger rowNumber) throws SQLException {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)resultSet.next()).thenAnswer(invocation -> {
            if (rows.length <= 0 || rows[0].length <= 0) {
                return false;
            }
            return rowNumber.getAndIncrement() + 1 < rows.length;
        });
        Mockito.when((Object)resultSet.getInt((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Object argument = invocation.getArguments()[0];
            if (argument instanceof Integer) {
                int colIndex = (Integer)argument;
                return (Integer)rows[rowNumber.get()][colIndex] - 1;
            }
            if (argument instanceof String) {
                int colIndex = Arrays.asList(columnNames).indexOf(argument);
                return (Integer)rows[rowNumber.get()][colIndex];
            }
            throw new RuntimeException("Unexpected argument type " + argument.getClass());
        });
        Mockito.when((Object)resultSet.getString((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Object argument = invocation.getArguments()[0];
            if (argument instanceof Integer) {
                int colIndex = (Integer)argument - 1;
                return String.valueOf(rows[rowNumber.get()][colIndex]);
            }
            if (argument instanceof String) {
                int colIndex = Arrays.asList(columnNames).indexOf(argument);
                return String.valueOf(rows[rowNumber.get()][colIndex]);
            }
            throw new RuntimeException("Unexpected argument type " + argument.getClass());
        });
        Mockito.when((Object)resultSet.getDouble((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Object argument = invocation.getArguments()[0];
            if (argument instanceof Integer) {
                int colIndex = (Integer)argument - 1;
                return (Double)rows[rowNumber.get()][colIndex];
            }
            if (argument instanceof String) {
                throw new SQLException("Postgres Money Type");
            }
            if (argument instanceof Double) {
                int colIndex = Arrays.asList(columnNames).indexOf(argument);
                return (Double)rows[rowNumber.get()][colIndex];
            }
            throw new RuntimeException("Unexpected argument type " + argument.getClass());
        });
        if (columnTypes != null) {
            Mockito.when((Object)resultSet.getMetaData().getColumnCount()).thenReturn((Object)columnNames.length);
            Mockito.when((Object)resultSet.getMetaData().getColumnDisplaySize(ArgumentMatchers.anyInt())).thenReturn((Object)10);
            Mockito.when((Object)resultSet.getMetaData().getColumnType(ArgumentMatchers.anyInt())).thenAnswer(invocation -> columnTypes[(Integer)invocation.getArguments()[0] - 1]);
        }
        return resultSet;
    }

    protected ResultSet mockResultSet(String[] columnNames, Object[][] rows, AtomicInteger rowNumber) throws SQLException {
        return this.mockResultSet(columnNames, null, rows, rowNumber);
    }
}

