/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc.connection;

import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionConfig;
import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionConfigBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class DatabaseConnectionConfigBuilderTest {
    private static final String CONNECTION_STRING1 = "mysql://jdbc:mysql://hostname/${testSecret}";
    private static final String CONNECTION_STRING2 = "postgres://jdbc:postgresql://hostname/user=testUser&password=testPassword";
    private static final String CONNECTION_STRING3 = "redshift://jdbc:redshift://hostname:5439/dev?${arn:aws:secretsmanager:us-east-1:1234567890:secret:redshift/user/secret}";
    private static final String CONNECTION_STRING4 = "postgres://jdbc:postgresql://hostname:5439/dev?${arn:aws:secretsmanager:us-east-1:1234567890:secret:postgresql/user/secret}";

    @Test
    public void build() {
        DatabaseConnectionConfig defaultConnection = new DatabaseConnectionConfig("default", "postgres", "jdbc:postgresql://hostname/user=testUser&password=testPassword");
        DatabaseConnectionConfig expectedDatabase1 = new DatabaseConnectionConfig("testCatalog1", "postgres", "jdbc:postgresql://hostname:5439/dev?${arn:aws:secretsmanager:us-east-1:1234567890:secret:postgresql/user/secret}", "arn:aws:secretsmanager:us-east-1:1234567890:secret:postgresql/user/secret");
        DatabaseConnectionConfig expectedDatabase2 = new DatabaseConnectionConfig("testCatalog2", "postgres", "jdbc:postgresql://hostname/user=testUser&password=testPassword");
        List databaseConnectionConfigs = new DatabaseConnectionConfigBuilder().engine("postgres").properties((Map)ImmutableMap.of((Object)"default", (Object)CONNECTION_STRING2, (Object)"testCatalog1_connection_string", (Object)CONNECTION_STRING4, (Object)"testCatalog2_connection_string", (Object)CONNECTION_STRING2)).build();
        Assert.assertEquals(Arrays.asList(defaultConnection, expectedDatabase1, expectedDatabase2), (Object)databaseConnectionConfigs);
    }

    @Test(expected=RuntimeException.class)
    public void buildMultipleDatabasesFails() {
        List databaseConnectionConfigs = new DatabaseConnectionConfigBuilder().properties((Map)ImmutableMap.of((Object)"default", (Object)CONNECTION_STRING2, (Object)"testCatalog1_connection_string", (Object)CONNECTION_STRING1, (Object)"testCatalog2_connection_string", (Object)CONNECTION_STRING2, (Object)"testCatalog3_connection_string", (Object)CONNECTION_STRING3)).build();
    }

    @Test(expected=RuntimeException.class)
    public void buildInvalidConnectionString() {
        new DatabaseConnectionConfigBuilder().properties(Collections.singletonMap("default", "malformedUrl")).build();
    }

    @Test(expected=RuntimeException.class)
    public void buildWithNoDefault() {
        new DatabaseConnectionConfigBuilder().properties(Collections.singletonMap("testDb_connection_string", CONNECTION_STRING1)).build();
    }

    @Test(expected=RuntimeException.class)
    public void buildMalformedConnectionString() {
        new DatabaseConnectionConfigBuilder().properties(Collections.singletonMap("testDb_connection_string", null)).build();
    }

    @Test
    public void invalidSecretsSyntaxTest() {
        String engine = "redshift";
        List<String> invalidConnectionStrings = Arrays.asList("redshift://jdbc:redshift://hostname:5439/dev?${inv&li$dSecret}", "redshift://jdbc:redshift://hostname:5439/dev?${an*therOne))}", "redshift://jdbc:redshift://hostname:5439/dev?${in^a]i?}", "redshift://jdbc:redshift://hostname:5439/dev?${an*therOne))}");
        for (String connection : invalidConnectionStrings) {
            Assert.assertThrows(RuntimeException.class, () -> new DatabaseConnectionConfigBuilder().properties(Collections.singletonMap("testDb_connection_string", connection)).engine(engine).build());
        }
    }

    @Test
    public void validSecretsSyntaxTest() {
        String engine = "redshift";
        String connectionString1 = "redshift://jdbc:redshift://hostname:5439/dev?${spec.@/Ch@rac+=r_}";
        String connectionString2 = "redshift://jdbc:redshift://hostname:5439/dev?${rds!service-linked-secret}";
        String connectionString3 = "redshift://jdbc:redshift://hostname:5439/dev?${redshift:credentials-secret}";
        String connectionString4 = "redshift://jdbc:redshift://hostname:5439/dev?${opsworks-cm:credentials12}";
        String[] secrets = new String[]{"spec.@/Ch@rac+=r_", "rds!service-linked-secret", "redshift:credentials-secret", "opsworks-cm:credentials12"};
        List databaseConnectionConfigs = new DatabaseConnectionConfigBuilder().engine(engine).properties((Map)ImmutableMap.of((Object)"default", (Object)connectionString1, (Object)"testCatalog2_connection_string", (Object)connectionString2, (Object)"testCatalog3_connection_string", (Object)connectionString3, (Object)"testCatalog4_connection_string", (Object)connectionString4)).build();
        Assert.assertEquals((long)secrets.length, (long)databaseConnectionConfigs.size());
        for (int i = 0; i < databaseConnectionConfigs.size(); ++i) {
            Assert.assertEquals((Object)secrets[i], (Object)((DatabaseConnectionConfig)databaseConnectionConfigs.get(i)).getSecret());
        }
    }
}

