/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc.integ;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionConfig;
import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionConfigBuilder;
import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionInfo;
import com.amazonaws.athena.connectors.jdbc.connection.GenericJdbcConnectionFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTableUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTableUtils.class);
    private final String catalog;
    private final String schemaName;
    private final String tableName;
    private final Map environmentVars;
    private final Map properties;
    private final String engine;

    public JdbcTableUtils(String catalog, TableName table, Map environmentVars) {
        this(catalog, table, environmentVars, null, null);
    }

    public JdbcTableUtils(String catalog, TableName table, Map environmentVars, Map properties, String engine) {
        this.catalog = catalog;
        this.schemaName = table.getSchemaName();
        this.tableName = table.getTableName();
        this.environmentVars = environmentVars;
        this.properties = properties;
        this.engine = (String)Validate.notBlank((CharSequence)engine);
    }

    public void createDbSchema(DatabaseConnectionInfo databaseConnectionInfo) throws Exception {
        try (Connection connection = this.getDbConnection(databaseConnectionInfo);){
            String createStatement = String.format("create schema %s;", this.schemaName);
            PreparedStatement createSchema = connection.prepareStatement(createStatement);
            logger.info("Statement prepared: {}", (Object)createStatement);
            createSchema.execute();
            logger.info("Created the DB schema: {}", (Object)this.schemaName);
        }
    }

    public void createTable(String tableSchema, DatabaseConnectionInfo databaseConnectionInfo) throws Exception {
        try (Connection connection = this.getDbConnection(databaseConnectionInfo);){
            String createStatement = String.format("create table %s.%s (%s);", this.schemaName, this.tableName, tableSchema);
            PreparedStatement createTable = connection.prepareStatement(createStatement);
            logger.info("Statement prepared: {}", (Object)createStatement);
            createTable.execute();
            logger.info("Created the '{}' table.", (Object)this.tableName);
        }
    }

    public void insertRow(String tableValues, DatabaseConnectionInfo databaseConnectionInfo) throws Exception {
        try (Connection connection = this.getDbConnection(databaseConnectionInfo);){
            String insertStatement = String.format("insert into %s.%s values(%s);", this.schemaName, this.tableName, tableValues);
            PreparedStatement insertValues = connection.prepareStatement(insertStatement);
            logger.info("Statement prepared: {}", (Object)insertStatement);
            insertValues.execute();
            logger.info("Inserted row into the '{}' table.", (Object)this.tableName);
        }
    }

    protected Connection getDbConnection(DatabaseConnectionInfo databaseConnectionInfo) throws Exception {
        DatabaseConnectionConfig connectionConfig = this.getDbConfig();
        GenericJdbcConnectionFactory connectionFactory = new GenericJdbcConnectionFactory(connectionConfig, this.properties, databaseConnectionInfo);
        return connectionFactory.getConnection(null);
    }

    protected DatabaseConnectionConfig getDbConfig() {
        DatabaseConnectionConfigBuilder configBuilder = new DatabaseConnectionConfigBuilder();
        for (DatabaseConnectionConfig config : configBuilder.properties(this.environmentVars).engine(this.engine).build()) {
            if (!config.getCatalog().equals(this.catalog)) continue;
            return config;
        }
        throw new RuntimeException("Unable to configure connection to DB.");
    }
}

