/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc.manager;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockWriter;
import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionConfig;
import com.amazonaws.athena.connectors.jdbc.manager.JDBCUtil;
import com.amazonaws.athena.connectors.jdbc.manager.JdbcMetadataHandler;
import com.amazonaws.athena.connectors.jdbc.manager.JdbcMetadataHandlerFactory;
import com.amazonaws.athena.connectors.jdbc.manager.JdbcRecordHandler;
import com.amazonaws.athena.connectors.jdbc.manager.JdbcRecordHandlerFactory;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;

public class JDBCUtilTest {
    private static final String CONNECTION_STRING1 = "fakedatabase://jdbc:fakedatabase://hostname/${testSecret}";
    private static final String CONNECTION_STRING2 = "notrealdb://jdbc:notrealdb://hostname/user=testUser&password=testPassword";

    @Test
    public void createJdbcMetadataHandlerMap() {
        Map catalogs = JDBCUtil.createJdbcMetadataHandlerMap((Map)ImmutableMap.builder().put((Object)"testCatalog1_connection_string", (Object)CONNECTION_STRING1).put((Object)"default", (Object)CONNECTION_STRING1).put((Object)"AWS_LAMBDA_FUNCTION_NAME", (Object)"functionName").build(), (JdbcMetadataHandlerFactory)new FakeDatabaseMetadataHandlerFactory());
        Assert.assertEquals((long)3L, (long)catalogs.size());
        Assert.assertEquals(((JdbcMetadataHandler)catalogs.get("testCatalog1")).getClass(), FakeDatabaseJdbcMetadataHandler.class);
        Assert.assertEquals(((JdbcMetadataHandler)catalogs.get("lambda:functionName")).getClass(), FakeDatabaseJdbcMetadataHandler.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createJdbcMetadataHandlerMapDifferentDatabasesThrows() {
        Map catalogs = JDBCUtil.createJdbcMetadataHandlerMap((Map)ImmutableMap.builder().put((Object)"testCatalog1_connection_string", (Object)CONNECTION_STRING1).put((Object)"testCatalog2_connection_string", (Object)CONNECTION_STRING2).put((Object)"default", (Object)CONNECTION_STRING2).put((Object)"AWS_LAMBDA_FUNCTION_NAME", (Object)"functionName").build(), (JdbcMetadataHandlerFactory)new FakeDatabaseMetadataHandlerFactory());
    }

    @Test(expected=RuntimeException.class)
    public void createJdbcMetadataHandlerEmptyConnectionStrings() {
        JDBCUtil.createJdbcMetadataHandlerMap(Collections.emptyMap(), (JdbcMetadataHandlerFactory)new FakeDatabaseMetadataHandlerFactory());
    }

    @Test(expected=RuntimeException.class)
    public void createJdbcMetadataHandlerNoDefault() {
        JDBCUtil.createJdbcMetadataHandlerMap((Map)ImmutableMap.builder().put((Object)"testCatalog1_connection_string", (Object)CONNECTION_STRING1).put((Object)"testCatalog2_connection_string", (Object)CONNECTION_STRING2).put((Object)"default", (Object)CONNECTION_STRING2).put((Object)"AWS_LAMBDA_FUNCTION_NAME", (Object)"functionName").build(), (JdbcMetadataHandlerFactory)new FakeDatabaseMetadataHandlerFactory());
    }

    @Test
    public void createJdbcRecordHandlerMap() {
        Map catalogs = JDBCUtil.createJdbcRecordHandlerMap((Map)ImmutableMap.builder().put((Object)"testCatalog1_connection_string", (Object)CONNECTION_STRING1).put((Object)"default", (Object)CONNECTION_STRING1).put((Object)"AWS_LAMBDA_FUNCTION_NAME", (Object)"functionName").build(), (JdbcRecordHandlerFactory)new FakeDatabaseRecordHandlerFactory());
        Assert.assertEquals(((JdbcRecordHandler)catalogs.get("testCatalog1")).getClass(), FakeDatabaseJdbcRecordHandler.class);
        Assert.assertEquals(((JdbcRecordHandler)catalogs.get("lambda:functionName")).getClass(), FakeDatabaseJdbcRecordHandler.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createJdbcRecordHandlerMapDifferentDatabasesThrows() {
        Map catalogs = JDBCUtil.createJdbcRecordHandlerMap((Map)ImmutableMap.builder().put((Object)"testCatalog1_connection_string", (Object)CONNECTION_STRING1).put((Object)"testCatalog2_connection_string", (Object)CONNECTION_STRING2).put((Object)"default", (Object)CONNECTION_STRING2).put((Object)"AWS_LAMBDA_FUNCTION_NAME", (Object)"functionName").build(), (JdbcRecordHandlerFactory)new FakeDatabaseRecordHandlerFactory());
    }

    @Test(expected=RuntimeException.class)
    public void createJdbcRecordHandlerMapEmptyConnectionStrings() {
        JDBCUtil.createJdbcRecordHandlerMap(Collections.emptyMap(), (JdbcRecordHandlerFactory)new FakeDatabaseRecordHandlerFactory());
    }

    @Test(expected=RuntimeException.class)
    public void createJdbcRecordHandlerMapNoDefault() {
        JDBCUtil.createJdbcRecordHandlerMap((Map)ImmutableMap.builder().put((Object)"testCatalog1_connection_string", (Object)CONNECTION_STRING1).put((Object)"testCatalog2_connection_string", (Object)CONNECTION_STRING2).build(), (JdbcRecordHandlerFactory)new FakeDatabaseRecordHandlerFactory());
    }

    class FakeDatabaseRecordHandlerFactory
    implements JdbcRecordHandlerFactory {
        FakeDatabaseRecordHandlerFactory() {
        }

        public String getEngine() {
            return "fakedatabase";
        }

        public JdbcRecordHandler createJdbcRecordHandler(DatabaseConnectionConfig config, Map<String, String> configOptions) {
            return new FakeDatabaseJdbcRecordHandler("fakedatabase", configOptions);
        }
    }

    class FakeDatabaseMetadataHandlerFactory
    implements JdbcMetadataHandlerFactory {
        FakeDatabaseMetadataHandlerFactory() {
        }

        public String getEngine() {
            return "fakedatabase";
        }

        public JdbcMetadataHandler createJdbcMetadataHandler(DatabaseConnectionConfig config, Map<String, String> configOptions) {
            return new FakeDatabaseJdbcMetadataHandler("fakedatabase", configOptions);
        }
    }

    class FakeDatabaseJdbcRecordHandler
    extends JdbcRecordHandler {
        protected FakeDatabaseJdbcRecordHandler(String sourceType, Map<String, String> configOptions) {
            super(sourceType, configOptions);
        }

        public PreparedStatement buildSplitSql(Connection jdbcConnection, String catalogName, TableName tableName, Schema schema, Constraints constraints, Split split) throws SQLException {
            return null;
        }
    }

    class FakeDatabaseJdbcMetadataHandler
    extends JdbcMetadataHandler {
        public FakeDatabaseJdbcMetadataHandler(String sourceType, Map<String, String> configOptions) {
            super(sourceType, configOptions);
        }

        public Schema getPartitionSchema(String catalogName) {
            return null;
        }

        public void getPartitions(BlockWriter blockWriter, GetTableLayoutRequest request, QueryStatusChecker queryStatusChecker) throws Exception {
        }

        public GetSplitsResponse doGetSplits(BlockAllocator blockAllocator, GetSplitsRequest getSplitsRequest) {
            return null;
        }
    }
}

