/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc.manager;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockWriter;
import com.amazonaws.athena.connector.lambda.data.FieldBuilder;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesResponse;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connectors.jdbc.TestBase;
import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionConfig;
import com.amazonaws.athena.connectors.jdbc.connection.JdbcConnectionFactory;
import com.amazonaws.athena.connectors.jdbc.connection.JdbcCredentialProvider;
import com.amazonaws.athena.connectors.jdbc.manager.JdbcMetadataHandler;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class JdbcMetadataHandlerTest
extends TestBase {
    private static final Schema PARTITION_SCHEMA = SchemaBuilder.newBuilder().addField("testPartitionCol", Types.MinorType.VARCHAR.getType()).build();
    private JdbcMetadataHandler jdbcMetadataHandler;
    private JdbcConnectionFactory jdbcConnectionFactory;
    private FederatedIdentity federatedIdentity;
    private Connection connection;
    private BlockAllocator blockAllocator;
    private AWSSecretsManager secretsManager;
    private AmazonAthena athena;
    private ResultSet resultSetName;

    @Before
    public void setup() throws Exception {
        this.jdbcConnectionFactory = (JdbcConnectionFactory)Mockito.mock(JdbcConnectionFactory.class);
        this.connection = (Connection)Mockito.mock(Connection.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.connection.getCatalog()).thenReturn((Object)"testCatalog");
        Mockito.when((Object)this.jdbcConnectionFactory.getConnection((JdbcCredentialProvider)ArgumentMatchers.nullable(JdbcCredentialProvider.class))).thenReturn((Object)this.connection);
        this.secretsManager = (AWSSecretsManager)Mockito.mock(AWSSecretsManager.class);
        this.athena = (AmazonAthena)Mockito.mock(AmazonAthena.class);
        Mockito.when((Object)this.secretsManager.getSecretValue((GetSecretValueRequest)Mockito.eq((Object)new GetSecretValueRequest().withSecretId("testSecret")))).thenReturn((Object)new GetSecretValueResult().withSecretString("{\"username\": \"testUser\", \"password\": \"testPassword\"}"));
        DatabaseConnectionConfig databaseConnectionConfig = new DatabaseConnectionConfig("testCatalog", "fakedatabase", "fakedatabase://jdbc:fakedatabase://hostname/${testSecret}", "testSecret");
        this.jdbcMetadataHandler = new JdbcMetadataHandler(databaseConnectionConfig, this.secretsManager, this.athena, this.jdbcConnectionFactory, (Map)ImmutableMap.of()){

            public Schema getPartitionSchema(String catalogName) {
                return PARTITION_SCHEMA;
            }

            public void getPartitions(BlockWriter blockWriter, GetTableLayoutRequest getTableLayoutRequest, QueryStatusChecker queryStatusChecker) {
            }

            public GetSplitsResponse doGetSplits(BlockAllocator blockAllocator, GetSplitsRequest getSplitsRequest) {
                return null;
            }
        };
        this.federatedIdentity = (FederatedIdentity)Mockito.mock(FederatedIdentity.class);
        this.blockAllocator = (BlockAllocator)Mockito.mock(BlockAllocator.class);
        String[] columnNames = new String[]{"TABLE_SCHEM", "TABLE_NAME"};
        Object[][] tableNameValues = new String[][]{{"testSchema", "testTable"}};
        this.resultSetName = this.mockResultSet(columnNames, tableNameValues, new AtomicInteger(-1));
        Mockito.when((Object)this.connection.getMetaData().getTables((String)Mockito.eq((Object)this.connection.getCatalog()), (String)ArgumentMatchers.any(), (String)Mockito.eq(null), (String[])Mockito.eq((Object)new String[]{"TABLE", "VIEW", "EXTERNAL TABLE"}))).thenReturn((Object)this.resultSetName);
    }

    @Test
    public void getJdbcConnectionFactory() {
        Assert.assertEquals((Object)this.jdbcConnectionFactory, (Object)this.jdbcMetadataHandler.getJdbcConnectionFactory());
    }

    @Test
    public void doListSchemaNames() throws Exception {
        String[] schema = new String[]{"TABLE_SCHEM"};
        Object[][] values = new Object[][]{{"testDB"}, {"testdb2"}, {"information_schema"}};
        Object[] expected = new String[]{"testDB", "testdb2"};
        AtomicInteger rowNumber = new AtomicInteger(-1);
        ResultSet resultSet = this.mockResultSet(schema, values, rowNumber);
        Mockito.when((Object)this.connection.getMetaData().getSchemas()).thenReturn((Object)resultSet);
        ListSchemasResponse listSchemasResponse = this.jdbcMetadataHandler.doListSchemaNames(this.blockAllocator, new ListSchemasRequest(this.federatedIdentity, "testQueryId", "testCatalog"));
        Assert.assertArrayEquals((Object[])expected, (Object[])listSchemasResponse.getSchemas().toArray());
    }

    @Test
    public void doListTables() throws Exception {
        String[] schema = new String[]{"TABLE_SCHEM", "TABLE_NAME"};
        Object[][] values = new Object[][]{{"testSchema", "testTable"}, {"testSchema", "testtable2"}};
        Object[] expected = new TableName[]{new TableName("testSchema", "testTable"), new TableName("testSchema", "testtable2")};
        AtomicInteger rowNumber = new AtomicInteger(-1);
        ResultSet resultSet = this.mockResultSet(schema, values, rowNumber);
        Mockito.when((Object)this.connection.getMetaData().getTables("testCatalog", "testSchema", null, new String[]{"TABLE", "VIEW", "EXTERNAL TABLE", "MATERIALIZED VIEW"})).thenReturn((Object)resultSet);
        ListTablesResponse listTablesResponse = this.jdbcMetadataHandler.doListTables(this.blockAllocator, new ListTablesRequest(this.federatedIdentity, "testQueryId", "testCatalog", "testSchema", null, -1));
        Assert.assertArrayEquals((Object[])expected, (Object[])listTablesResponse.getTables().toArray());
    }

    @Test
    public void doListTablesEscaped() throws Exception {
        String[] schema = new String[]{"TABLE_SCHEM", "TABLE_NAME"};
        Object[][] values = new Object[][]{{"test_Schema", "testTable"}, {"test_Schema", "testtable2"}};
        Object[] expected = new TableName[]{new TableName("test_Schema", "testTable"), new TableName("test_Schema", "testtable2")};
        AtomicInteger rowNumber = new AtomicInteger(-1);
        ResultSet resultSet = this.mockResultSet(schema, values, rowNumber);
        Mockito.when((Object)this.connection.getMetaData().getTables("testCatalog", "test\\_Schema", null, new String[]{"TABLE", "VIEW", "EXTERNAL TABLE", "MATERIALIZED VIEW"})).thenReturn((Object)resultSet);
        Mockito.when((Object)this.connection.getMetaData().getSearchStringEscape()).thenReturn((Object)"\\");
        ListTablesResponse listTablesResponse = this.jdbcMetadataHandler.doListTables(this.blockAllocator, new ListTablesRequest(this.federatedIdentity, "testQueryId", "testCatalog", "test_Schema", null, -1));
        Assert.assertArrayEquals((Object[])expected, (Object[])listTablesResponse.getTables().toArray());
    }

    @Test(expected=IllegalArgumentException.class)
    public void doListTablesEscapedException() throws Exception {
        Mockito.when((Object)this.connection.getMetaData().getSearchStringEscape()).thenReturn((Object)"_");
        this.jdbcMetadataHandler.doListTables(this.blockAllocator, new ListTablesRequest(this.federatedIdentity, "testQueryId", "testCatalog", "test_Schema", null, -1));
    }

    @Test
    public void doGetTable() throws Exception {
        String[] schema = new String[]{"DATA_TYPE", "COLUMN_SIZE", "COLUMN_NAME", "DECIMAL_DIGITS", "NUM_PREC_RADIX"};
        Object[][] values = new Object[][]{{4, 12, "testCol1", 0, 0}, {12, 25, "testCol2", 0, 0}, {93, 93, "testCol3", 0, 0}, {2014, 93, "testCol4", 0, 0}};
        AtomicInteger rowNumber = new AtomicInteger(-1);
        ResultSet resultSet = this.mockResultSet(schema, values, rowNumber);
        SchemaBuilder expectedSchemaBuilder = SchemaBuilder.newBuilder();
        expectedSchemaBuilder.addField(FieldBuilder.newBuilder((String)"testCol1", (ArrowType)Types.MinorType.INT.getType()).build());
        expectedSchemaBuilder.addField(FieldBuilder.newBuilder((String)"testCol2", (ArrowType)Types.MinorType.VARCHAR.getType()).build());
        expectedSchemaBuilder.addField(FieldBuilder.newBuilder((String)"testCol3", (ArrowType)Types.MinorType.DATEMILLI.getType()).build());
        expectedSchemaBuilder.addField(FieldBuilder.newBuilder((String)"testCol4", (ArrowType)Types.MinorType.VARCHAR.getType()).build());
        PARTITION_SCHEMA.getFields().forEach(arg_0 -> ((SchemaBuilder)expectedSchemaBuilder).addField(arg_0));
        Schema expected = expectedSchemaBuilder.build();
        TableName inputTableName = new TableName("testSchema", "testTable");
        Mockito.when((Object)this.connection.getMetaData().getColumns("testCatalog", inputTableName.getSchemaName(), inputTableName.getTableName(), null)).thenReturn((Object)resultSet);
        GetTableResponse getTableResponse = this.jdbcMetadataHandler.doGetTable(this.blockAllocator, new GetTableRequest(this.federatedIdentity, "testQueryId", "testCatalog", inputTableName, Collections.emptyMap()));
        Assert.assertEquals((Object)expected, (Object)getTableResponse.getSchema());
        Assert.assertEquals((Object)inputTableName, (Object)getTableResponse.getTableName());
        Assert.assertEquals((Object)"testCatalog", (Object)getTableResponse.getCatalogName());
    }

    @Test
    public void doGetTableCaseInsensitive() throws Exception {
        TableName inputTableName = new TableName("testSchema", "testTable");
        Object[][] values1 = new Object[][]{{"testSchema", "testTable"}, {"testSchema", "testTable2"}};
        this.setupMocksDoGetTableCaseInsensitive(inputTableName, values1, "testTable");
        GetTableResponse getTableResponse = this.jdbcMetadataHandler.doGetTable(this.blockAllocator, new GetTableRequest(this.federatedIdentity, "testQueryId", "testCatalog", inputTableName, Collections.emptyMap()));
        Assert.assertEquals((Object)"testTable", (Object)getTableResponse.getTableName().getTableName());
    }

    @Test(expected=RuntimeException.class)
    public void doGetTableNoColumns() throws Exception {
        TableName inputTableName = new TableName("testSchema", "testTable");
        this.jdbcMetadataHandler.doGetTable(this.blockAllocator, new GetTableRequest(this.federatedIdentity, "testQueryId", "testCatalog", inputTableName, Collections.emptyMap()));
    }

    @Test(expected=SQLException.class)
    public void doGetTableSQLException() throws Exception {
        TableName inputTableName = new TableName("testSchema", "testTable");
        Mockito.when((Object)this.connection.getMetaData().getColumns((String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.nullable(String.class), (String)Mockito.isNull())).thenThrow(new Throwable[]{new SQLException()});
        this.jdbcMetadataHandler.doGetTable(this.blockAllocator, new GetTableRequest(this.federatedIdentity, "testQueryId", "testCatalog", inputTableName, Collections.emptyMap()));
    }

    @Test(expected=SQLException.class)
    public void doListSchemaNamesSQLException() throws Exception {
        Mockito.when((Object)this.connection.getMetaData().getSchemas()).thenThrow(new Throwable[]{new SQLException()});
        this.jdbcMetadataHandler.doListSchemaNames(this.blockAllocator, new ListSchemasRequest(this.federatedIdentity, "testQueryId", "testCatalog"));
    }

    @Test(expected=SQLException.class)
    public void doListTablesSQLException() throws Exception {
        Mockito.when((Object)this.connection.getMetaData().getTables((String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.nullable(String.class), (String)Mockito.isNull(), (String[])ArgumentMatchers.any())).thenThrow(new Throwable[]{new SQLException()});
        this.jdbcMetadataHandler.doListTables(this.blockAllocator, new ListTablesRequest(this.federatedIdentity, "testQueryId", "testCatalog", "testSchema", null, -1));
    }

    private void setupMocksDoGetTableCaseInsensitive(TableName inputTableName, Object[][] resultSetRows, String expectedTableName) throws Exception {
        String[] schema = new String[]{"DATA_TYPE", "COLUMN_SIZE", "COLUMN_NAME", "DECIMAL_DIGITS", "NUM_PREC_RADIX"};
        Object[][] values = new Object[][]{{4, 12, "testCol1", 0, 0}};
        ResultSet resultSet = this.mockResultSet(schema, values, new AtomicInteger(-1));
        Mockito.when((Object)this.connection.getMetaData().getColumns("testCatalog", inputTableName.getSchemaName(), expectedTableName, null)).thenReturn((Object)resultSet);
    }
}

