/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc.manager;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockSpiller;
import com.amazonaws.athena.connector.lambda.data.FieldBuilder;
import com.amazonaws.athena.connector.lambda.data.S3BlockSpiller;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.data.SpillConfig;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.BigIntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.BitExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.DateDayExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.DateMilliExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.Extractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.Float4Extractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.Float8Extractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.IntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.SmallIntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.TinyIntExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.VarBinaryExtractor;
import com.amazonaws.athena.connector.lambda.data.writers.extractors.VarCharExtractor;
import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintEvaluator;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.spill.S3SpillLocation;
import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connectors.jdbc.TestBase;
import com.amazonaws.athena.connectors.jdbc.connection.DatabaseConnectionConfig;
import com.amazonaws.athena.connectors.jdbc.connection.JdbcConnectionFactory;
import com.amazonaws.athena.connectors.jdbc.connection.JdbcCredentialProvider;
import com.amazonaws.athena.connectors.jdbc.manager.JdbcRecordHandler;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class JdbcRecordHandlerTest
extends TestBase {
    private JdbcRecordHandler jdbcRecordHandler;
    private Connection connection;
    private JdbcConnectionFactory jdbcConnectionFactory;
    private AmazonS3 amazonS3;
    private AWSSecretsManager secretsManager;
    private AmazonAthena athena;
    private QueryStatusChecker queryStatusChecker;
    private FederatedIdentity federatedIdentity;
    private PreparedStatement preparedStatement;

    @Before
    public void setup() throws Exception {
        this.connection = (Connection)Mockito.mock(Connection.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.jdbcConnectionFactory = (JdbcConnectionFactory)Mockito.mock(JdbcConnectionFactory.class);
        Mockito.when((Object)this.jdbcConnectionFactory.getConnection((JdbcCredentialProvider)ArgumentMatchers.nullable(JdbcCredentialProvider.class))).thenReturn((Object)this.connection);
        this.amazonS3 = (AmazonS3)Mockito.mock(AmazonS3.class);
        this.secretsManager = (AWSSecretsManager)Mockito.mock(AWSSecretsManager.class);
        this.athena = (AmazonAthena)Mockito.mock(AmazonAthena.class);
        this.queryStatusChecker = (QueryStatusChecker)Mockito.mock(QueryStatusChecker.class);
        Mockito.when((Object)this.secretsManager.getSecretValue((GetSecretValueRequest)Mockito.eq((Object)new GetSecretValueRequest().withSecretId("testSecret")))).thenReturn((Object)new GetSecretValueResult().withSecretString("{\"username\": \"testUser\", \"password\": \"testPassword\"}"));
        this.preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)this.connection.prepareStatement("someSql")).thenReturn((Object)this.preparedStatement);
        DatabaseConnectionConfig databaseConnectionConfig = new DatabaseConnectionConfig("testCatalog", "fakedatabase", "fakedatabase://jdbc:fakedatabase://hostname/${testSecret}", "testSecret");
        this.jdbcRecordHandler = new JdbcRecordHandler(this.amazonS3, this.secretsManager, this.athena, databaseConnectionConfig, this.jdbcConnectionFactory, (Map)ImmutableMap.of()){

            public PreparedStatement buildSplitSql(Connection jdbcConnection, String catalogName, TableName tableName, Schema schema, Constraints constraints, Split split) throws SQLException {
                return jdbcConnection.prepareStatement("someSql");
            }
        };
        this.federatedIdentity = (FederatedIdentity)Mockito.mock(FederatedIdentity.class);
    }

    @Test
    public void readWithConstraint() throws Exception {
        ConstraintEvaluator constraintEvaluator = (ConstraintEvaluator)Mockito.mock(ConstraintEvaluator.class);
        Mockito.when((Object)constraintEvaluator.apply((String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.any())).thenReturn((Object)true);
        TableName inputTableName = new TableName("testSchema", "testTable");
        SchemaBuilder expectedSchemaBuilder = SchemaBuilder.newBuilder();
        expectedSchemaBuilder.addField(FieldBuilder.newBuilder((String)"testCol1", (ArrowType)Types.MinorType.INT.getType()).build());
        expectedSchemaBuilder.addField(FieldBuilder.newBuilder((String)"testCol2", (ArrowType)Types.MinorType.VARCHAR.getType()).build());
        expectedSchemaBuilder.addField(FieldBuilder.newBuilder((String)"testPartitionCol", (ArrowType)Types.MinorType.VARCHAR.getType()).build());
        Schema fieldSchema = expectedSchemaBuilder.build();
        BlockAllocatorImpl allocator = new BlockAllocatorImpl();
        S3SpillLocation s3SpillLocation = S3SpillLocation.newBuilder().withIsDirectory(true).build();
        Split.Builder splitBuilder = Split.newBuilder((SpillLocation)s3SpillLocation, null).add("testPartitionCol", String.valueOf("testPartitionValue"));
        Constraints constraints = (Constraints)Mockito.mock(Constraints.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        String[] schema = new String[]{"testCol1", "testCol2"};
        int[] columnTypes = new int[]{4, 12};
        Object[][] values = new Object[][]{{1, "testVal1"}, {2, "testVal2"}};
        AtomicInteger rowNumber = new AtomicInteger(-1);
        ResultSet resultSet = this.mockResultSet(schema, columnTypes, values, rowNumber);
        Mockito.when((Object)this.preparedStatement.executeQuery()).thenReturn((Object)resultSet);
        SpillConfig spillConfig = (SpillConfig)Mockito.mock(SpillConfig.class);
        Mockito.when((Object)spillConfig.getSpillLocation()).thenReturn((Object)s3SpillLocation);
        S3BlockSpiller s3Spiller = new S3BlockSpiller(this.amazonS3, spillConfig, (BlockAllocator)allocator, fieldSchema, constraintEvaluator, (Map)ImmutableMap.of());
        ReadRecordsRequest readRecordsRequest = new ReadRecordsRequest(this.federatedIdentity, "testCatalog", "testQueryId", inputTableName, fieldSchema, splitBuilder.build(), constraints, 1024L, 1024L);
        Mockito.when((Object)this.amazonS3.putObject((PutObjectRequest)ArgumentMatchers.any())).thenAnswer(invocation -> {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)((PutObjectRequest)invocation.getArguments()[0]).getInputStream();
            int n = byteArrayInputStream.available();
            byte[] bytes = new byte[n];
            byteArrayInputStream.read(bytes, 0, n);
            String data = new String(bytes, StandardCharsets.UTF_8);
            Assert.assertTrue((data.contains("testVal1") || data.contains("testVal2") || data.contains("testPartitionValue") ? 1 : 0) != 0);
            return new PutObjectResult();
        });
        this.jdbcRecordHandler.readWithConstraint((BlockSpiller)s3Spiller, readRecordsRequest, this.queryStatusChecker);
    }

    @Test
    public void makeExtractor() throws Exception {
        String[] schema = new String[]{"testCol1", "testCol2", "testCol10"};
        int[] columnTypes = new int[]{4, 12, 8};
        Object[][] values = new Object[][]{{1, "testVal1", "$1,000.50"}, {2, "testVal2", "$100.00"}};
        AtomicInteger rowNumber = new AtomicInteger(0);
        ResultSet resultSet = this.mockResultSet(schema, columnTypes, values, rowNumber);
        Mockito.when((Object)this.preparedStatement.executeQuery()).thenReturn((Object)resultSet);
        Map<String, String> partitionMap = Collections.singletonMap("testPartitionCol", "testPartitionValue");
        Extractor actualInt = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol1", (ArrowType)Types.MinorType.INT.getType()).build(), resultSet, partitionMap);
        Extractor actualVarchar = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol2", (ArrowType)Types.MinorType.VARCHAR.getType()).build(), resultSet, partitionMap);
        Extractor actualBit = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol3", (ArrowType)Types.MinorType.BIT.getType()).build(), resultSet, partitionMap);
        Extractor actualTinyInt = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol4", (ArrowType)Types.MinorType.TINYINT.getType()).build(), resultSet, partitionMap);
        Extractor actualSmallInt = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol5", (ArrowType)Types.MinorType.SMALLINT.getType()).build(), resultSet, partitionMap);
        Extractor actualVarbinary = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol6", (ArrowType)Types.MinorType.VARBINARY.getType()).build(), resultSet, partitionMap);
        Extractor actualBigInt = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol8", (ArrowType)Types.MinorType.BIGINT.getType()).build(), resultSet, partitionMap);
        Extractor actualFloat4 = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol9", (ArrowType)Types.MinorType.FLOAT4.getType()).build(), resultSet, partitionMap);
        Extractor actualFloat8 = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol10", (ArrowType)Types.MinorType.FLOAT8.getType()).build(), resultSet, partitionMap);
        Extractor actualDateDay = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol11", (ArrowType)Types.MinorType.DATEDAY.getType()).build(), resultSet, partitionMap);
        Extractor actualDateMilli = this.jdbcRecordHandler.makeExtractor(FieldBuilder.newBuilder((String)"testCol12", (ArrowType)Types.MinorType.DATEMILLI.getType()).build(), resultSet, partitionMap);
        Assert.assertTrue((boolean)(actualInt instanceof IntExtractor));
        Assert.assertTrue((boolean)(actualVarchar instanceof VarCharExtractor));
        Assert.assertTrue((boolean)(actualBit instanceof BitExtractor));
        Assert.assertTrue((boolean)(actualTinyInt instanceof TinyIntExtractor));
        Assert.assertTrue((boolean)(actualSmallInt instanceof SmallIntExtractor));
        Assert.assertTrue((boolean)(actualVarbinary instanceof VarBinaryExtractor));
        Assert.assertTrue((boolean)(actualBigInt instanceof BigIntExtractor));
        Assert.assertTrue((boolean)(actualFloat4 instanceof Float4Extractor));
        Assert.assertTrue((boolean)(actualFloat8 instanceof Float8Extractor));
        Assert.assertTrue((boolean)(actualDateDay instanceof DateDayExtractor));
        Assert.assertTrue((boolean)(actualDateMilli instanceof DateMilliExtractor));
        NullableFloat8Holder dollarValue = new NullableFloat8Holder();
        ((Float8Extractor)actualFloat8).extract(null, dollarValue);
        Assert.assertEquals((double)dollarValue.value, (double)1000.5, (double)0.0);
    }
}

