/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc.splits;

import com.amazonaws.athena.connectors.jdbc.splits.IntegerSplitter;
import com.amazonaws.athena.connectors.jdbc.splits.SplitInfo;
import com.amazonaws.athena.connectors.jdbc.splits.SplitRange;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IntegerSplitterTest {
    private SplitRange<Integer> inputRange;
    private int numSplits;
    private List<SplitRange<Integer>> expectedRanges;
    private List<String> expectedClauses;

    public IntegerSplitterTest(SplitRange<Integer> inputRange, int numSplits, List<SplitRange<Integer>> expectedRanges, List<String> expectedClauses) {
        this.inputRange = inputRange;
        this.numSplits = numSplits;
        this.expectedRanges = expectedRanges;
        this.expectedClauses = expectedClauses;
    }

    @Test
    public void splitTest() {
        SplitInfo splitInfo = new SplitInfo(this.inputRange, "testColumn", 4, this.numSplits);
        IntegerSplitter integerSplitter = new IntegerSplitter(splitInfo);
        ImmutableList splitRanges = ImmutableList.copyOf((Iterator)integerSplitter);
        Assert.assertEquals(this.expectedRanges, (Object)splitRanges);
        SplitInfo splitClauseInfo = new SplitInfo(this.inputRange, "testColumn", 4, this.numSplits);
        IntegerSplitter integerClauseSplitter = new IntegerSplitter(splitClauseInfo);
        ArrayList<String> splitClauses = new ArrayList<String>();
        while (integerClauseSplitter.hasNext()) {
            splitClauses.add(integerClauseSplitter.nextRangeClause());
        }
        Assert.assertEquals(this.expectedClauses, splitClauses);
    }

    @Parameterized.Parameters(name="{index}: Test with inputRange={0}, numSplits ={1}, expectedRanges is:{2}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{new SplitRange((Object)1, (Object)10), 2, Arrays.asList(new SplitRange((Object)1, (Object)5), new SplitRange((Object)6, (Object)10)), Arrays.asList("(testColumn >= 1 AND testColumn <= 5)", "(testColumn >= 6 AND testColumn <= 10)")}, {new SplitRange((Object)1, (Object)2), 10, Arrays.asList(new SplitRange((Object)1, (Object)1), new SplitRange((Object)2, (Object)2)), Arrays.asList("(testColumn >= 1 AND testColumn <= 1)", "(testColumn >= 2 AND testColumn <= 2)")}, {new SplitRange((Object)1, (Object)2), 2, Arrays.asList(new SplitRange((Object)1, (Object)1), new SplitRange((Object)2, (Object)2)), Arrays.asList("(testColumn >= 1 AND testColumn <= 1)", "(testColumn >= 2 AND testColumn <= 2)")}, {new SplitRange((Object)1, (Object)10), 1, Collections.singletonList(new SplitRange((Object)1, (Object)10)), Collections.singletonList("(testColumn >= 1 AND testColumn <= 10)")}, {new SplitRange((Object)1, (Object)10), 0, Collections.singletonList(new SplitRange((Object)1, (Object)10)), Collections.singletonList("(testColumn >= 1 AND testColumn <= 10)")}, {new SplitRange((Object)1, (Object)10), -10, Collections.singletonList(new SplitRange((Object)1, (Object)10)), Collections.singletonList("(testColumn >= 1 AND testColumn <= 10)")}, {new SplitRange((Object)1, (Object)10), 3, Arrays.asList(new SplitRange((Object)1, (Object)4), new SplitRange((Object)5, (Object)7), new SplitRange((Object)8, (Object)10)), Arrays.asList("(testColumn >= 1 AND testColumn <= 4)", "(testColumn >= 5 AND testColumn <= 7)", "(testColumn >= 8 AND testColumn <= 10)")}, {new SplitRange((Object)1, (Object)1), 2, Collections.singletonList(new SplitRange((Object)1, (Object)1)), Collections.singletonList("(testColumn >= 1 AND testColumn <= 1)")}};
        return Arrays.asList(data);
    }
}

