/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connectors.jdbc.splits;

import com.amazonaws.athena.connectors.jdbc.splits.IntegerSplitter;
import com.amazonaws.athena.connectors.jdbc.splits.Splitter;
import com.amazonaws.athena.connectors.jdbc.splits.SplitterFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class SplitterFactoryTest {
    private static final String TEST_COLUMN_NAME = "testColumn";
    private static final int MAX_SPLITS = 10;
    private ResultSet resultSet;
    private SplitterFactory splitterFactory;

    @Before
    public void setup() {
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.splitterFactory = new SplitterFactory();
    }

    @Test
    public void getIntegerSplitter() throws SQLException {
        Mockito.when((Object)this.resultSet.getMetaData().getColumnType(1)).thenReturn((Object)4);
        Optional splitter = this.splitterFactory.getSplitter(TEST_COLUMN_NAME, this.resultSet, 10);
        Assert.assertTrue((boolean)splitter.isPresent());
        Assert.assertEquals(IntegerSplitter.class, ((Splitter)splitter.get()).getClass());
    }

    @Test
    public void getStringSplitter() throws SQLException {
        Mockito.when((Object)this.resultSet.getMetaData().getColumnType(1)).thenReturn((Object)12);
        Assert.assertFalse((boolean)this.splitterFactory.getSplitter(TEST_COLUMN_NAME, this.resultSet, 10).isPresent());
    }

    @Test
    public void getFloatSplitter() throws SQLException {
        Mockito.when((Object)this.resultSet.getMetaData().getColumnType(1)).thenReturn((Object)6);
        Assert.assertFalse((boolean)this.splitterFactory.getSplitter(TEST_COLUMN_NAME, this.resultSet, 10).isPresent());
    }

    @Test
    public void getDoubleSplitter() throws SQLException {
        Mockito.when((Object)this.resultSet.getMetaData().getColumnType(1)).thenReturn((Object)8);
        Assert.assertFalse((boolean)this.splitterFactory.getSplitter(TEST_COLUMN_NAME, this.resultSet, 10).isPresent());
    }

    @Test
    public void getDateSplitter() throws SQLException {
        Mockito.when((Object)this.resultSet.getMetaData().getColumnType(1)).thenReturn((Object)91);
        Assert.assertFalse((boolean)this.splitterFactory.getSplitter(TEST_COLUMN_NAME, this.resultSet, 10).isPresent());
    }

    @Test
    public void getDecimalSplitter() throws SQLException {
        Mockito.when((Object)this.resultSet.getMetaData().getColumnType(1)).thenReturn((Object)3);
        Assert.assertFalse((boolean)this.splitterFactory.getSplitter(TEST_COLUMN_NAME, this.resultSet, 10).isPresent());
    }
}

