/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.EmptyArrays;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ByteBufStreamTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAll() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)0, (int)65536);
        try {
            new ByteBufOutputStream(null);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            Assertions.assertSame((Object)buf, (Object)out.buffer());
            out.writeBoolean(true);
            out.writeBoolean(false);
            out.writeByte(42);
            out.writeByte(224);
            out.writeBytes("Hello, World!");
            out.writeChars("Hello, World");
            out.writeChar(33);
            out.writeDouble(42.0);
            out.writeFloat(42.0f);
            out.writeInt(42);
            out.writeLong(42L);
            out.writeShort(42);
            out.writeShort(49152);
            out.writeUTF("Hello, World!");
            out.writeBytes("The first line\r\r\n");
            out.write(EmptyArrays.EMPTY_BYTES);
            out.write(new byte[]{1, 2, 3, 4});
            out.write(new byte[]{1, 3, 3, 4}, 0, 0);
        }
        finally {
            out.close();
        }
        try {
            new ByteBufInputStream(null, true);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ByteBufInputStream(null, 0, true);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ByteBufInputStream(buf.retainedSlice(), -1, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ByteBufInputStream(buf.retainedSlice(), buf.capacity() + 1, true);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        ByteBufInputStream in = new ByteBufInputStream(buf, true);
        try {
            Assertions.assertTrue((boolean)in.markSupported());
            in.mark(Integer.MAX_VALUE);
            Assertions.assertEquals((long)buf.writerIndex(), (long)in.skip(Long.MAX_VALUE));
            Assertions.assertFalse((boolean)buf.isReadable());
            in.reset();
            Assertions.assertEquals((int)0, (int)buf.readerIndex());
            Assertions.assertEquals((long)4L, (long)in.skip(4L));
            Assertions.assertEquals((int)4, (int)buf.readerIndex());
            in.reset();
            Assertions.assertTrue((boolean)in.readBoolean());
            Assertions.assertFalse((boolean)in.readBoolean());
            Assertions.assertEquals((int)42, (int)in.readByte());
            Assertions.assertEquals((int)224, (int)in.readUnsignedByte());
            byte[] tmp = new byte[13];
            in.readFully(tmp);
            Assertions.assertEquals((Object)"Hello, World!", (Object)new String(tmp, "ISO-8859-1"));
            Assertions.assertEquals((char)'H', (char)in.readChar());
            Assertions.assertEquals((char)'e', (char)in.readChar());
            Assertions.assertEquals((char)'l', (char)in.readChar());
            Assertions.assertEquals((char)'l', (char)in.readChar());
            Assertions.assertEquals((char)'o', (char)in.readChar());
            Assertions.assertEquals((char)',', (char)in.readChar());
            Assertions.assertEquals((char)' ', (char)in.readChar());
            Assertions.assertEquals((char)'W', (char)in.readChar());
            Assertions.assertEquals((char)'o', (char)in.readChar());
            Assertions.assertEquals((char)'r', (char)in.readChar());
            Assertions.assertEquals((char)'l', (char)in.readChar());
            Assertions.assertEquals((char)'d', (char)in.readChar());
            Assertions.assertEquals((char)'!', (char)in.readChar());
            Assertions.assertEquals((double)42.0, (double)in.readDouble(), (double)0.0);
            Assertions.assertEquals((double)42.0, (double)in.readFloat(), (double)0.0);
            Assertions.assertEquals((int)42, (int)in.readInt());
            Assertions.assertEquals((long)42L, (long)in.readLong());
            Assertions.assertEquals((int)42, (int)in.readShort());
            Assertions.assertEquals((int)49152, (int)in.readUnsignedShort());
            Assertions.assertEquals((Object)"Hello, World!", (Object)in.readUTF());
            Assertions.assertEquals((Object)"The first line", (Object)in.readLine());
            Assertions.assertEquals((Object)"", (Object)in.readLine());
            Assertions.assertEquals((int)4, (int)in.read(tmp));
            Assertions.assertEquals((int)1, (int)tmp[0]);
            Assertions.assertEquals((int)2, (int)tmp[1]);
            Assertions.assertEquals((int)3, (int)tmp[2]);
            Assertions.assertEquals((int)4, (int)tmp[3]);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read(tmp));
            try {
                in.readByte();
                Assertions.fail();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            try {
                in.readFully(tmp, 0, -1);
                Assertions.fail();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                in.readFully(tmp);
                Assertions.fail();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        finally {
            buf.retain();
            in.close();
        }
        Assertions.assertEquals((int)buf.readerIndex(), (int)in.readBytes());
        buf.release();
    }

    @Test
    public void testReadLine() throws Exception {
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuf buf = Unpooled.buffer();
        ByteBufInputStream in = new ByteBufInputStream(buf, true);
        String s = in.readLine();
        Assertions.assertNull((Object)s);
        in.close();
        ByteBuf buf2 = Unpooled.buffer();
        int charCount = 7;
        byte[] abc = "\na\n\nb\r\nc\nd\ne".getBytes(utf8);
        buf2.writeBytes(abc);
        ByteBufInputStream in2 = new ByteBufInputStream(buf2, true);
        in2.mark(charCount);
        Assertions.assertEquals((Object)"", (Object)in2.readLine());
        Assertions.assertEquals((Object)"a", (Object)in2.readLine());
        Assertions.assertEquals((Object)"", (Object)in2.readLine());
        Assertions.assertEquals((Object)"b", (Object)in2.readLine());
        Assertions.assertEquals((Object)"c", (Object)in2.readLine());
        Assertions.assertEquals((Object)"d", (Object)in2.readLine());
        Assertions.assertEquals((Object)"e", (Object)in2.readLine());
        Assertions.assertNull((Object)in.readLine());
        in2.reset();
        int count = 0;
        while (in2.readLine() != null) {
            if (++count <= charCount) continue;
            Assertions.fail((String)"readLine() should have returned null");
        }
        Assertions.assertEquals((int)charCount, (int)count);
        in2.close();
    }

    @Test
    public void testRead() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6});
        ByteBufInputStream in = new ByteBufInputStream(buf, 3);
        Assertions.assertEquals((int)1, (int)in.read());
        Assertions.assertEquals((int)2, (int)in.read());
        Assertions.assertEquals((int)3, (int)in.read());
        Assertions.assertEquals((int)-1, (int)in.read());
        Assertions.assertEquals((int)-1, (int)in.read());
        Assertions.assertEquals((int)-1, (int)in.read());
        buf.release();
        in.close();
        ByteBuf buf2 = Unpooled.buffer((int)16);
        buf2.writeBytes(new byte[]{1, 2, 3, 4, 5, 6});
        ByteBufInputStream in2 = new ByteBufInputStream(buf2, 4);
        Assertions.assertEquals((int)1, (int)in2.read());
        Assertions.assertEquals((int)2, (int)in2.read());
        Assertions.assertEquals((int)3, (int)in2.read());
        Assertions.assertEquals((int)4, (int)in2.read());
        Assertions.assertNotEquals((int)5, (int)in2.read());
        Assertions.assertEquals((int)-1, (int)in2.read());
        buf2.release();
        in2.close();
    }

    @Test
    public void testReadLineLengthRespected1() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6});
        ByteBufInputStream in = new ByteBufInputStream(buf, 0);
        Assertions.assertNull((Object)in.readLine());
        buf.release();
        in.close();
    }

    @Test
    public void testReadLineLengthRespected2() throws Exception {
        ByteBuf buf2 = Unpooled.buffer((int)16);
        buf2.writeBytes(new byte[]{65, 66, 10, 67, 69, 70});
        ByteBufInputStream in2 = new ByteBufInputStream(buf2, 4);
        Assertions.assertEquals((Object)"AB", (Object)in2.readLine());
        Assertions.assertEquals((Object)"C", (Object)in2.readLine());
        Assertions.assertNull((Object)in2.readLine());
        buf2.release();
        in2.close();
    }

    @Test
    public void testReadByteLengthRespected() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6});
        final ByteBufInputStream in = new ByteBufInputStream(buf, 0);
        try {
            Assertions.assertThrows(EOFException.class, (Executable)new Executable(){

                public void execute() throws IOException {
                    in.readBoolean();
                }
            });
        }
        finally {
            buf.release();
            in.close();
        }
    }
}

