/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ReadOnlyByteBufferBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ReadOnlyDirectByteBufferBufTest {
    protected ByteBuf buffer(ByteBuffer buffer) {
        return new ReadOnlyByteBufferBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, buffer);
    }

    protected ByteBuffer allocate(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.buffer(this.allocate(4).asReadOnlyBuffer());
        Assertions.assertTrue((boolean)buf.isContiguous());
        buf.release();
    }

    @Test
    public void testConstructWithWritable() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyDirectByteBufferBufTest.this.buffer(ReadOnlyDirectByteBufferBufTest.this.allocate(1));
            }
        });
    }

    @Test
    public void shouldIndicateNotWritable() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            Assertions.assertFalse((boolean)buf.isWritable());
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void shouldIndicateNotWritableAnyNumber() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            Assertions.assertFalse((boolean)buf.isWritable(1));
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void ensureWritableIntStatusShouldFailButNotThrow() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            int result = buf.ensureWritable(1, false);
            Assertions.assertEquals((int)1, (int)result);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void ensureWritableForceIntStatusShouldFailButNotThrow() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            int result = buf.ensureWritable(1, true);
            Assertions.assertEquals((int)1, (int)result);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void ensureWritableShouldThrow() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.ensureWritable(1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetByte() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setByte(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetInt() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setInt(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetShort() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setShort(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetMedium() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setMedium(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetLong() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setLong(0, 1L);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetBytesViaArray() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setBytes(0, "test".getBytes());
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetBytesViaBuffer() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        final ByteBuf copy = Unpooled.copyInt((int)1);
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setBytes(0, copy);
                }
            });
        }
        finally {
            buf.release();
            copy.release();
        }
    }

    @Test
    public void testSetBytesViaStream() throws IOException {
        final ByteBuf buf = this.buffer(ByteBuffer.allocateDirect(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    buf.setBytes(0, (InputStream)new ByteArrayInputStream("test".getBytes()), 2);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testGetReadByte() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(2).put(new byte[]{1, 2}).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((int)1, (int)buf.getByte(0));
        Assertions.assertEquals((int)2, (int)buf.getByte(1));
        Assertions.assertEquals((int)1, (int)buf.readByte());
        Assertions.assertEquals((int)2, (int)buf.readByte());
        Assertions.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    @Test
    public void testGetReadInt() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(8).putInt(1).putInt(2).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((int)1, (int)buf.getInt(0));
        Assertions.assertEquals((int)2, (int)buf.getInt(4));
        Assertions.assertEquals((int)1, (int)buf.readInt());
        Assertions.assertEquals((int)2, (int)buf.readInt());
        Assertions.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    @Test
    public void testGetReadShort() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(8).putShort((short)1).putShort((short)2).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((int)1, (int)buf.getShort(0));
        Assertions.assertEquals((int)2, (int)buf.getShort(2));
        Assertions.assertEquals((int)1, (int)buf.readShort());
        Assertions.assertEquals((int)2, (int)buf.readShort());
        Assertions.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    @Test
    public void testGetReadLong() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).putLong(2L).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((long)1L, (long)buf.getLong(0));
        Assertions.assertEquals((long)2L, (long)buf.getLong(8));
        Assertions.assertEquals((long)1L, (long)buf.readLong());
        Assertions.assertEquals((long)2L, (long)buf.readLong());
        Assertions.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBytesByteBuffer() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        final ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        final ByteBuf buffer = this.buffer(((ByteBuffer)this.allocate(bytes.length).put(bytes).flip()).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() {
                    buffer.getBytes(buffer.readerIndex(), nioBuffer);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCopy() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).putLong(2L).flip()).asReadOnlyBuffer());
        ByteBuf copy = buf.copy();
        Assertions.assertEquals((Object)buf, (Object)copy);
        buf.release();
        copy.release();
    }

    @Test
    public void testCopyWithOffset() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).putLong(2L).flip()).asReadOnlyBuffer());
        ByteBuf copy = buf.copy(1, 9);
        Assertions.assertEquals((Object)buf.slice(1, 9), (Object)copy);
        buf.release();
        copy.release();
    }

    @Test
    public void testWrapBufferWithNonZeroPosition() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).flip().position(1)).asReadOnlyBuffer());
        ByteBuf slice = buf.slice();
        Assertions.assertEquals((Object)buf, (Object)slice);
        buf.release();
    }

    @Test
    public void testWrapBufferRoundTrip() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putInt(1).putInt(2).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((int)1, (int)buf.readInt());
        ByteBuffer nioBuffer = buf.nioBuffer();
        Assertions.assertEquals((int)2, (int)nioBuffer.getInt());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrapMemoryMapped() throws Exception {
        File file = PlatformDependent.createTempFile((String)"netty-test", (String)"tmp", null);
        FileChannel output = null;
        AbstractInterruptibleChannel input = null;
        ByteBuf b1 = null;
        ByteBuf b2 = null;
        try {
            output = new RandomAccessFile(file, "rw").getChannel();
            byte[] bytes = new byte[1024];
            PlatformDependent.threadLocalRandom().nextBytes(bytes);
            output.write(ByteBuffer.wrap(bytes));
            input = new RandomAccessFile(file, "r").getChannel();
            MappedByteBuffer m = ((FileChannel)input).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)input).size());
            b1 = this.buffer(m);
            ByteBuffer dup = ((ByteBuffer)m).duplicate();
            dup.position(2);
            dup.limit(4);
            b2 = this.buffer(dup);
            Assertions.assertEquals((Object)b2, (Object)b1.slice(2, 2));
        }
        finally {
            if (b1 != null) {
                b1.release();
            }
            if (b2 != null) {
                b2.release();
            }
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            file.delete();
        }
    }

    @Test
    public void testMemoryAddress() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertFalse((boolean)buf.hasMemoryAddress());
            try {
                buf.memoryAddress();
                Assertions.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            buf.release();
        }
    }
}

