/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.SlicedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class SlicedByteBufTest
extends AbstractByteBufTest {
    @Override
    protected final ByteBuf newBuffer(int length, int maxCapacity) {
        Assumptions.assumeTrue((maxCapacity == Integer.MAX_VALUE ? 1 : 0) != 0);
        int offset = length == 0 ? 0 : PlatformDependent.threadLocalRandom().nextInt(length);
        ByteBuf buffer = Unpooled.buffer((int)(length * 2));
        ByteBuf slice = this.newSlice(buffer, offset, length);
        Assertions.assertEquals((int)0, (int)slice.readerIndex());
        Assertions.assertEquals((int)length, (int)slice.writerIndex());
        return slice;
    }

    protected ByteBuf newSlice(ByteBuf buffer, int offset, int length) {
        return buffer.slice(offset, length);
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assertions.assertEquals((Object)buf.unwrap().isContiguous(), (Object)buf.isContiguous());
        buf.release();
    }

    @Test
    public void shouldNotAllowNullInConstructor() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new SlicedByteBuf(null, 0, 0);
            }
        });
    }

    @Override
    @Test
    public void testInternalNioBuffer() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                SlicedByteBufTest.super.testInternalNioBuffer();
            }
        });
    }

    @Override
    @Test
    public void testDuplicateReadGatheringByteChannelMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                SlicedByteBufTest.super.testDuplicateReadGatheringByteChannelMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testSliceReadGatheringByteChannelMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                SlicedByteBufTest.super.testSliceReadGatheringByteChannelMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testDuplicateReadOutputStreamMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                SlicedByteBufTest.super.testDuplicateReadOutputStreamMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testSliceReadOutputStreamMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                SlicedByteBufTest.super.testSliceReadOutputStreamMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testDuplicateBytesInArrayMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                SlicedByteBufTest.super.testDuplicateBytesInArrayMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testSliceBytesInArrayMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                SlicedByteBufTest.super.testSliceBytesInArrayMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testNioBufferExposeOnlyRegion() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                SlicedByteBufTest.super.testNioBufferExposeOnlyRegion();
            }
        });
    }

    @Override
    @Test
    public void testGetReadOnlyDirectDst() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                SlicedByteBufTest.super.testGetReadOnlyDirectDst();
            }
        });
    }

    @Override
    @Test
    public void testGetReadOnlyHeapDst() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                SlicedByteBufTest.super.testGetReadOnlyHeapDst();
            }
        });
    }

    @Override
    @Test
    public void testLittleEndianWithExpand() {
    }

    @Override
    @Test
    public void testReadBytes() {
    }

    @Override
    @Test
    public void testForEachByteDesc2() {
    }

    @Override
    @Test
    public void testForEachByte2() {
    }

    @Override
    @Disabled(value="Sliced ByteBuf objects don't allow the capacity to change. So this test would fail and shouldn't be run")
    public void testDuplicateCapacityChange() {
    }

    @Override
    @Disabled(value="Sliced ByteBuf objects don't allow the capacity to change. So this test would fail and shouldn't be run")
    public void testRetainedDuplicateCapacityChange() {
    }

    @Test
    public void testReaderIndexAndMarks() {
        ByteBuf wrapped = Unpooled.buffer((int)16);
        try {
            wrapped.writerIndex(14);
            wrapped.readerIndex(2);
            wrapped.markWriterIndex();
            wrapped.markReaderIndex();
            ByteBuf slice = wrapped.slice(4, 4);
            Assertions.assertEquals((int)0, (int)slice.readerIndex());
            Assertions.assertEquals((int)4, (int)slice.writerIndex());
            slice.readerIndex(slice.readerIndex() + 1);
            slice.resetReaderIndex();
            Assertions.assertEquals((int)0, (int)slice.readerIndex());
            slice.writerIndex(slice.writerIndex() - 1);
            slice.resetWriterIndex();
            Assertions.assertEquals((int)0, (int)slice.writerIndex());
        }
        finally {
            wrapped.release();
        }
    }

    @Test
    public void sliceEmptyNotLeak() {
        ByteBuf buffer = Unpooled.buffer((int)8).retain();
        Assertions.assertEquals((int)2, (int)buffer.refCnt());
        ByteBuf slice1 = buffer.slice();
        Assertions.assertEquals((int)2, (int)slice1.refCnt());
        ByteBuf slice2 = slice1.slice();
        Assertions.assertEquals((int)2, (int)slice2.refCnt());
        Assertions.assertFalse((boolean)slice2.release());
        Assertions.assertEquals((int)1, (int)buffer.refCnt());
        Assertions.assertEquals((int)1, (int)slice1.refCnt());
        Assertions.assertEquals((int)1, (int)slice2.refCnt());
        Assertions.assertTrue((boolean)slice2.release());
        Assertions.assertEquals((int)0, (int)buffer.refCnt());
        Assertions.assertEquals((int)0, (int)slice1.refCnt());
        Assertions.assertEquals((int)0, (int)slice2.refCnt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testGetBytesByteBuffer() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        final ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        final ByteBuf wrappedBuffer = Unpooled.wrappedBuffer((byte[])bytes).slice(0, bytes.length - 1);
        try {
            Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() {
                    wrappedBuffer.getBytes(wrappedBuffer.readerIndex(), nioBuffer);
                }
            });
        }
        finally {
            wrappedBuffer.release();
        }
    }

    @Override
    @Test
    public void testWriteUsAsciiCharSequenceExpand() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                SlicedByteBufTest.super.testWriteUsAsciiCharSequenceExpand();
            }
        });
    }

    @Override
    @Test
    public void testWriteUtf8CharSequenceExpand() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                SlicedByteBufTest.super.testWriteUtf8CharSequenceExpand();
            }
        });
    }

    @Override
    @Test
    public void testWriteIso88591CharSequenceExpand() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                SlicedByteBufTest.super.testWriteIso88591CharSequenceExpand();
            }
        });
    }

    @Override
    @Test
    public void testWriteUtf16CharSequenceExpand() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                SlicedByteBufTest.super.testWriteUtf16CharSequenceExpand();
            }
        });
    }

    @Test
    public void ensureWritableWithEnoughSpaceShouldNotThrow() {
        ByteBuf slice = this.newBuffer(10);
        ByteBuf unwrapped = slice.unwrap();
        unwrapped.writerIndex(unwrapped.writerIndex() + 5);
        slice.writerIndex(slice.readerIndex());
        int originalWriterIndex = slice.writerIndex();
        int originalReadableBytes = slice.readableBytes();
        slice.ensureWritable(originalWriterIndex - slice.writerIndex());
        Assertions.assertEquals((int)originalWriterIndex, (int)slice.writerIndex());
        Assertions.assertEquals((int)originalReadableBytes, (int)slice.readableBytes());
        slice.release();
    }

    @Test
    public void ensureWritableWithNotEnoughSpaceShouldThrow() {
        final ByteBuf slice = this.newBuffer(10);
        ByteBuf unwrapped = slice.unwrap();
        unwrapped.writerIndex(unwrapped.writerIndex() + 5);
        try {
            Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() {
                    slice.ensureWritable(1);
                }
            });
        }
        finally {
            slice.release();
        }
    }
}

