/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnreleaseableByteBufTest {
    @Test
    public void testCantRelease() {
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copyInt((int)1));
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        Assertions.assertFalse((boolean)buf.release());
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        Assertions.assertFalse((boolean)buf.release());
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        buf.retain(5);
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        buf.retain();
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        Assertions.assertTrue((boolean)buf.unwrap().release());
        Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    @Test
    public void testWrappedReadOnly() {
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)1).asReadOnly());
        Assertions.assertSame((Object)buf, (Object)buf.asReadOnly());
        Assertions.assertTrue((boolean)buf.unwrap().release());
    }
}

