/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class GlobalEventExecutorTest {
    private static final GlobalEventExecutor e = GlobalEventExecutor.INSTANCE;

    @BeforeEach
    public void setUp() throws Exception {
        while (GlobalEventExecutorTest.e.thread != null && GlobalEventExecutorTest.e.thread.isAlive()) {
            Thread.sleep(50L);
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testAutomaticStartStop() throws Exception {
        TestRunnable task = new TestRunnable(500L);
        e.execute((Runnable)task);
        Thread thread = GlobalEventExecutorTest.e.thread;
        MatcherAssert.assertThat((Object)thread, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)thread.isAlive(), (Matcher)CoreMatchers.is((Object)true));
        thread.join();
        MatcherAssert.assertThat((Object)task.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        task.ran.set(false);
        e.execute((Runnable)task);
        MatcherAssert.assertThat((Object)GlobalEventExecutorTest.e.thread, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)thread)));
        thread = GlobalEventExecutorTest.e.thread;
        thread.join();
        MatcherAssert.assertThat((Object)task.ran.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testScheduledTasks() throws Exception {
        TestRunnable task = new TestRunnable(0L);
        ScheduledFuture f = e.schedule((Runnable)task, 1500L, TimeUnit.MILLISECONDS);
        f.sync();
        MatcherAssert.assertThat((Object)task.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        Thread thread = GlobalEventExecutorTest.e.thread;
        MatcherAssert.assertThat((Object)thread, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)thread.isAlive(), (Matcher)CoreMatchers.is((Object)true));
        thread.join();
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testThreadGroup() throws InterruptedException {
        ThreadGroup group = new ThreadGroup("group");
        final AtomicReference capturedGroup = new AtomicReference();
        Thread thread = new Thread(group, new Runnable(){

            @Override
            public void run() {
                Thread t = e.threadFactory.newThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                capturedGroup.set(t.getThreadGroup());
            }
        });
        thread.start();
        thread.join();
        Assertions.assertEquals((Object)group, capturedGroup.get());
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testTakeTask() throws Exception {
        TestRunnable beforeTask = new TestRunnable(0L);
        e.execute((Runnable)beforeTask);
        TestRunnable scheduledTask = new TestRunnable(0L);
        ScheduledFuture f = e.schedule((Runnable)scheduledTask, 1500L, TimeUnit.MILLISECONDS);
        TestRunnable afterTask = new TestRunnable(0L);
        e.execute((Runnable)afterTask);
        f.sync();
        MatcherAssert.assertThat((Object)beforeTask.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)scheduledTask.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)afterTask.ran.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testTakeTaskAlwaysHasTask() throws Exception {
        TestRunnable t = new TestRunnable(0L);
        final ScheduledFuture f = e.schedule((Runnable)t, 1500L, TimeUnit.MILLISECONDS);
        e.execute(new Runnable(){

            @Override
            public void run() {
                if (!f.isDone()) {
                    e.execute((Runnable)this);
                }
            }
        });
        f.sync();
        MatcherAssert.assertThat((Object)t.ran.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    private static final class TestRunnable
    implements Runnable {
        final AtomicBoolean ran = new AtomicBoolean();
        final long delay;

        TestRunnable(long delay) {
            this.delay = delay;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
                this.ran.set(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

