/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.MacAddressUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class MacAddressUtilTest {
    @Test
    public void testCompareAddresses() {
        Assertions.assertEquals((int)0, (int)MacAddressUtil.compareAddresses((byte[])EmptyArrays.EMPTY_BYTES, (byte[])new byte[]{82, 84, 0, -7, 50, -67}));
        Assertions.assertEquals((int)-1, (int)MacAddressUtil.compareAddresses((byte[])EmptyArrays.EMPTY_BYTES, (byte[])new byte[]{80, 84, 0, -7, 50, -67}));
        Assertions.assertEquals((int)-1, (int)MacAddressUtil.compareAddresses((byte[])new byte[]{82, 84, 0, -7, 50, -67}, (byte[])new byte[]{80, 84, 0, -7, 50, -67}));
        Assertions.assertEquals((int)1, (int)MacAddressUtil.compareAddresses((byte[])new byte[]{82, 84, 0, -7, 50, -67}, (byte[])EmptyArrays.EMPTY_BYTES));
        Assertions.assertEquals((int)1, (int)MacAddressUtil.compareAddresses((byte[])new byte[]{80, 84, 0, -7, 50, -67}, (byte[])new byte[]{82, 84, 0, -7, 50, -67}));
        Assertions.assertEquals((int)0, (int)MacAddressUtil.compareAddresses((byte[])new byte[]{80, 84, 0, -7, 50, -67}, (byte[])new byte[]{80, 85, 1, -6, 51, -66}));
    }

    @Test
    public void testParseMacEUI48() {
        Assertions.assertArrayEquals((byte[])new byte[]{0, -86, 17, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00-AA-11-BB-22-CC"));
        Assertions.assertArrayEquals((byte[])new byte[]{0, -86, 17, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00:AA:11:BB:22:CC"));
    }

    @Test
    public void testParseMacMAC48ToEUI64() {
        Assertions.assertArrayEquals((byte[])new byte[]{0, -86, 17, -1, -1, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00-AA-11-FF-FF-BB-22-CC"));
        Assertions.assertArrayEquals((byte[])new byte[]{0, -86, 17, -1, -1, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00:AA:11:FF:FF:BB:22:CC"));
    }

    @Test
    public void testParseMacEUI48ToEUI64() {
        Assertions.assertArrayEquals((byte[])new byte[]{0, -86, 17, -1, -2, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00-AA-11-FF-FE-BB-22-CC"));
        Assertions.assertArrayEquals((byte[])new byte[]{0, -86, 17, -1, -2, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00:AA:11:FF:FE:BB:22:CC"));
    }

    @Test
    public void testParseMacInvalid7HexGroupsA() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00-AA-11-BB-22-CC-FF");
            }
        });
    }

    @Test
    public void testParseMacInvalid7HexGroupsB() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00:AA:11:BB:22:CC:FF");
            }
        });
    }

    @Test
    public void testParseMacInvalidEUI48MixedSeparatorA() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00-AA:11-BB-22-CC");
            }
        });
    }

    @Test
    public void testParseMacInvalidEUI48MixedSeparatorB() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00:AA-11:BB:22:CC");
            }
        });
    }

    @Test
    public void testParseMacInvalidEUI64MixedSeparatorA() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00-AA-11-FF-FE-BB-22:CC");
            }
        });
    }

    @Test
    public void testParseMacInvalidEUI64MixedSeparatorB() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00:AA:11:FF:FE:BB:22-CC");
            }
        });
    }

    @Test
    public void testParseMacInvalidEUI48TrailingSeparatorA() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00-AA-11-BB-22-CC-");
            }
        });
    }

    @Test
    public void testParseMacInvalidEUI48TrailingSeparatorB() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00:AA:11:BB:22:CC:");
            }
        });
    }

    @Test
    public void testParseMacInvalidEUI64TrailingSeparatorA() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00-AA-11-FF-FE-BB-22-CC-");
            }
        });
    }

    @Test
    public void testParseMacInvalidEUI64TrailingSeparatorB() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                MacAddressUtil.parseMAC((String)"00:AA:11:FF:FE:BB:22:CC:");
            }
        });
    }
}

