/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.function.Executable;

class NativeLibraryLoaderTest {
    private static final String OS_ARCH = System.getProperty("os.arch");

    NativeLibraryLoaderTest() {
    }

    private boolean is_x86_64() {
        return "x86_64".equals(OS_ARCH) || "amd64".equals(OS_ARCH);
    }

    @Test
    void testFileNotFound() {
        block2: {
            try {
                NativeLibraryLoader.load((String)UUID.randomUUID().toString(), (ClassLoader)NativeLibraryLoaderTest.class.getClassLoader());
                Assertions.fail();
            }
            catch (UnsatisfiedLinkError error) {
                Assertions.assertTrue((boolean)(error.getCause() instanceof FileNotFoundException));
                if (PlatformDependent.javaVersion() < 7) break block2;
                NativeLibraryLoaderTest.verifySuppressedException(error, UnsatisfiedLinkError.class);
            }
        }
    }

    @Test
    void testFileNotFoundWithNullClassLoader() {
        block2: {
            try {
                NativeLibraryLoader.load((String)UUID.randomUUID().toString(), null);
                Assertions.fail();
            }
            catch (UnsatisfiedLinkError error) {
                Assertions.assertTrue((boolean)(error.getCause() instanceof FileNotFoundException));
                if (PlatformDependent.javaVersion() < 7) break block2;
                NativeLibraryLoaderTest.verifySuppressedException(error, ClassNotFoundException.class);
            }
        }
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    @EnabledIf(value="is_x86_64")
    void testMultipleResourcesWithSameContentInTheClassLoader() throws MalformedURLException {
        URL url1 = new File("src/test/data/NativeLibraryLoader/1").toURI().toURL();
        URL url2 = new File("src/test/data/NativeLibraryLoader/2").toURI().toURL();
        URLClassLoader loader = new URLClassLoader(new URL[]{url1, url2});
        String resourceName = "test3";
        NativeLibraryLoader.load((String)"test3", (ClassLoader)loader);
        Assertions.assertTrue((boolean)true);
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    @EnabledIf(value="is_x86_64")
    void testMultipleResourcesInTheClassLoader() throws MalformedURLException {
        URL url1 = new File("src/test/data/NativeLibraryLoader/1").toURI().toURL();
        URL url2 = new File("src/test/data/NativeLibraryLoader/2").toURI().toURL();
        final URLClassLoader loader = new URLClassLoader(new URL[]{url1, url2});
        String resourceName = "test1";
        Exception ise = (Exception)Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                NativeLibraryLoader.load((String)"test1", (ClassLoader)loader);
            }
        });
        Assertions.assertTrue((boolean)ise.getMessage().contains("Multiple resources found for 'META-INF/native/libtest1.so'"));
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    @EnabledIf(value="is_x86_64")
    void testSingleResourceInTheClassLoader() throws MalformedURLException {
        URL url1 = new File("src/test/data/NativeLibraryLoader/1").toURI().toURL();
        URL url2 = new File("src/test/data/NativeLibraryLoader/2").toURI().toURL();
        URLClassLoader loader = new URLClassLoader(new URL[]{url1, url2});
        String resourceName = "test2";
        NativeLibraryLoader.load((String)resourceName, (ClassLoader)loader);
        Assertions.assertTrue((boolean)true);
    }

    @SuppressJava6Requirement(reason="uses Java 7+ Throwable#getSuppressed but is guarded by version checks")
    private static void verifySuppressedException(UnsatisfiedLinkError error, Class<?> expectedSuppressedExceptionClass) {
        try {
            Throwable[] suppressed = error.getCause().getSuppressed();
            Assertions.assertTrue((suppressed.length == 1 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)(suppressed[0] instanceof UnsatisfiedLinkError));
            suppressed = suppressed[0].getSuppressed();
            Assertions.assertTrue((suppressed.length == 1 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)expectedSuppressedExceptionClass.isInstance(suppressed[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

