/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectUtilTest {
    private static final Object NULL_OBJECT = null;
    private static final Object NON_NULL_OBJECT = "Object is not null";
    private static final String NON_NULL_EMPTY_STRING = "";
    private static final String NON_NULL_WHITESPACE_STRING = "  ";
    private static final Object[] NON_NULL_EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Object[] NON_NULL_FILLED_OBJECT_ARRAY = new Object[]{NON_NULL_OBJECT};
    private static final CharSequence NULL_CHARSEQUENCE = (CharSequence)NULL_OBJECT;
    private static final CharSequence NON_NULL_CHARSEQUENCE = (CharSequence)NON_NULL_OBJECT;
    private static final CharSequence NON_NULL_EMPTY_CHARSEQUENCE = "";
    private static final byte[] NON_NULL_EMPTY_BYTE_ARRAY = new byte[0];
    private static final byte[] NON_NULL_FILLED_BYTE_ARRAY = new byte[]{10};
    private static final char[] NON_NULL_EMPTY_CHAR_ARRAY = new char[0];
    private static final char[] NON_NULL_FILLED_CHAR_ARRAY = new char[]{'A'};
    private static final String NULL_NAME = "IS_NULL";
    private static final String NON_NULL_NAME = "NOT_NULL";
    private static final String NON_NULL_EMPTY_NAME = "NOT_NULL_BUT_EMPTY";
    private static final String TEST_RESULT_NULLEX_OK = "Expected a NPE/IAE";
    private static final String TEST_RESULT_NULLEX_NOK = "Expected no exception";
    private static final String TEST_RESULT_EXTYPE_NOK = "Expected type not found";
    private static final int ZERO_INT = 0;
    private static final long ZERO_LONG = 0L;
    private static final double ZERO_DOUBLE = 0.0;
    private static final float ZERO_FLOAT = 0.0f;
    private static final int POS_ONE_INT = 1;
    private static final long POS_ONE_LONG = 1L;
    private static final double POS_ONE_DOUBLE = 1.0;
    private static final float POS_ONE_FLOAT = 1.0f;
    private static final int NEG_ONE_INT = -1;
    private static final long NEG_ONE_LONG = -1L;
    private static final double NEG_ONE_DOUBLE = -1.0;
    private static final float NEG_ONE_FLOAT = -1.0f;
    private static final String NUM_POS_NAME = "NUMBER_POSITIVE";
    private static final String NUM_ZERO_NAME = "NUMBER_ZERO";
    private static final String NUM_NEG_NAME = "NUMBER_NEGATIVE";

    @Test
    public void testCheckNotNull() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNotNull((Object)NON_NULL_OBJECT, (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNotNull((Object)NULL_OBJECT, (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof NullPointerException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckNotNullWithIAE() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNotNullWithIAE((Object)NON_NULL_OBJECT, (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNotNullWithIAE((Object)NULL_OBJECT, (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckNotNullArrayParam() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNotNullArrayParam((Object)NON_NULL_OBJECT, (int)1, (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNotNullArrayParam((Object)NULL_OBJECT, (int)1, (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckPositiveIntString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkPositive((int)1, (String)NUM_POS_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositive((int)0, (String)NUM_ZERO_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositive((int)-1, (String)NUM_NEG_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckPositiveLongString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkPositive((long)1L, (String)NUM_POS_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositive((long)0L, (String)NUM_ZERO_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositive((long)-1L, (String)NUM_NEG_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckPositiveDoubleString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkPositive((double)1.0, (String)NUM_POS_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositive((double)0.0, (String)NUM_ZERO_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositive((double)-1.0, (String)NUM_NEG_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckPositiveFloatString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkPositive((float)1.0f, (String)NUM_POS_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositive((float)0.0f, (String)NUM_ZERO_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositive((float)-1.0f, (String)NUM_NEG_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckPositiveOrZeroIntString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((int)1, (String)NUM_POS_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((int)0, (String)NUM_ZERO_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((int)-1, (String)NUM_NEG_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckPositiveOrZeroLongString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((long)1L, (String)NUM_POS_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((long)0L, (String)NUM_ZERO_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((long)-1L, (String)NUM_NEG_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckPositiveOrZeroDoubleString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((double)1.0, (String)NUM_POS_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((double)0.0, (String)NUM_ZERO_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((double)-1.0, (String)NUM_NEG_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckPositiveOrZeroFloatString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((float)1.0f, (String)NUM_POS_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((float)0.0f, (String)NUM_ZERO_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkPositiveOrZero((float)-1.0f, (String)NUM_NEG_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckNonEmptyTArrayString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((Object[])((Object[])NULL_OBJECT), (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof NullPointerException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((Object[])NON_NULL_FILLED_OBJECT_ARRAY, (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((Object[])NON_NULL_EMPTY_OBJECT_ARRAY, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckNonEmptyByteArrayString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((byte[])((byte[])NULL_OBJECT), (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof NullPointerException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((byte[])NON_NULL_FILLED_BYTE_ARRAY, (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((byte[])NON_NULL_EMPTY_BYTE_ARRAY, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckNonEmptyCharArrayString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((char[])((char[])NULL_OBJECT), (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof NullPointerException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((char[])NON_NULL_FILLED_CHAR_ARRAY, (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((char[])NON_NULL_EMPTY_CHAR_ARRAY, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckNonEmptyTString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((Object[])((Object[])NULL_OBJECT), (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof NullPointerException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((Object[])NON_NULL_FILLED_OBJECT_ARRAY, (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((Object[])NON_NULL_EMPTY_OBJECT_ARRAY, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }

    @Test
    public void testCheckNonEmptyStringString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((String)((String)NULL_OBJECT), (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof NullPointerException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((String)((String)NON_NULL_OBJECT), (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((String)NON_NULL_EMPTY_STRING, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((String)NON_NULL_WHITESPACE_STRING, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
    }

    @Test
    public void testCheckNonEmptyCharSequenceString() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((CharSequence)NULL_CHARSEQUENCE, (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof NullPointerException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((CharSequence)NON_NULL_CHARSEQUENCE, (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((CharSequence)NON_NULL_EMPTY_CHARSEQUENCE, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmpty((CharSequence)NON_NULL_WHITESPACE_STRING, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
    }

    @Test
    public void testCheckNonEmptyAfterTrim() {
        Exception actualEx = null;
        try {
            ObjectUtil.checkNonEmptyAfterTrim((String)((String)NULL_OBJECT), (String)NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof NullPointerException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmptyAfterTrim((String)((String)NON_NULL_OBJECT), (String)NON_NULL_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNull((Object)actualEx, (String)TEST_RESULT_NULLEX_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmptyAfterTrim((String)NON_NULL_EMPTY_STRING, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
        actualEx = null;
        try {
            ObjectUtil.checkNonEmptyAfterTrim((String)NON_NULL_WHITESPACE_STRING, (String)NON_NULL_EMPTY_NAME);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assertions.assertNotNull((Object)actualEx, (String)TEST_RESULT_NULLEX_OK);
        Assertions.assertTrue((boolean)(actualEx instanceof IllegalArgumentException), (String)TEST_RESULT_EXTYPE_NOK);
    }
}

