/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.arrow.adapter.jdbc.JdbcParameterBinder;
import org.apache.arrow.adapter.jdbc.MockPreparedStatement;
import org.apache.arrow.adapter.jdbc.binder.ColumnBinder;
import org.apache.arrow.adapter.jdbc.binder.MapBinder;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BaseLargeVariableWidthVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.JsonStringHashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JdbcParameterBinderTest {
    private static final long MILLIS_PER_DAY = 86400000L;
    BufferAllocator allocator;

    @BeforeEach
    void beforeEach() {
        this.allocator = new RootAllocator();
    }

    @AfterEach
    void afterEach() {
        this.allocator.close();
    }

    @Test
    void bindOrder() throws SQLException {
        Schema schema = new Schema(Arrays.asList(Field.nullable((String)"ints0", (ArrowType)new ArrowType.Int(32, true)), Field.nullable((String)"ints1", (ArrowType)new ArrowType.Int(32, true)), Field.nullable((String)"ints2", (ArrowType)new ArrowType.Int(32, true))));
        try (MockPreparedStatement statement = new MockPreparedStatement();
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)root).bind(1, 2).bind(2, 0).build();
            Assertions.assertThat((boolean)binder.next()).isFalse();
            IntVector ints0 = (IntVector)root.getVector(0);
            IntVector ints1 = (IntVector)root.getVector(1);
            IntVector ints2 = (IntVector)root.getVector(2);
            ints0.setSafe(0, 4);
            ints0.setNull(1);
            ints1.setNull(0);
            ints1.setSafe(1, -8);
            ints2.setNull(0);
            ints2.setSafe(1, 12);
            root.setRowCount(2);
            Assertions.assertThat((boolean)binder.next()).isTrue();
            Assertions.assertThat((Object)statement.getParamValue(1)).isNull();
            Assertions.assertThat((Integer)statement.getParamType(1)).isEqualTo(4);
            Assertions.assertThat((Object)statement.getParamValue(2)).isEqualTo((Object)4);
            Assertions.assertThat((Object)statement.getParam(3)).isNull();
            Assertions.assertThat((boolean)binder.next()).isTrue();
            Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)12);
            Assertions.assertThat((Object)statement.getParamValue(2)).isNull();
            Assertions.assertThat((Integer)statement.getParamType(2)).isEqualTo(4);
            Assertions.assertThat((Object)statement.getParam(3)).isNull();
            Assertions.assertThat((boolean)binder.next()).isFalse();
            binder.reset();
            ints0.setNull(0);
            ints0.setSafe(1, -2);
            ints2.setNull(0);
            ints2.setSafe(1, 6);
            root.setRowCount(2);
            Assertions.assertThat((boolean)binder.next()).isTrue();
            Assertions.assertThat((Object)statement.getParamValue(1)).isNull();
            Assertions.assertThat((Integer)statement.getParamType(1)).isEqualTo(4);
            Assertions.assertThat((Object)statement.getParamValue(2)).isNull();
            Assertions.assertThat((Integer)statement.getParamType(2)).isEqualTo(4);
            Assertions.assertThat((boolean)binder.next()).isTrue();
            Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)6);
            Assertions.assertThat((Object)statement.getParamValue(2)).isEqualTo((Object)-2);
            Assertions.assertThat((Object)statement.getParam(3)).isNull();
            Assertions.assertThat((boolean)binder.next()).isFalse();
        }
    }

    @Test
    void customBinder() throws SQLException {
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"ints0", (ArrowType)new ArrowType.Int(32, true))));
        try (MockPreparedStatement statement = new MockPreparedStatement();
             final VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)root).bind(1, new ColumnBinder(){
                private final IntVector vector;
                {
                    this.vector = (IntVector)root.getVector(0);
                }

                public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
                    Integer value = this.vector.getObject(rowIndex);
                    if (value == null) {
                        statement.setString(parameterIndex, "null");
                    } else {
                        statement.setString(parameterIndex, Integer.toString(value));
                    }
                }

                public int getJdbcType() {
                    return 4;
                }

                public FieldVector getVector() {
                    return this.vector;
                }
            }).build();
            Assertions.assertThat((boolean)binder.next()).isFalse();
            IntVector ints = (IntVector)root.getVector(0);
            ints.setSafe(0, 4);
            ints.setNull(1);
            root.setRowCount(2);
            Assertions.assertThat((boolean)binder.next()).isTrue();
            Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)"4");
            Assertions.assertThat((boolean)binder.next()).isTrue();
            Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)"null");
            Assertions.assertThat((boolean)binder.next()).isFalse();
        }
    }

    @Test
    void bool() throws SQLException {
        this.testSimpleType((ArrowType)ArrowType.Bool.INSTANCE, 16, (vector, index, value) -> vector.setSafe(index.intValue(), value != false ? 1 : 0), BaseFixedWidthVector::setNull, Arrays.asList(true, false, true));
    }

    @Test
    void int8() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Int(8, true), -6, TinyIntVector::setSafe, BaseFixedWidthVector::setNull, Arrays.asList((byte)127, (byte)-128, (byte)42));
    }

    @Test
    void int16() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Int(16, true), 5, SmallIntVector::setSafe, BaseFixedWidthVector::setNull, Arrays.asList((short)Short.MAX_VALUE, (short)Short.MIN_VALUE, (short)42));
    }

    @Test
    void int32() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Int(32, true), 4, IntVector::setSafe, BaseFixedWidthVector::setNull, Arrays.asList(Integer.MAX_VALUE, Integer.MIN_VALUE, 42));
    }

    @Test
    void int64() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Int(64, true), -5, BigIntVector::setSafe, BaseFixedWidthVector::setNull, Arrays.asList(Long.MAX_VALUE, Long.MIN_VALUE, 42L));
    }

    @Test
    void float32() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), 7, Float4Vector::setSafe, BaseFixedWidthVector::setNull, Arrays.asList(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.POSITIVE_INFINITY)));
    }

    @Test
    void float64() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), 8, Float8Vector::setSafe, BaseFixedWidthVector::setNull, Arrays.asList(Double.MIN_VALUE, Double.MAX_VALUE, Double.POSITIVE_INFINITY));
    }

    @Test
    void time32() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Time(TimeUnit.SECOND, 32), 92, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), (int)(value.getTime() / 1000L)), BaseFixedWidthVector::setNull, Arrays.asList(new Time(-128000L), new Time(104000L), new Time(-42000L)));
        this.testSimpleType((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32), 92, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), (int)value.getTime()), BaseFixedWidthVector::setNull, Arrays.asList(new Time(-128000L), new Time(104000L), new Time(-42000L)));
    }

    @Test
    void time64() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Time(TimeUnit.MICROSECOND, 64), 92, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), (long)((int)(value.getTime() * 1000L))), BaseFixedWidthVector::setNull, Arrays.asList(new Time(-128000L), new Time(104000L), new Time(-42000L)));
        this.testSimpleType((ArrowType)new ArrowType.Time(TimeUnit.NANOSECOND, 64), 92, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), (long)((int)(value.getTime() * 1000000L))), BaseFixedWidthVector::setNull, Arrays.asList(new Time(-128L), new Time(104L), new Time(-42L)));
    }

    @Test
    void date32() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Date(DateUnit.DAY), 91, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), (int)(value.getTime() / 86400000L)), BaseFixedWidthVector::setNull, Arrays.asList(new Date(-432000000L), new Date(172800000L), new Date(86400000L)));
    }

    @Test
    void date64() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Date(DateUnit.MILLISECOND), 91, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), value.getTime()), BaseFixedWidthVector::setNull, Arrays.asList(new Date(-432000000L), new Date(172800000L), new Date(86400000L)));
    }

    @Test
    void timestamp() throws SQLException {
        List<Timestamp> values = Arrays.asList(new Timestamp(-128000L), new Timestamp(104000L), new Timestamp(-42000L));
        this.testSimpleType((ArrowType)new ArrowType.Timestamp(TimeUnit.SECOND, null), 93, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), value.getTime() / 1000L), BaseFixedWidthVector::setNull, values);
        this.testSimpleType((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null), 93, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), value.getTime()), BaseFixedWidthVector::setNull, values);
        this.testSimpleType((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null), 93, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), value.getTime() * 1000L), BaseFixedWidthVector::setNull, values);
        this.testSimpleType((ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, null), 93, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), value.getTime() * 1000000L), BaseFixedWidthVector::setNull, values);
    }

    @Test
    void timestampTz() throws SQLException {
        List<Timestamp> values = Arrays.asList(new Timestamp(-128000L), new Timestamp(104000L), new Timestamp(-42000L));
        this.testSimpleType((ArrowType)new ArrowType.Timestamp(TimeUnit.SECOND, "UTC"), 2014, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), value.getTime() / 1000L), BaseFixedWidthVector::setNull, values);
        this.testSimpleType((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "UTC"), 2014, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), value.getTime()), BaseFixedWidthVector::setNull, values);
        this.testSimpleType((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, "UTC"), 2014, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), value.getTime() * 1000L), BaseFixedWidthVector::setNull, values);
        this.testSimpleType((ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, "UTC"), 2014, (valueVectors, index, value) -> valueVectors.setSafe(index.intValue(), value.getTime() * 1000000L), BaseFixedWidthVector::setNull, values);
    }

    @Test
    void utf8() throws SQLException {
        this.testSimpleType((ArrowType)ArrowType.Utf8.INSTANCE, 12, (vector, index, value) -> vector.setSafe(index.intValue(), value.getBytes(StandardCharsets.UTF_8)), BaseVariableWidthVector::setNull, Arrays.asList("", "foobar", "abc"));
    }

    @Test
    void largeUtf8() throws SQLException {
        this.testSimpleType((ArrowType)ArrowType.LargeUtf8.INSTANCE, -1, (vector, index, value) -> vector.setSafe(index.intValue(), value.getBytes(StandardCharsets.UTF_8)), BaseLargeVariableWidthVector::setNull, Arrays.asList("", "foobar", "abc"));
    }

    @Test
    void binary() throws SQLException {
        this.testSimpleType((ArrowType)ArrowType.Binary.INSTANCE, -3, (vector, index, value) -> vector.setSafe(index.intValue(), value), BaseVariableWidthVector::setNull, Arrays.asList(new byte[0], {2, -4}, {0, -1, 127, -128}));
    }

    @Test
    void largeBinary() throws SQLException {
        this.testSimpleType((ArrowType)ArrowType.LargeBinary.INSTANCE, -4, (vector, index, value) -> vector.setSafe(index.intValue(), value), BaseLargeVariableWidthVector::setNull, Arrays.asList(new byte[0], {2, -4}, {0, -1, 127, -128}));
    }

    @Test
    void fixedSizeBinary() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.FixedSizeBinary(3), -2, FixedSizeBinaryVector::setSafe, BaseFixedWidthVector::setNull, Arrays.asList(new byte[3], {1, 2, -4}, {-1, 127, -128}));
    }

    @Test
    void decimal128() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Decimal(12, 3, 128), 3, DecimalVector::setSafe, BaseFixedWidthVector::setNull, Arrays.asList(new BigDecimal("120.429"), new BigDecimal("-10590.123"), new BigDecimal("0.000")));
    }

    @Test
    void decimal256() throws SQLException {
        this.testSimpleType((ArrowType)new ArrowType.Decimal(12, 3, 256), 3, Decimal256Vector::setSafe, BaseFixedWidthVector::setNull, Arrays.asList(new BigDecimal("120.429"), new BigDecimal("-10590.123"), new BigDecimal("0.000")));
    }

    @Test
    void listOfDouble() throws SQLException {
        TriConsumer<ListVector, Integer, Double[]> setValue = (listVector, index, values) -> {
            UnionListWriter writer = listVector.getWriter();
            writer.setPosition(index.intValue());
            writer.startList();
            Arrays.stream(values).forEach(doubleValue -> writer.float8().writeFloat8(doubleValue.doubleValue()));
            writer.endList();
            listVector.setLastSet(index.intValue());
        };
        List values2 = Arrays.asList({0.0, Math.PI}, {1.1, -352346.2, 2355.6}, {-1024.3}, new Double[0]);
        this.testListType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), setValue, ListVector::setNull, values2);
    }

    @Test
    void listOfInt64() throws SQLException {
        TriConsumer<ListVector, Integer, Long[]> setValue = (listVector, index, values) -> {
            UnionListWriter writer = listVector.getWriter();
            writer.setPosition(index.intValue());
            writer.startList();
            Arrays.stream(values).forEach(longValue -> writer.bigInt().writeBigInt(longValue.longValue()));
            writer.endList();
            listVector.setLastSet(index.intValue());
        };
        List values2 = Arrays.asList({1L, 2L, 3L}, {4L, 5L}, {512L, 1024L, 2048L, 4096L}, new Long[0]);
        this.testListType((ArrowType)new ArrowType.Int(64, true), setValue, ListVector::setNull, values2);
    }

    @Test
    void listOfInt32() throws SQLException {
        TriConsumer<ListVector, Integer, Integer[]> setValue = (listVector, index, values) -> {
            UnionListWriter writer = listVector.getWriter();
            writer.setPosition(index.intValue());
            writer.startList();
            Arrays.stream(values).forEach(integerValue -> writer.integer().writeInt(integerValue.intValue()));
            writer.endList();
            listVector.setLastSet(index.intValue());
        };
        List values2 = Arrays.asList({1, 2, 3}, {4, 5}, {512, 1024, 2048, 4096}, new Integer[0]);
        this.testListType((ArrowType)new ArrowType.Int(32, true), setValue, ListVector::setNull, values2);
    }

    @Test
    void listOfBoolean() throws SQLException {
        TriConsumer<ListVector, Integer, Boolean[]> setValue = (listVector, index, values) -> {
            UnionListWriter writer = listVector.getWriter();
            writer.setPosition(index.intValue());
            writer.startList();
            Arrays.stream(values).forEach(booleanValue -> writer.bit().writeBit(booleanValue != false ? 1 : 0));
            writer.endList();
            listVector.setLastSet(index.intValue());
        };
        List values2 = Arrays.asList({true, false}, {false, false}, {true, true, false, true}, new Boolean[0]);
        this.testListType((ArrowType)new ArrowType.Bool(), setValue, ListVector::setNull, values2);
    }

    @Test
    void listOfString() throws SQLException {
        TriConsumer<ListVector, Integer, String[]> setValue = (listVector, index, values) -> {
            UnionListWriter writer = listVector.getWriter();
            writer.setPosition(index.intValue());
            writer.startList();
            Arrays.stream(values).forEach(stringValue -> {
                if (stringValue != null) {
                    byte[] stringValueBytes = stringValue.getBytes(StandardCharsets.UTF_8);
                    ArrowBuf stringBuffer = this.allocator.buffer((long)stringValueBytes.length);
                    Throwable throwable = null;
                    try {
                        stringBuffer.writeBytes(stringValueBytes);
                        writer.varChar().writeVarChar(0, stringValueBytes.length, stringBuffer);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stringBuffer != null) {
                            JdbcParameterBinderTest.$closeResource(throwable, (AutoCloseable)stringBuffer);
                        }
                    }
                } else {
                    writer.varChar().writeNull();
                }
            });
            writer.endList();
            listVector.setLastSet(index.intValue());
        };
        List values2 = Arrays.asList({"aaaa", "b1"}, {"c", null, "d"}, {"e", "f", "g", "h"}, new String[0]);
        this.testListType((ArrowType)new ArrowType.Utf8(), setValue, ListVector::setNull, values2);
    }

    @Test
    void mapOfString() throws SQLException {
        TriConsumer<MapVector, Integer, Map> setValue = (mapVector, index, values) -> {
            UnionMapWriter mapWriter = mapVector.getWriter();
            mapWriter.setPosition(index.intValue());
            mapWriter.startMap();
            values.entrySet().forEach(mapValue -> {
                block13: {
                    if (mapValue != null) {
                        byte[] keyBytes = ((String)mapValue.getKey()).getBytes(StandardCharsets.UTF_8);
                        byte[] valueBytes = ((String)mapValue.getValue()).getBytes(StandardCharsets.UTF_8);
                        ArrowBuf keyBuf = this.allocator.buffer((long)keyBytes.length);
                        Throwable throwable = null;
                        try {
                            ArrowBuf valueBuf = this.allocator.buffer((long)valueBytes.length);
                            Throwable throwable2 = null;
                            try {
                                mapWriter.startEntry();
                                keyBuf.writeBytes(keyBytes);
                                valueBuf.writeBytes(valueBytes);
                                mapWriter.key().varChar().writeVarChar(0, keyBytes.length, keyBuf);
                                mapWriter.value().varChar().writeVarChar(0, valueBytes.length, valueBuf);
                                mapWriter.endEntry();
                                break block13;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (valueBuf != null) {
                                    JdbcParameterBinderTest.$closeResource(throwable2, (AutoCloseable)valueBuf);
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (keyBuf != null) {
                                JdbcParameterBinderTest.$closeResource(throwable, (AutoCloseable)keyBuf);
                            }
                        }
                    }
                    mapWriter.writeNull();
                }
            });
            mapWriter.endMap();
        };
        JsonStringHashMap value1 = new JsonStringHashMap();
        value1.put((Object)"a", (Object)"b");
        value1.put((Object)"c", (Object)"d");
        JsonStringHashMap value2 = new JsonStringHashMap();
        value2.put((Object)"d", (Object)"e");
        value2.put((Object)"f", (Object)"g");
        value2.put((Object)"k", (Object)"l");
        JsonStringHashMap value3 = new JsonStringHashMap();
        value3.put((Object)"y", (Object)"z");
        value3.put((Object)"arrow", (Object)"cool");
        List<Map> values2 = Arrays.asList(value1, value2, value3, Collections.emptyMap());
        this.testMapType((ArrowType)new ArrowType.Map(true), setValue, ListVector::setNull, values2, (ArrowType)new ArrowType.Utf8());
    }

    @Test
    void mapOfInteger() throws SQLException {
        TriConsumer<MapVector, Integer, Map> setValue = (mapVector, index, values) -> {
            UnionMapWriter mapWriter = mapVector.getWriter();
            mapWriter.setPosition(index.intValue());
            mapWriter.startMap();
            values.entrySet().forEach(mapValue -> {
                if (mapValue != null) {
                    mapWriter.startEntry();
                    mapWriter.key().integer().writeInt(((Integer)mapValue.getKey()).intValue());
                    mapWriter.value().integer().writeInt(((Integer)mapValue.getValue()).intValue());
                    mapWriter.endEntry();
                } else {
                    mapWriter.writeNull();
                }
            });
            mapWriter.endMap();
        };
        JsonStringHashMap value1 = new JsonStringHashMap();
        value1.put((Object)1, (Object)2);
        value1.put((Object)3, (Object)4);
        JsonStringHashMap value2 = new JsonStringHashMap();
        value2.put((Object)5, (Object)6);
        value2.put((Object)7, (Object)8);
        value2.put((Object)9, (Object)1024);
        JsonStringHashMap value3 = new JsonStringHashMap();
        value3.put((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE);
        value3.put((Object)0, (Object)4096);
        List<Map> values2 = Arrays.asList(value1, value2, value3, Collections.emptyMap());
        this.testMapType((ArrowType)new ArrowType.Map(true), setValue, ListVector::setNull, values2, (ArrowType)new ArrowType.Int(32, true));
    }

    <T, V extends FieldVector> void testSimpleType(ArrowType arrowType, int jdbcType, TriConsumer<V, Integer, T> setValue, BiConsumer<V, Integer> setNull, List<T> values) throws SQLException {
        FieldVector vector;
        JdbcParameterBinder binder2;
        Throwable throwable;
        VectorSchemaRoot root;
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"field", (ArrowType)arrowType)));
        try (MockPreparedStatement statement = new MockPreparedStatement();){
            root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
            throwable = null;
            try {
                binder2 = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)root).bindAll().build();
                Assertions.assertThat((boolean)binder2.next()).isFalse();
                vector = root.getVector(0);
                ColumnBinder columnBinder = ColumnBinder.forVector((FieldVector)vector);
                Assertions.assertThat((int)columnBinder.getJdbcType()).isEqualTo(jdbcType);
                setValue.accept(vector, 0, (FieldVector)values.get(0));
                setValue.accept(vector, 1, (FieldVector)values.get(1));
                setNull.accept(vector, 2);
                root.setRowCount(3);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isNull();
                Assertions.assertThat((Integer)statement.getParamType(1)).isEqualTo(jdbcType);
                Assertions.assertThat((boolean)binder2.next()).isFalse();
                binder2.reset();
                setNull.accept(vector, 0);
                setValue.accept(vector, 1, (FieldVector)values.get(2));
                setValue.accept(vector, 2, (FieldVector)values.get(0));
                setValue.accept(vector, 3, (FieldVector)values.get(2));
                setValue.accept(vector, 4, (FieldVector)values.get(1));
                root.setRowCount(5);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isNull();
                Assertions.assertThat((Integer)statement.getParamType(1)).isEqualTo(jdbcType);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(2));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(2));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder2.next()).isFalse();
            }
            catch (Throwable binder2) {
                throwable = binder2;
                throw binder2;
            }
            finally {
                if (root != null) {
                    JdbcParameterBinderTest.$closeResource(throwable, (AutoCloseable)root);
                }
            }
        }
        schema = new Schema(Collections.singletonList(Field.notNullable((String)"field", (ArrowType)arrowType)));
        statement = new MockPreparedStatement();
        var8_8 = null;
        try {
            root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
            throwable = null;
            try {
                binder2 = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)root).bindAll().build();
                Assertions.assertThat((boolean)binder2.next()).isFalse();
                vector = root.getVector(0);
                setValue.accept(vector, 0, (FieldVector)values.get(0));
                setValue.accept(vector, 1, (FieldVector)values.get(1));
                root.setRowCount(2);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder2.next()).isFalse();
                binder2.reset();
                setValue.accept(vector, 0, (FieldVector)values.get(0));
                setValue.accept(vector, 1, (FieldVector)values.get(2));
                setValue.accept(vector, 2, (FieldVector)values.get(0));
                setValue.accept(vector, 3, (FieldVector)values.get(2));
                setValue.accept(vector, 4, (FieldVector)values.get(1));
                root.setRowCount(5);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(2));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(2));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder2.next()).isFalse();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (root != null) {
                    JdbcParameterBinderTest.$closeResource(throwable, (AutoCloseable)root);
                }
            }
        }
        catch (Throwable throwable3) {
            var8_8 = throwable3;
            throw throwable3;
        }
        finally {
            JdbcParameterBinderTest.$closeResource(var8_8, statement);
        }
    }

    <T, V extends FieldVector> void testListType(ArrowType arrowType, TriConsumer<V, Integer, T> setValue, BiConsumer<V, Integer> setNull, List<T> values) throws SQLException {
        FieldVector vector;
        JdbcParameterBinder binder2;
        Throwable throwable;
        VectorSchemaRoot root;
        int jdbcType = 2003;
        Schema schema = new Schema(Collections.singletonList(new Field("field", FieldType.nullable((ArrowType)new ArrowType.List()), Collections.singletonList(new Field("element", FieldType.notNullable((ArrowType)arrowType), null)))));
        try (MockPreparedStatement statement = new MockPreparedStatement();){
            root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
            throwable = null;
            try {
                binder2 = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)root).bindAll().build();
                Assertions.assertThat((boolean)binder2.next()).isFalse();
                vector = root.getVector(0);
                ColumnBinder columnBinder = ColumnBinder.forVector((FieldVector)vector);
                Assertions.assertThat((int)columnBinder.getJdbcType()).isEqualTo(jdbcType);
                setValue.accept(vector, 0, (FieldVector)values.get(0));
                setValue.accept(vector, 1, (FieldVector)values.get(1));
                setNull.accept(vector, 2);
                root.setRowCount(3);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isNull();
                Assertions.assertThat((Integer)statement.getParamType(1)).isEqualTo(jdbcType);
                Assertions.assertThat((boolean)binder2.next()).isFalse();
                binder2.reset();
                setNull.accept(vector, 0);
                setValue.accept(vector, 1, (FieldVector)values.get(3));
                setValue.accept(vector, 2, (FieldVector)values.get(0));
                setValue.accept(vector, 3, (FieldVector)values.get(2));
                setValue.accept(vector, 4, (FieldVector)values.get(1));
                root.setRowCount(5);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isNull();
                Assertions.assertThat((Integer)statement.getParamType(1)).isEqualTo(jdbcType);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(3));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(2));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder2.next()).isFalse();
            }
            catch (Throwable binder2) {
                throwable = binder2;
                throw binder2;
            }
            finally {
                if (root != null) {
                    JdbcParameterBinderTest.$closeResource(throwable, (AutoCloseable)root);
                }
            }
        }
        schema = new Schema(Collections.singletonList(new Field("field", FieldType.notNullable((ArrowType)new ArrowType.List()), Collections.singletonList(new Field("element", FieldType.notNullable((ArrowType)arrowType), null)))));
        statement = new MockPreparedStatement();
        var8_8 = null;
        try {
            root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
            throwable = null;
            try {
                binder2 = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)root).bindAll().build();
                Assertions.assertThat((boolean)binder2.next()).isFalse();
                vector = root.getVector(0);
                setValue.accept(vector, 0, (FieldVector)values.get(0));
                setValue.accept(vector, 1, (FieldVector)values.get(1));
                root.setRowCount(2);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder2.next()).isFalse();
                binder2.reset();
                setValue.accept(vector, 0, (FieldVector)values.get(0));
                setValue.accept(vector, 1, (FieldVector)values.get(2));
                setValue.accept(vector, 2, (FieldVector)values.get(0));
                setValue.accept(vector, 3, (FieldVector)values.get(2));
                setValue.accept(vector, 4, (FieldVector)values.get(1));
                root.setRowCount(5);
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(2));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(2));
                Assertions.assertThat((boolean)binder2.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder2.next()).isFalse();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (root != null) {
                    JdbcParameterBinderTest.$closeResource(throwable, (AutoCloseable)root);
                }
            }
        }
        catch (Throwable throwable3) {
            var8_8 = throwable3;
            throw throwable3;
        }
        finally {
            JdbcParameterBinderTest.$closeResource(var8_8, statement);
        }
    }

    <T, V extends FieldVector> void testMapType(ArrowType arrowType, TriConsumer<V, Integer, T> setValue, BiConsumer<V, Integer> setNull, List<T> values, ArrowType elementType) throws SQLException {
        Throwable throwable;
        VectorSchemaRoot root;
        int jdbcType = 12;
        FieldType keyType = new FieldType(false, elementType, null, null);
        FieldType mapType = new FieldType(false, (ArrowType)ArrowType.Struct.INSTANCE, null, null);
        Schema schema = new Schema(Collections.singletonList(new Field("field", FieldType.nullable((ArrowType)arrowType), Collections.singletonList(new Field("key", mapType, Arrays.asList(new Field("key", keyType, null), new Field("value", keyType, null)))))));
        try (MockPreparedStatement statement = new MockPreparedStatement();){
            root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
            throwable = null;
            try {
                JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)root).bindAll().build();
                Assertions.assertThat((boolean)binder.next()).isFalse();
                FieldVector vector = root.getVector(0);
                ColumnBinder columnBinder = ColumnBinder.forVector((FieldVector)vector);
                Assertions.assertThat((int)columnBinder.getJdbcType()).isEqualTo(jdbcType);
                setValue.accept(vector, 0, (FieldVector)values.get(0));
                setValue.accept(vector, 1, (FieldVector)values.get(1));
                setNull.accept(vector, 2);
                root.setRowCount(3);
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)values.get(0).toString());
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)values.get(1).toString());
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isNull();
                Assertions.assertThat((Integer)statement.getParamType(1)).isEqualTo(jdbcType);
                Assertions.assertThat((boolean)binder.next()).isFalse();
                binder.reset();
                setNull.accept(vector, 0);
                setValue.accept(vector, 1, (FieldVector)values.get(3));
                setValue.accept(vector, 2, (FieldVector)values.get(0));
                setValue.accept(vector, 3, (FieldVector)values.get(2));
                setValue.accept(vector, 4, (FieldVector)values.get(1));
                root.setRowCount(5);
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isNull();
                Assertions.assertThat((Integer)statement.getParamType(1)).isEqualTo(jdbcType);
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)values.get(3).toString());
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)values.get(0).toString());
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)values.get(2).toString());
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo((Object)values.get(1).toString());
                Assertions.assertThat((boolean)binder.next()).isFalse();
            }
            catch (Throwable binder) {
                throwable = binder;
                throw binder;
            }
            finally {
                if (root != null) {
                    JdbcParameterBinderTest.$closeResource(throwable, (AutoCloseable)root);
                }
            }
        }
        schema = new Schema(Collections.singletonList(new Field("field", FieldType.notNullable((ArrowType)arrowType), Collections.singletonList(new Field("key", mapType, Arrays.asList(new Field("key", keyType, null), new Field("value", keyType, null)))))));
        statement = new MockPreparedStatement();
        var11_11 = null;
        try {
            root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
            throwable = null;
            try {
                FieldVector vector = root.getVector(0);
                JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)root).bind(1, (ColumnBinder)new MapBinder((MapVector)vector, 1111)).build();
                Assertions.assertThat((boolean)binder.next()).isFalse();
                setValue.accept(vector, 0, (FieldVector)values.get(0));
                setValue.accept(vector, 1, (FieldVector)values.get(1));
                root.setRowCount(2);
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder.next()).isFalse();
                binder.reset();
                setValue.accept(vector, 0, (FieldVector)values.get(0));
                setValue.accept(vector, 1, (FieldVector)values.get(2));
                setValue.accept(vector, 2, (FieldVector)values.get(0));
                setValue.accept(vector, 3, (FieldVector)values.get(2));
                setValue.accept(vector, 4, (FieldVector)values.get(1));
                root.setRowCount(5);
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(2));
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(0));
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(2));
                Assertions.assertThat((boolean)binder.next()).isTrue();
                Assertions.assertThat((Object)statement.getParamValue(1)).isEqualTo(values.get(1));
                Assertions.assertThat((boolean)binder.next()).isFalse();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (root != null) {
                    JdbcParameterBinderTest.$closeResource(throwable, (AutoCloseable)root);
                }
            }
        }
        catch (Throwable throwable3) {
            var11_11 = throwable3;
            throw throwable3;
        }
        finally {
            JdbcParameterBinderTest.$closeResource(var11_11, statement);
        }
    }

    @FunctionalInterface
    static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

