/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.ObjectMapperFactory;
import org.apache.arrow.vector.util.Text;
import org.junit.Assert;

public class JdbcToArrowTestHelper {
    public static void assertIntVectorValues(IntVector intVector, int rowCount, Integer[] values) {
        Assert.assertEquals((long)rowCount, (long)intVector.getValueCount());
        for (int j = 0; j < intVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)intVector.isNull(j));
                continue;
            }
            Assert.assertEquals((long)values[j].intValue(), (long)intVector.get(j));
        }
    }

    public static void assertBooleanVectorValues(BitVector bitVector, int rowCount, Boolean[] values) {
        Assert.assertEquals((long)rowCount, (long)bitVector.getValueCount());
        for (int j = 0; j < bitVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)bitVector.isNull(j));
                continue;
            }
            Assert.assertEquals((Object)values[j], (Object)(bitVector.get(j) == 1 ? 1 : 0));
        }
    }

    public static void assertBitVectorValues(BitVector bitVector, int rowCount, Integer[] values) {
        Assert.assertEquals((long)rowCount, (long)bitVector.getValueCount());
        for (int j = 0; j < bitVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)bitVector.isNull(j));
                continue;
            }
            Assert.assertEquals((long)values[j].intValue(), (long)bitVector.get(j));
        }
    }

    public static void assertTinyIntVectorValues(TinyIntVector tinyIntVector, int rowCount, Integer[] values) {
        Assert.assertEquals((long)rowCount, (long)tinyIntVector.getValueCount());
        for (int j = 0; j < tinyIntVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)tinyIntVector.isNull(j));
                continue;
            }
            Assert.assertEquals((long)values[j].intValue(), (long)tinyIntVector.get(j));
        }
    }

    public static void assertSmallIntVectorValues(SmallIntVector smallIntVector, int rowCount, Integer[] values) {
        Assert.assertEquals((long)rowCount, (long)smallIntVector.getValueCount());
        for (int j = 0; j < smallIntVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)smallIntVector.isNull(j));
                continue;
            }
            Assert.assertEquals((long)values[j].intValue(), (long)smallIntVector.get(j));
        }
    }

    public static void assertBigIntVectorValues(BigIntVector bigIntVector, int rowCount, Long[] values) {
        Assert.assertEquals((long)rowCount, (long)bigIntVector.getValueCount());
        for (int j = 0; j < bigIntVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)bigIntVector.isNull(j));
                continue;
            }
            Assert.assertEquals((long)values[j], (long)bigIntVector.get(j));
        }
    }

    public static void assertDecimalVectorValues(DecimalVector decimalVector, int rowCount, BigDecimal[] values) {
        Assert.assertEquals((long)rowCount, (long)decimalVector.getValueCount());
        for (int j = 0; j < decimalVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)decimalVector.isNull(j));
                continue;
            }
            Assert.assertEquals((double)values[j].doubleValue(), (double)decimalVector.getObject(j).doubleValue(), (double)0.0);
        }
    }

    public static void assertFloat8VectorValues(Float8Vector float8Vector, int rowCount, Double[] values) {
        Assert.assertEquals((long)rowCount, (long)float8Vector.getValueCount());
        for (int j = 0; j < float8Vector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)float8Vector.isNull(j));
                continue;
            }
            Assert.assertEquals((double)values[j], (double)float8Vector.get(j), (double)0.01);
        }
    }

    public static void assertFloat4VectorValues(Float4Vector float4Vector, int rowCount, Float[] values) {
        Assert.assertEquals((long)rowCount, (long)float4Vector.getValueCount());
        for (int j = 0; j < float4Vector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)float4Vector.isNull(j));
                continue;
            }
            Assert.assertEquals((double)values[j].floatValue(), (double)float4Vector.get(j), (double)0.01);
        }
    }

    public static void assertTimeVectorValues(TimeMilliVector timeMilliVector, int rowCount, Long[] values) {
        Assert.assertEquals((long)rowCount, (long)timeMilliVector.getValueCount());
        for (int j = 0; j < timeMilliVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)timeMilliVector.isNull(j));
                continue;
            }
            Assert.assertEquals((long)values[j], (long)timeMilliVector.get(j));
        }
    }

    public static void assertDateVectorValues(DateDayVector dateDayVector, int rowCount, Integer[] values) {
        Assert.assertEquals((long)rowCount, (long)dateDayVector.getValueCount());
        for (int j = 0; j < dateDayVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)dateDayVector.isNull(j));
                continue;
            }
            Assert.assertEquals((long)values[j].longValue(), (long)dateDayVector.get(j));
        }
    }

    public static void assertTimeStampVectorValues(TimeStampVector timeStampVector, int rowCount, Long[] values) {
        Assert.assertEquals((long)rowCount, (long)timeStampVector.getValueCount());
        for (int j = 0; j < timeStampVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)timeStampVector.isNull(j));
                continue;
            }
            Assert.assertEquals((long)values[j], (long)timeStampVector.get(j));
        }
    }

    public static void assertVarBinaryVectorValues(VarBinaryVector varBinaryVector, int rowCount, byte[][] values) {
        Assert.assertEquals((long)rowCount, (long)varBinaryVector.getValueCount());
        for (int j = 0; j < varBinaryVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)varBinaryVector.isNull(j));
                continue;
            }
            Assert.assertArrayEquals((byte[])values[j], (byte[])varBinaryVector.get(j));
        }
    }

    public static void assertVarcharVectorValues(VarCharVector varCharVector, int rowCount, byte[][] values) {
        Assert.assertEquals((long)rowCount, (long)varCharVector.getValueCount());
        for (int j = 0; j < varCharVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)varCharVector.isNull(j));
                continue;
            }
            Assert.assertArrayEquals((byte[])values[j], (byte[])varCharVector.get(j));
        }
    }

    public static void assertNullVectorValues(NullVector vector, int rowCount) {
        Assert.assertEquals((long)rowCount, (long)vector.getValueCount());
    }

    public static void assertListVectorValues(ListVector listVector, int rowCount, Integer[][] values) {
        Assert.assertEquals((long)rowCount, (long)listVector.getValueCount());
        for (int j = 0; j < listVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)listVector.isNull(j));
                continue;
            }
            List list = listVector.getObject(j);
            Assert.assertEquals(Arrays.asList(values[j]), (Object)list);
        }
    }

    public static void assertMapVectorValues(MapVector mapVector, int rowCount, Map<String, String>[] values) {
        Assert.assertEquals((long)rowCount, (long)mapVector.getValueCount());
        for (int j = 0; j < mapVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assert.assertTrue((boolean)mapVector.isNull(j));
                continue;
            }
            JsonStringArrayList actualSource = (JsonStringArrayList)mapVector.getObject(j);
            Map actualMap = null;
            if (actualSource != null && !actualSource.isEmpty()) {
                actualMap = actualSource.stream().map(entry -> new AbstractMap.SimpleEntry<String, Object>(((Text)entry.get((Object)"key")).toString(), (entry.get((Object)"value") != null ? ((Text)entry.get((Object)"value")).toString() : null))).collect(HashMap::new, (collector, val) -> collector.put((String)val.getKey(), (String)val.getValue()), HashMap::putAll);
            }
            Assert.assertEquals(values[j], actualMap);
        }
    }

    public static Map<String, String>[] getMapValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Map[] maps = new Map[dataArr.length];
        ObjectMapper objectMapper = ObjectMapperFactory.newObjectMapper();
        TypeReference<Map<String, String>> typeReference = new TypeReference<Map<String, String>>(){};
        for (int idx = 0; idx < dataArr.length; ++idx) {
            String jsonString = dataArr[idx].replace("|", ",");
            if (jsonString.isEmpty()) continue;
            try {
                maps[idx] = (Map)objectMapper.readValue(jsonString, (TypeReference)typeReference);
                continue;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return maps;
    }

    public static void assertNullValues(BaseValueVector vector, int rowCount) {
        Assert.assertEquals((long)rowCount, (long)vector.getValueCount());
        for (int j = 0; j < vector.getValueCount(); ++j) {
            Assert.assertTrue((boolean)vector.isNull(j));
        }
    }

    public static void assertFieldMetadataIsEmpty(VectorSchemaRoot schema) {
        Assert.assertNotNull((Object)schema);
        Assert.assertNotNull((Object)schema.getSchema());
        Assert.assertNotNull((Object)schema.getSchema().getFields());
        for (Field field : schema.getSchema().getFields()) {
            Assert.assertNotNull((Object)field.getMetadata());
            Assert.assertEquals((long)0L, (long)field.getMetadata().size());
        }
    }

    public static void assertFieldMetadataMatchesResultSetMetadata(ResultSetMetaData rsmd, Schema schema) throws SQLException {
        Assert.assertNotNull((Object)schema);
        Assert.assertNotNull((Object)schema.getFields());
        Assert.assertNotNull((Object)rsmd);
        List fields = schema.getFields();
        Assert.assertEquals((long)rsmd.getColumnCount(), (long)fields.size());
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            Map metadata = ((Field)fields.get(i - 1)).getMetadata();
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)5L, (long)metadata.size());
            Assert.assertEquals((Object)rsmd.getCatalogName(i), metadata.get("SQL_CATALOG_NAME"));
            Assert.assertEquals((Object)rsmd.getSchemaName(i), metadata.get("SQL_SCHEMA_NAME"));
            Assert.assertEquals((Object)rsmd.getTableName(i), metadata.get("SQL_TABLE_NAME"));
            Assert.assertEquals((Object)rsmd.getColumnLabel(i), metadata.get("SQL_COLUMN_NAME"));
            Assert.assertEquals((Object)rsmd.getColumnTypeName(i), metadata.get("SQL_TYPE"));
        }
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static Integer[] getIntValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Integer[] valueArr = new Integer[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Integer.valueOf(Integer.parseInt(data));
        }
        return valueArr;
    }

    public static Boolean[] getBooleanValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Boolean[] valueArr = new Boolean[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Boolean.valueOf(data.trim().equals("1"));
        }
        return valueArr;
    }

    public static BigDecimal[] getDecimalValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        BigDecimal[] valueArr = new BigDecimal[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : new BigDecimal(data);
        }
        return valueArr;
    }

    public static Double[] getDoubleValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Double[] valueArr = new Double[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Double.valueOf(Double.parseDouble(data));
        }
        return valueArr;
    }

    public static Float[] getFloatValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Float[] valueArr = new Float[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Float.valueOf(Float.parseFloat(data));
        }
        return valueArr;
    }

    public static Long[] getLongValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Long[] valueArr = new Long[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Long.valueOf(Long.parseLong(data));
        }
        return valueArr;
    }

    public static byte[][] getCharArray(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        byte[][] valueArr = new byte[dataArr.length][];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : data.trim().getBytes();
        }
        return valueArr;
    }

    public static byte[][] getCharArrayWithCharSet(String[] values, String dataType, Charset charSet) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        byte[][] valueArr = new byte[dataArr.length][];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : data.trim().getBytes(charSet);
        }
        return valueArr;
    }

    public static byte[][] getBinaryValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        byte[][] valueArr = new byte[dataArr.length][];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : JdbcToArrowTestHelper.hexStringToByteArray(data.trim());
        }
        return valueArr;
    }

    public static String[] getValues(String[] values, String dataType) {
        String value = "";
        for (String val : values) {
            if (!val.startsWith(dataType)) continue;
            value = val.split("=")[1];
            break;
        }
        return value.split(",");
    }

    public static Integer[][] getListValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        return JdbcToArrowTestHelper.getListValues(dataArr);
    }

    public static Integer[][] getListValues(String[] dataArr) {
        Integer[][] valueArr = new Integer[dataArr.length][];
        int i = 0;
        for (String data : dataArr) {
            if ("null".equals(data.trim())) {
                valueArr[i++] = null;
                continue;
            }
            if ("()".equals(data.trim())) {
                valueArr[i++] = new Integer[0];
                continue;
            }
            String[] row = data.replace("(", "").replace(")", "").split(";");
            Integer[] arr = new Integer[row.length];
            for (int j = 0; j < arr.length; ++j) {
                arr[j] = "null".equals(row[j]) ? null : Integer.valueOf(Integer.parseInt(row[j]));
            }
            valueArr[i++] = arr;
        }
        return valueArr;
    }
}

