/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcToArrowCharSetTest
extends AbstractJdbcToArrowTest {
    private static final String[] testFiles = new String[]{"h2/test1_charset_h2.yml", "h2/test1_charset_ch_h2.yml", "h2/test1_charset_jp_h2.yml", "h2/test1_charset_kr_h2.yml"};

    public JdbcToArrowCharSetTest(Table table) {
        this.table = table;
    }

    @Override
    @Before
    public void setUp() throws SQLException, ClassNotFoundException {
        String url = "jdbc:h2:mem:JdbcToArrowTest?characterEncoding=UTF-8";
        String driver = "org.h2.Driver";
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url);
        try (Statement stmt = this.conn.createStatement();){
            stmt.executeUpdate(this.table.getCreate());
            for (String insert : this.table.getData()) {
                stmt.executeUpdate(insert);
            }
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getTestData() throws SQLException, ClassNotFoundException, IOException {
        return Arrays.asList(JdbcToArrowCharSetTest.prepareTestData(testFiles, JdbcToArrowCharSetTest.class));
    }

    @Override
    @Test
    public void testJdbcToArrowValues() throws SQLException, IOException {
        this.testDataSets(this.sqlToArrow(this.conn, this.table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()), false);
        this.testDataSets(this.sqlToArrow(this.conn, this.table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
        this.testDataSets(JdbcToArrowCharSetTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()), false);
        this.testDataSets(JdbcToArrowCharSetTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery())), false);
        this.testDataSets(JdbcToArrowCharSetTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
        this.testDataSets(JdbcToArrowCharSetTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), Calendar.getInstance()), false);
        this.testDataSets(JdbcToArrowCharSetTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).build()), false);
        this.testDataSets(JdbcToArrowCharSetTest.sqlToArrow(this.conn, this.table.getQuery(), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).build()), false);
    }

    @Test
    public void testJdbcSchemaMetadata() throws SQLException {
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(0L), Calendar.getInstance(), true).build();
        ResultSetMetaData rsmd = this.conn.createStatement().executeQuery(this.table.getQuery()).getMetaData();
        Schema schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)rsmd, (JdbcToArrowConfig)config);
        JdbcToArrowTestHelper.assertFieldMetadataMatchesResultSetMetadata(rsmd, schema);
    }

    @Override
    public void testDataSets(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertFieldMetadataIsEmpty(root);
        JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector("CLOB_FIELD15"), this.table.getRowCount(), JdbcToArrowTestHelper.getCharArrayWithCharSet(this.table.getValues(), "CLOB_FIELD15", StandardCharsets.UTF_8));
        JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector("VARCHAR_FIELD13"), this.table.getRowCount(), JdbcToArrowTestHelper.getCharArrayWithCharSet(this.table.getValues(), "VARCHAR_FIELD13", StandardCharsets.UTF_8));
        JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector("CHAR_FIELD16"), this.table.getRowCount(), JdbcToArrowTestHelper.getCharArrayWithCharSet(this.table.getValues(), "CHAR_FIELD16", StandardCharsets.UTF_8));
    }
}

