/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.ResultSetUtility;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcToArrowTest
extends AbstractJdbcToArrowTest {
    private static final String[] testFiles = new String[]{"h2/test1_all_datatypes_h2.yml"};

    public JdbcToArrowTest(Table table, boolean reuseVectorSchemaRoot) {
        this.table = table;
        this.reuseVectorSchemaRoot = reuseVectorSchemaRoot;
    }

    @Parameterized.Parameters(name="table = {0}, reuse batch = {1}")
    public static Collection<Object[]> getTestData() throws SQLException, ClassNotFoundException, IOException {
        return Arrays.stream(JdbcToArrowTest.prepareTestData(testFiles, JdbcToArrowTest.class)).flatMap(row -> Stream.of({row[0], true}, {row[0], false})).collect(Collectors.toList());
    }

    @Override
    @Test
    public void testJdbcToArrowValues() throws SQLException, IOException {
        this.testDataSets(this.sqlToArrow(this.conn, this.table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()), false);
        this.testDataSets(this.sqlToArrow(this.conn, this.table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
        this.testDataSets(JdbcToArrowTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()), false);
        this.testDataSets(JdbcToArrowTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery())), false);
        this.testDataSets(JdbcToArrowTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
        this.testDataSets(JdbcToArrowTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), Calendar.getInstance()), false);
        Calendar calendar = Calendar.getInstance();
        ResultSetMetaData rsmd = this.getQueryMetaData(this.table.getQuery());
        this.testDataSets(JdbcToArrowTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).setJdbcToArrowTypeConverter(this.jdbcToArrowTypeConverter(calendar, rsmd)).build()), true);
        this.testDataSets(JdbcToArrowTest.sqlToArrow(this.conn, this.table.getQuery(), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), calendar).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).setJdbcToArrowTypeConverter(this.jdbcToArrowTypeConverter(calendar, rsmd)).build()), true);
    }

    @Test
    public void testJdbcSchemaMetadata() throws SQLException {
        Calendar calendar = Calendar.getInstance();
        ResultSetMetaData rsmd = this.getQueryMetaData(this.table.getQuery());
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(0L), calendar, true).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setJdbcToArrowTypeConverter(this.jdbcToArrowTypeConverter(calendar, rsmd)).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        Schema schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)rsmd, (JdbcToArrowConfig)config);
        JdbcToArrowTestHelper.assertFieldMetadataMatchesResultSetMetadata(rsmd, schema);
    }

    @Override
    public void testDataSets(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertFieldMetadataIsEmpty(root);
        JdbcToArrowTestHelper.assertBigIntVectorValues((BigIntVector)root.getVector("BIGINT_FIELD5"), this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "BIGINT_FIELD5"));
        JdbcToArrowTestHelper.assertTinyIntVectorValues((TinyIntVector)root.getVector("TINYINT_FIELD3"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "TINYINT_FIELD3"));
        JdbcToArrowTestHelper.assertSmallIntVectorValues((SmallIntVector)root.getVector("SMALLINT_FIELD4"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "SMALLINT_FIELD4"));
        JdbcToArrowTestHelper.assertVarBinaryVectorValues((VarBinaryVector)root.getVector("BINARY_FIELD12"), this.table.getRowCount(), JdbcToArrowTestHelper.getBinaryValues(this.table.getValues(), "BINARY_FIELD12"));
        JdbcToArrowTestHelper.assertVarBinaryVectorValues((VarBinaryVector)root.getVector("BLOB_FIELD14"), this.table.getRowCount(), JdbcToArrowTestHelper.getBinaryValues(this.table.getValues(), "BLOB_FIELD14"));
        JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector("CLOB_FIELD15"), this.table.getRowCount(), JdbcToArrowTestHelper.getCharArray(this.table.getValues(), "CLOB_FIELD15"));
        JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector("VARCHAR_FIELD13"), this.table.getRowCount(), JdbcToArrowTestHelper.getCharArray(this.table.getValues(), "VARCHAR_FIELD13"));
        JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector("CHAR_FIELD16"), this.table.getRowCount(), JdbcToArrowTestHelper.getCharArray(this.table.getValues(), "CHAR_FIELD16"));
        JdbcToArrowTestHelper.assertIntVectorValues((IntVector)root.getVector("INT_FIELD1"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "INT_FIELD1"));
        JdbcToArrowTestHelper.assertBitVectorValues((BitVector)root.getVector("BIT_FIELD17"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "BIT_FIELD17"));
        JdbcToArrowTestHelper.assertBooleanVectorValues((BitVector)root.getVector("BOOL_FIELD2"), this.table.getRowCount(), JdbcToArrowTestHelper.getBooleanValues(this.table.getValues(), "BOOL_FIELD2"));
        JdbcToArrowTestHelper.assertDateVectorValues((DateDayVector)root.getVector("DATE_FIELD10"), this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "DATE_FIELD10"));
        JdbcToArrowTestHelper.assertTimeVectorValues((TimeMilliVector)root.getVector("TIME_FIELD9"), this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "TIME_FIELD9"));
        JdbcToArrowTestHelper.assertTimeStampVectorValues((TimeStampVector)root.getVector("TIMESTAMP_FIELD11"), this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "TIMESTAMP_FIELD11"));
        JdbcToArrowTestHelper.assertDecimalVectorValues((DecimalVector)root.getVector("DECIMAL_FIELD6"), this.table.getRowCount(), JdbcToArrowTestHelper.getDecimalValues(this.table.getValues(), "DECIMAL_FIELD6"));
        JdbcToArrowTestHelper.assertFloat8VectorValues((Float8Vector)root.getVector("DOUBLE_FIELD7"), this.table.getRowCount(), JdbcToArrowTestHelper.getDoubleValues(this.table.getValues(), "DOUBLE_FIELD7"));
        JdbcToArrowTestHelper.assertFloat4VectorValues((Float4Vector)root.getVector("REAL_FIELD8"), this.table.getRowCount(), JdbcToArrowTestHelper.getFloatValues(this.table.getValues(), "REAL_FIELD8"));
        JdbcToArrowTestHelper.assertNullVectorValues((NullVector)root.getVector("NULL_FIELD18"), this.table.getRowCount());
        JdbcToArrowTestHelper.assertListVectorValues((ListVector)root.getVector("LIST_FIELD19"), this.table.getRowCount(), JdbcToArrowTestHelper.getListValues(this.table.getValues(), "LIST_FIELD19"));
        if (isIncludeMapVector) {
            JdbcToArrowTestHelper.assertMapVectorValues((MapVector)root.getVector("MAP_FIELD20"), this.table.getRowCount(), JdbcToArrowTestHelper.getMapValues(this.table.getValues(), "MAP_FIELD20"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runLargeNumberOfRows() throws IOException, SQLException {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        int x = 0;
        int targetRows = 600000;
        ResultSetUtility.MockResultSet rs = ResultSetUtility.generateBasicResultSet(600000);
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
            while (iter.hasNext()) {
                VectorSchemaRoot root = iter.next();
                x += root.getRowCount();
                if (this.reuseVectorSchemaRoot) continue;
                root.close();
            }
        }
        finally {
            allocator.close();
        }
        Assert.assertEquals((long)600000L, (long)x);
    }
}

